<?php
if (!defined('ABSPATH'))
    exit;
/**
 * Main class
 *
 */
if (!class_exists('woo_plus_admin_functions')) {

    class woo_plus_admin_functions
    {


        public static function gpls_woo_rfq_plus_error_notice($error)
        {

            ?>
            <div class="notice error my-acf-notice is-dismissible">
                <?php if ($error == 'price_hidden_with_normal_gateways'): ?>

                    <?php printf(__('%s"Allow Other Payment Methods In RFQ Checkout Mode" requires option 2 "Show prices with RFQ checkout" to also be selected.%s', 'rfqtk'), '<span style="color: red; font-weight: bold">', '</span>'); ?>
                <?php endif; ?>
                <?php if ($error == 'gpls_woo_rfq_rfq_enable_reset'): ?>

                    <?php printf(__('%sProducts have been successfully updated.%s', 'rfqtk'), '<span style="color: red; font-weight: bold; font-size: large">', '</span>'); ?>
                <?php endif; ?>

                <?php if ($error == 'Delay for sending quote'): ?>

                    <?php printf(__('%sDelay for sending quote automatically must be a number%s', 'rfqtk'),'<span style="color: red; font-weight: bold; font-size: large">','</span>'); ?>
                <?php endif; ?>

                <?php if ($error == 'gpls_woo_rfq_bulk_rfq_enable_product_messages'): ?>

                    <?php printf(__('%sContent Marketing for Products have been successfully updated%s', 'rfqtk'),'<span style="color: red; font-weight: bold; font-size: large">','</span>'); ?>
                <?php endif; ?>


            </div>
            <?php
        }

    }

    if (!function_exists('gpls_woo_readonly_text_area_input')) {
        function gpls_woo_readonly_text_area_input($field)
        {
            global $thepostid, $post;

            $thepostid = gpls_empty($thepostid) ? $post->ID : $thepostid;
            $field['placeholder'] = isset($field['placeholder']) ? $field['placeholder'] : '';
            $field['class'] = isset($field['class']) ? $field['class'] : 'short';
            $field['style'] = isset($field['style']) ? $field['style'] : '';
            $field['wrapper_class'] = isset($field['wrapper_class']) ? $field['wrapper_class'] : '';
            $field['value'] = isset($field['value']) ? $field['value'] : get_post_meta($thepostid, $field['id'], true);
            $field['desc_tip'] = isset($field['desc_tip']) ? $field['desc_tip'] : false;
            $field['name'] = isset($field['name']) ? $field['name'] : $field['id'];
            $field['rows'] = isset($field['rows']) ? $field['rows'] : 2;
            $field['cols'] = isset($field['cols']) ? $field['cols'] : 20;

            // Custom attribute handling
            $custom_attributes = array();

            if (!gpls_empty($field['custom_attributes']) && is_array($field['custom_attributes'])) {

                foreach ($field['custom_attributes'] as $attribute => $value) {
                    $custom_attributes[] = esc_attr($attribute) . '="' . esc_attr($value) . '"';
                }
            }

            echo '<p class="form-field ' . esc_attr($field['id']) . '_field ' . esc_attr($field['wrapper_class']) . '">
		<label for="' . esc_attr($field['id']) . '">' . wp_kses_post($field['label']) . '</label>';

            if (!gpls_empty($field['description']) && false !== $field['desc_tip']) {
                echo wc_help_tip($field['description']);
            }

            echo '<textarea class="' . esc_attr($field['class']) . '" style="' . esc_attr($field['style']) . '"  name="' . esc_attr($field['name']) . '" id="' . esc_attr($field['id']) . '" placeholder="' . esc_attr($field['placeholder']) . '" rows="' . esc_attr($field['rows']) . '" cols="' . esc_attr($field['cols']) . '" ' . implode(' ', $custom_attributes) . '>' . esc_textarea($field['value']) . '</textarea> ';

            if (!gpls_empty($field['description']) && false === $field['desc_tip']) {
                echo '<span class="description">' . wp_kses_post($field['description']) . '</span>';
            }

            echo '</p>';
        }
    }

    if (!function_exists('gpls_woo_text_area_input')) {
        function gpls_woo_text_area_input($field)
        {
            global $thepostid, $post;

            $thepostid = gpls_empty($thepostid) ? $post->ID : $thepostid;
            $field['placeholder'] = isset($field['placeholder']) ? $field['placeholder'] : '';
            $field['class'] = isset($field['class']) ? $field['class'] : 'short';
            $field['style'] = isset($field['style']) ? $field['style'] : '';
            $field['wrapper_class'] = isset($field['wrapper_class']) ? $field['wrapper_class'] : '';
            $field['value'] = isset($field['value']) ? $field['value'] : get_post_meta($thepostid, $field['id'], true);
            $field['desc_tip'] = isset($field['desc_tip']) ? $field['desc_tip'] : false;
            $field['name'] = isset($field['name']) ? $field['name'] : $field['id'];
            $field['rows'] = isset($field['rows']) ? $field['rows'] : 2;
            $field['cols'] = isset($field['cols']) ? $field['cols'] : 20;

            // Custom attribute handling
            $custom_attributes = array();

            if (!gpls_empty($field['custom_attributes']) && is_array($field['custom_attributes'])) {

                foreach ($field['custom_attributes'] as $attribute => $value) {
                    $custom_attributes[] = esc_attr($attribute) . '="' . esc_attr($value) . '"';
                }
            }

            echo '<p class="form-field ' . esc_attr($field['id']) . '_field ' . esc_attr($field['wrapper_class']) . '">
		<label for="' . esc_attr($field['id']) . '">' . wp_kses_post($field['label']) . '</label>';

            if (!gpls_empty($field['description']) && false !== $field['desc_tip']) {
                echo wc_help_tip($field['description']);
            }

            echo '<textarea class="' . esc_attr($field['class']) . '" style="' . esc_attr($field['style']) . '"  name="' . esc_attr($field['name']) . '" id="' . esc_attr($field['id']) . '" placeholder="' . esc_attr($field['placeholder']) . '" rows="' . esc_attr($field['rows']) . '" cols="' . esc_attr($field['cols']) . '" ' . implode(' ', $custom_attributes) . '>' . esc_textarea($field['value']) . '</textarea> ';

            if (!gpls_empty($field['description']) && false === $field['desc_tip']) {
                echo '<span class="description">' . wp_kses_post($field['description']) . '</span>';
            }

            echo '</p>';
        }
    }

    if (!function_exists('gpls_woo_rfq_plus_get_ninja_forms')) {
        function gpls_woo_rfq_plus_get_ninja_forms()
        {


            if (!class_exists('Ninja_Forms')) {
                return array('' => printf(__('%sNinja Forms is not active.%s', 'rfqtk'), '<span style="color: red; font-weight: bold">', '</span>'));

            }


            $data = array();

            $all_forms = Ninja_Forms()->form()->get_forms();

            if (isset($all_forms) && count($all_forms) > 0) {

                foreach ($all_forms as $form) {

                    $data[] = array(
                        'id' => $form->get_id(),
                        'title' => $form->get_setting('title'),
                        'shortcode' => apply_filters('ninja_forms_form_list_shortcode', '[ninja_form id=' . $form->get_id() . ']', $form->get_id()),
                        'date' => $form->get_setting('created_at')
                    );
                }


                // d($data);

                $forms = array();

                $first_option = __('No form selected', 'rfqtk');

                $forms[''] = $first_option;

                foreach ($data as $form_data) {

                    $label = $form_data['title'];
                    if (strlen($label) > 30)
                        $label = substr($label, 0, 30) . '...';

                    $forms[$form_data['id']] = $label . ' - ID: ' . $form_data['id'];
                }


                return $forms;


            }
            return array('' => printf(__('%sPlease check Ninja Forms Version 3 installation. At least one form is required.%s', 'rfqtk'), '<span style="color: red; font-weight: bold">', '</span>'));

        }
    }

    if(!function_exists('gpls_woo_rfq_plus_wp_html_editor_input')) {
        function gpls_woo_rfq_plus_wp_html_editor_input($field)
        {
            global $thepostid, $post;

            $thepostid = gpls_empty($thepostid) ? $post->ID : $thepostid;
            $field['placeholder'] = isset($field['placeholder']) ? $field['placeholder'] : '';
            $field['class'] = isset($field['class']) ? $field['class'] : 'short';
            $field['style'] = isset($field['style']) ? $field['style'] : '';
            $field['wrapper_class'] = isset($field['wrapper_class']) ? $field['wrapper_class'] : '';
            $field['value'] = isset($field['value']) ? $field['value'] : get_post_meta($thepostid, $field['id'], true);

            // Custom attribute handling
            $custom_attributes = array();

            if (isset($field['custom_attributes']) && !gpls_empty($field['custom_attributes']) && is_array($field['custom_attributes'])) {

                foreach ($field['custom_attributes'] as $attribute => $value) {
                    $custom_attributes[] = esc_attr($attribute) . '="' . esc_attr($value) . '"';
                }
            }


            $settings = array(
                'tabindex' => 1,
                'textarea_name' => esc_attr($field['id']),
                'editor_class' => $field['class']

            );
            echo '<span class="description">' . wp_kses_post($field['description']) . '</span>';
            if (!gpls_empty($field['description'])) {

                if (isset($field['desc_tip']) && false !== $field['desc_tip']) {
                    echo wc_help_tip($field['description']);
                } else {
                    echo '<span class="description">' . wp_kses_post($field['description']) . '</span>';
                }
            }
            echo '<div><br /></div>';
            echo '<p class="form-field ' . esc_attr($field['id']) . '_field ' . esc_attr($field['wrapper_class']) . '">' . wp_editor(($field['value']), $field['id'], array($settings));


            echo '</p>';
        }
    }

    if (!function_exists('gpls_woo_get_sections_plus')) {

        function gpls_woo_get_sections_plus($sections)
        {
            if (class_exists('GPLS_WOO_RFQ_PLUS')) {

                $sections['add-to-quote'] = __('Quote Button', 'rfqtk');

                $sections['email-options'] = __('Proposal', 'rfqtk');

                $sections['marketing'] = __('Marketing', 'rfqtk');

                $sections['rfq_checkout'] = __('RFQ Checkout', 'rfqtk');

                if (!class_exists('GPLS_WOO_RFQ_FIELD'))
                {
                    $sections['custom-form'] = __('Checkout Form', 'rfqtk');
                }

                $sections['customer-notes'] = __('Notes', 'rfqtk');

                $sections['customer-offer'] = __('Bid', 'rfqtk');

                $sections['sales-staff'] = __('Access by IP', 'rfqtk');
            }




            if (class_exists('GPLS_WOO_RFQ_UPLOAD')) {

                $sections['file-upload'] = __('File Uploads', 'rfqtk');
            }


                

            if (class_exists('GPLS_WOO_RFQ_FIELD') && !class_exists('GPLS_WOO_RFQ_PLUS'))
            {
                $sections['product-fields'] = __('Product Form', 'rfqtk');
                $sections['custom-form'] = __('Checkout Form', 'rfqtk');

            }

            $sections['npoptions'] = __('More Options', 'rfqtk');
            $sections['rfq-toolkit-license'] = __('License', 'rfqtk');



            return $sections;
        }
    }
}


