<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

if ( ! class_exists( 'WC_Email_Admin_Note' ) ) :

/**
 * Admin Note Order Email.
 * This email is sent to admin by customers.

 */
    #[\AllowDynamicProperties]
class WC_Email_Admin_Note extends WC_Email {

	/**
	 * Customer note.
	 *
	 * @var string
	 */
	public $customer_note;

	/**
	 * Constructor.
	 */
	public function __construct() {


	    $this->id             = 'admin_note';
		$this->title          = __( 'RFQ-ToolKit Admin note', 'rfqtk' );
		$this->description    = __( 'Admin note emails are sent to admin when a customer adds a note to an order/quote request.', 'rfqtk' );

		$this->template_html  = 'emails/admin-note.php';
		$this->template_plain = 'emails/plain/admin-note.php';

        //$this->heading = __('Your Quote for  Request #({order_number})', 'rfqtk');

        //$this->subject = __('Note for Order/Request #({order_number}) - {order_date}', 'rfqtk');

        $this->content_intro = $this->format_string($this->get_option( 'content_intro' ));
        $this->email_type='html';
        $this->placeholders   = array(
            '{order_date}'   => '',
            '{order_number}' => '',
            '{customer_name}' => '',
        );
		// Triggers

        add_action('woocommerce_new_admin_note_notification', array($this, 'trigger'));

        $this->customer_email = false;
		// Call parent constructor
		parent::__construct();
        //$this->recipient = get_option( 'admin_email' );
        $this->recipient = $this->get_option( 'recipient', get_option( 'admin_email' ) );

        add_filter('woocommerce_template_directory', array($this, 'gpls_rfq_woocommerce_locate_template_dir'), 10, 2);

	}


    public function get_default_subject()
    {
        return __('Note added to {site_title} order #({order_number}) by {customer_name} on {order_date}', 'rfqtk');
    }

    public function gpls_rfq_woocommerce_locate_template_dir($dir, $template)
    {
        return $dir;
    }

    public function get_default_heading() {
        return __('A note has been added to the order #({order_number}) by {customer_name} on {order_date}', 'rfqtk');
    }

	/**
	 * Trigger.
	 *
	 * @param array $args
	 */
	public function trigger( $args ) {

        $this->setup_locale();

	    if ( isset( $args ) ) {

			$defaults = array(
				'order_id'      => '',
				'customer_note' => ''
			);

			$args = wp_parse_args( $args, $defaults );

			extract( $args );

            if(defined("WC_Email_Admin_Note".$order_id))return;

            define("WC_Email_Admin_Note".$order_id,true);

			if ( $order_id && ( $this->object = wc_get_order( $order_id ) ) ) {

				$this->customer_note = $customer_note;


                $order = WC_Order_Factory::get_order($order_id);

                $customer_name = $order->get_billing_first_name() . ' ' . $order->get_billing_last_name();


                $offer_subject='';

                $accepted_offer = get_post_meta($order->get_id(), '_gpls_accepted_offer', true);

                if($accepted_offer==true) {

                    //$Customer_accepted_offer_of = __('Customer accepted offer of ', "rfqtk");
                   // $accepted_offer_note = $Customer_accepted_offer_of . ' '. $order->order_total();
                    //$offer_subject= $accepted_offer_note;

                }

                //$this->subject = __('Note added to {site_title} order #({order_number}) by {$customer_name} on {order_date}', 'rfqtk');

               // $this->heading = __('A note has been added to the order #({order_number})', 'rfqtk');

                $this->placeholders['{order_date}']   = wc_format_datetime( $this->object->get_date_created() );
                $this->placeholders['{order_number}'] = $this->object->get_order_number();
                $this->placeholders['{customer_name}'] = $customer_name;;


                if ( $this->is_enabled() && $this->get_recipient() ) {

                    $this->send( $this->get_recipient(), $this->get_subject(), $this->get_content(), $this->get_headers(), $this->get_attachments() );
                }


			}
		}

        $this->restore_locale();


	}
    function replace_placeholders( $order_id ) {

        if (defined("WC_Email_Admin_Note_EMAIL" . $order_id)) return;

        define("WC_Email_Admin_Note_EMAIL" . $order_id, true);

        require_once(WC()->plugin_path() . '/includes/emails/class-wc-email.php');
        require_once(WC()->plugin_path() . '/includes/class-wc-emails.php');

        $WC_Emails = WC_Emails::instance();

        $this->setup_locale();

        if ( $order_id ) {
            $this->object  = wc_get_order( $order_id );
          //  $order = wc_get_order( $order_id );
           // $customer_name = $this->object ->get_billing_first_name() . ' ' . $this->object ->get_billing_last_name();
           // $customer_name = "sdsdsdsd";
            $this->placeholders['{order_date}']   = wc_format_datetime( $this->object->get_date_created() );
            $this->placeholders['{order_number}'] = $this->object->get_order_number();
            $this->placeholders['{customer_name}'] = $this->object ->get_billing_first_name() . ' ' . $this->object ->get_billing_last_name();;

        }

        $this->restore_locale();

    }
	/**
	 * Get content html.
	 *
	 * @access public
	 * @return string
	 */
	public function get_content_html() {
		return wc_get_template_html( $this->template_html, array(
			'order'         => $this->object,
			'email_heading' => $this->get_heading(),
            'additional_content' => is_callable(array($this, 'get_additional_content'))?$this->get_additional_content():"",
            'content_intro' => $this->content_intro,
            'customer_note' => $this->customer_note,
			'sent_to_admin' => false,
			'plain_text'    => false,
			'email'			=> $this
		),'',gpls_woo_rfq_plus_DIR . 'woocommerce/' );
	}

	/**
	 * Get content plain.
	 *
	 * @access public
	 * @return string
	 */
	public function get_content_plain() {
		return wc_get_template_html( $this->template_plain, array(
			'order'         => $this->object,
			'email_heading' => $this->get_heading(),
            'additional_content' => is_callable(array($this, 'get_additional_content'))?$this->get_additional_content():"",
			'customer_note' => $this->customer_note,
            'content_intro' => $this->content_intro,
			'sent_to_admin' => false,
			'plain_text'    => true,
			'email'			=> $this
		) ,'',gpls_woo_rfq_plus_DIR . 'woocommerce/');
	}

    public function init_form_fields()
    {
        $placeholder_text  = sprintf( __( 'Available placeholders: %s', 'rfqtk' ), '<code>' . implode( '</code>, <code>', array_keys( $this->placeholders ) ) . '</code>' );

        $this->form_fields = array(
            'enabled' => array(
                'title' => __('Enable/Disable', 'rfqtk'),
                'type' => 'checkbox',
                'label' => __('Enable this email notification', 'rfqtk'),
                'default' => 'yes'
            ),

            'recipient' => array(
                'title'         => __( 'Recipient(s)', 'rfqtk' ),
                'type'          => 'text',
                'description'   => sprintf( __( 'Enter recipients (comma separated) for this email. Defaults to <code>%s</code>.', 'rfqtk' ), esc_attr( get_option('admin_email') ) ),
                'placeholder'   => '',
                'default'       => ''
            ),
            'subject' => array(
                'title'         => __( 'Subject', 'rfqtk' ),
                'description' => $placeholder_text,
                'placeholder' => __($this->get_default_subject(), 'rfqtk' ),
                'css'         => 'width:600px',
                'default'       => ''
            ),
            'heading'            => array(
                'title'       => __( 'Email heading', 'rfqtk' ),
                'type'        => 'text',
                'css'         => 'width:600px',
                'desc_tip'    => true,
                'description' => $placeholder_text,
                'placeholder' => $this->get_default_heading(),
                'default'     => '',
            ),
            'content_intro' => array(
                'title' => __('Content Intro', 'rfqtk'),
                'type' => 'textarea',
                'description' => sprintf(__('This controls the first paragrah contained within the email notification.', 'rfqtk'), $this->heading),
                'placeholder' => __( 'N/A', 'rfqtk' ),
                'css'         => 'width:400px; height: 75px;',
                'default' => '',
                'desc_tip'    => true,

            ),
            'additional_content' => array(
                'title'       => __( 'Additional content', 'rfqtk' ),
                'description' => __( 'Text to appear below the main email content.', 'rfqtk' ),
                'css'         => 'width:400px; height: 75px;',
                'placeholder' => __( 'N/A', 'rfqtk' ),
                'type'        => 'textarea',
                'default'     => '',
                'desc_tip'    => true,
            ),
            'email_type' => array(
                'title' => __('Email type', 'rfqtk'),
                'type' => 'select',
                'description' => __('Choose which format of email to send.', 'rfqtk'),
                'default' => 'html',
                'class' => 'email_type wc-enhanced-select',
                'options' => $this->get_email_type_options()
            )
        );
    }

}

endif;

return new WC_Email_Admin_Note();
