<?php
if (!defined('ABSPATH'))
    exit;
/**
 * Main class
 *
 */

if (!class_exists('rfqtk_notes_functions')) {

    class rfqtk_notes_functions
    {
        function __construct()
        {


            add_action('save_post', 'rfqtk_save_quote_sent_note', -100, 3);


            $show_notes = get_option('settings_gpls_woo_rfq_show_notes', 'yes');

            if ($show_notes == 'yes') {
                add_action('woocommerce_view_order', 'gpls_woo_rfq_plus_file_my_account_orders_notes', -10);
            }

            add_action('woocommerce_view_order', 'gpls_woo_rfq_plus_add_customer_response', -1);


            add_filter('gpls_woo_rfq_customer_notes_styles', 'gpls_woo_rfq_add_to_note_create_styles', 10, 1);

            add_action('wp_dashboard_setup', 'gpls_woo_rfq_add_widget', 999);


            add_action('wp_loaded', 'gpls_woo_rfq_customer_response', 2000);

            add_action('wp_loaded', 'gpls_woo_rfq_plus_save_customer_note', 1000);


        }

    }

}


function gpls_woo_rfq_plus_save_customer_note()
{

    if (isset($_POST['order_id']) && $_POST['order_id'] != '') {


        if (!isset($_POST['_wpnonce']) || !wp_verify_nonce($_POST['_wpnonce'], 'gpls_woo_rfq_Plus_customer_note_form_nonce')) {
            return;
        }

        $of = new WC_Order_Factory();
        $order = $of::get_order($_POST['order_id']);


        if (isset($_POST['gpls_woo_rfq_customer_note']) && trim($_POST["gpls_woo_rfq_customer_note"]) != '') {

            $admin_note = trim($_POST["gpls_woo_rfq_customer_note"]);

            $saved_note = $order->get_customer_order_notes();

            $saved_already = false;

            foreach ($saved_note as $i => $item) {

                if ($item->comment_content == $admin_note) {
                    $saved_already = true;
                }
            }


            if (!$saved_already) {

                gpls_woo_rfq_add_order_note($order, $admin_note, 1, true);

                do_action('woocommerce_new_admin_note', array('order_id' => $order->get_id(),
                    'accepted_offer' => false, 'customer_note' => $admin_note));


                do_action('gplsrfq_new_admin_note', $order->get_id(), $admin_note);
            }

        }

        if (isset($_POST['accept_offer'])) {

            $offer_accepted = get_post_meta($order->get_id(), '_gpls_accepted_offer', true);

            $status = $order->get_status();

            $allow_multiple_offers = get_post_meta($order->get_id(), '_allow_multiple_offers', true);

            if (($offer_accepted !== "yes" || $allow_multiple_offers === "yes")
                && ($status === 'gplsquote-sent' || $status === 'wc-gplsquote-sent')) {
                //   return;

                $Customer_accepted_offer_of = __('Customer accepted offer of ', 'rfqtk');
                $Customer_accepted_offer_of = __($Customer_accepted_offer_of, "rfqtk");

                $accepted_offer_note = $Customer_accepted_offer_of . wc_price($order->get_total());

                gpls_woo_rfq_add_order_note($order, $accepted_offer_note,
                    1, true);

                update_post_meta($order->get_id(), '_gpls_accepted_offer', "yes");

                update_post_meta($order->get_id(), '_gpls_accepted_offer_date', current_time('timestamp'));

                do_action('woocommerce_new_admin_note', array('order_id' => $_POST['order_id'], 'accepted_offer' => true,
                    'customer_note' => $accepted_offer_note));


                $new_status = get_option('settings_gpls_woo_rfq_accept_offer_order_status', 'no');
                //echo $manage_stock; exit;

                if (in_array($order->get_status(), array('wc-gplsquote-sent', 'gplsquote-sent'), true) == true) {
                    if (in_array($new_status, array('wc-pending', 'wc-processing', 'wc-completed'), true) == true) {

                        $order = WC_Order_Factory::get_order($order->get_id());
                        $order->set_status($new_status);
                        $order->save();

                        do_action('woocommerce_before_resend_order_emails', $order, 'customer_invoice');

                        // Send the customer invoice email.
                        WC()->payment_gateways();
                        WC()->shipping();
                        WC()->mailer()->customer_invoice($order);

                        // Note the event.
                        $order->add_order_note(__('Order details sent to customer.', 'rfqtk'), false, true);

                        do_action('woocommerce_after_resend_order_email', $order, 'customer_invoice');


                    }
                }

                do_action('gplsrfq_customer_accepted_offer', $order->get_id());
            }
        }

        if (isset($_POST['gpls_woo_rfq_plus_customer_bid']) && $_POST['gpls_woo_rfq_plus_customer_bid'] != '') {

            update_post_meta($_POST['order_id'], '_woo_rfq_customer_bid', $_POST['gpls_woo_rfq_plus_customer_bid']);

            $of = new WC_Order_Factory();

            $order = $of::get_order($_POST['order_id']);


            $order->update_meta_data('_woo_rfq_customer_bid', $_POST['gpls_woo_rfq_plus_customer_bid']);

            gpls_woo_rfq_add_order_note($order, 'Customer Offer ' . wc_price($_POST['gpls_woo_rfq_plus_customer_bid']), 1, true);
            //gpls_woo_rfq_add_order_note($order, $note, $is_customer_note = 0, $added_by_user = false)
            do_action('woocommerce_new_admin_note', array('order_id' => $order->get_id(),
                'accepted_offer' => false, 'customer_note' => 'Customer Offer ' . wc_price($_POST['gpls_woo_rfq_plus_customer_bid'])));

            do_action('gplsrfq_new_admin_note', $order->get_id(), 'Customer Offer ' . wc_price($_POST['gpls_woo_rfq_plus_customer_bid']));


        }
    }

}


function gpls_woo_rfq_customer_response()
{
    if (isset($_REQUEST['respond_to_offer']) && isset($_REQUEST['id'])
        && strpos($_REQUEST['key'], 'wc_order_', 0) === 0) {


        $of = new WC_Order_Factory();
        $order = $of::get_order($_REQUEST['id']);
        $order_id = $_REQUEST['id'];


        if ($order->get_order_key() == $_REQUEST['key']) {


            $offer_accepted_already = get_post_meta($order->get_id(), '_gpls_accepted_offer', true);

            $status = $order->get_status();

            if ($offer_accepted_already == "yes" || ($status != 'gplsquote-sent' && $status != 'wc-gplsquote-sent')) {
                //return;
            }

            //if ($offer_accepted_already != "yes" || ($status == 'gplsquote-sent' || $status == 'wc-gplsquote-sent')) {
            $allow_multiple_offers = get_post_meta($order->get_id(), '_allow_multiple_offers', true);

            if (($offer_accepted_already !== "yes" || $allow_multiple_offers === "yes")
                && ($status === 'gplsquote-sent' || $status === 'wc-gplsquote-sent')) {

                if (isset($_GET['accept_offer']) && $_GET['accept_offer'] === "true") {

                    $Customer_accepted_offer_of = __('Customer accepted offer of ', 'rfqtk');
                    $Customer_accepted_offer_of = __($Customer_accepted_offer_of, "rfqtk");

                    $accepted_offer_note = $Customer_accepted_offer_of . wc_price($order->get_total());

                    gpls_woo_rfq_add_order_note($order, $accepted_offer_note,
                        1, true);

                    $email = WC()->mailer()->emails['WC_Email_Admin_Note'];
                    $mail = new WC_Email_Admin_Note();

                    $mail->trigger(array('order_id' => $order_id,
                        'accepted_offer' => true,
                        'customer_note' => $accepted_offer_note));

                    update_post_meta($order->get_id(), '_gpls_accepted_offer', "yes");

                    update_post_meta($order->get_id(), '_gpls_accepted_offer_date', current_time('timestamp'));

                    // do_action('woocommerce_new_admin_note', array('order_id' => $order_id,'accepted_offer' => true,'customer_note' => $accepted_offer_note));


                    $new_status = get_option('settings_gpls_woo_rfq_accept_offer_order_status', 'no');

                    if (in_array($new_status, array('wc-pending', 'wc-processing', 'wc-completed'), true) == true) {

                        $order = WC_Order_Factory::get_order($order->get_id());
                        $order->set_status($new_status);
                        $order->save();

                        do_action('woocommerce_before_resend_order_emails', $order, 'customer_invoice');

                        // Send the customer invoice email.
                        WC()->payment_gateways();
                        WC()->shipping();
                        WC()->mailer()->customer_invoice($order);

                        // Note the event.
                        $order->add_order_note(__('Order details sent to customer.', 'rfqtk'), false, true);

                        do_action('woocommerce_after_resend_order_email', $order, 'customer_invoice');

                    }


                    do_action('gplsrfq_customer_accepted_offer', $order->get_id());

                }
            }


            $use_page = get_option('settings_gpls_woo_rfq_customer_note_text_page', 'no');
            global $wpdb;
            $ID = $wpdb->get_var("SELECT ID FROM " . $wpdb->prefix . "posts where post_name='customer-respond' 
                                      and post_status <>'trash'");

            if ($use_page == "no" || $ID == null) {

                wc_get_template('woo-rfq/customer-respond.php', array('order' => $order), '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
                exit;
            }

        }

    }
}


function gpls_woo_rfq_add_widget()
{
    global $wp_meta_boxes;
    $title = get_option('settings_gpls_woo_rfq_limit_dashboard_notes_title', 'Recent Customer Notes');
    $title = __($title, 'rfqtk');

    wp_add_dashboard_widget('rfktoolkit_dashboard_recent_notes', $title, 'gpls_woo_rfq_recent_notes');
}


function gpls_woo_rfq_recent_notes()
{
    $ends = gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key), 'D');
    if ($ends == 1) {
        return;
    }

    $quote_only_string = " ";
    $quote_only = get_option('settings_gpls_woo_rfq_limit_dashboard_notes', 'yes');
    if ($quote_only == 'yes')
    {
        $quote_only_string = "and (posts.post_status='wc-gplsquote-req' or posts.post_status='wc-gplsquote-sent')";
    }

    global $wpdb;
    $num_notes = get_option('settings_gpls_woo_rfq_num_of_notes', 30);
    $comments = $wpdb->get_results("
					
			SELECT posts.ID, posts.post_title,comment_date,comment_date_gmt, comments.comment_author, comments.comment_ID, SUBSTRING(comments.comment_content,1,200) AS comment_excerpt,meta_key,meta_value
			FROM $wpdb->comments comments
			LEFT JOIN $wpdb->posts posts ON (comments.comment_post_ID = posts.ID)
            LEFt JOIN $wpdb->commentmeta commentmeta ON (comments.comment_ID =  commentmeta.comment_id)
			WHERE comments.comment_type = 'order_note' and comments.comment_content <>''	
			and comment_agent='Customer' and meta_key='note_added_by_customer' and meta_value=1    
			" . $quote_only_string . " 
			ORDER BY comments.comment_ID DESC
			LIMIT {$num_notes}
		");


    if ($comments) {

             wc_get_template('woo-rfq/admin/dashboard-cust-notes.php', array('comments'=>$comments)
                 , '', gpls_woo_rfq_plus_DIR . 'woocommerce/');


    } else {
        // echo '<p>' . __('There are no customer notes yet.', 'rfqtk') . '</p>';
    }
}


function gpls_woo_rfq_plus_file_my_account_orders_notes($order_id)
{

    $order_factory = new WC_Order_Factory();

    $order = $order_factory->get_order($order_id);


    $notes = $order->get_customer_order_notes();
    if ($notes) {
       // echo 'notes_functions:';

        wc_get_template('woo-rfq/myacct/notes_items.php', array('notes' => $notes)
            , '', gpls_woo_rfq_plus_DIR . 'woocommerce/');

    } else {
        //echo '<li>' . __('There are no notes yet.', 'rfqtk') . '</li>';
    }

    echo '</ul>';
}

function gpls_woo_rfq_add_to_note_create_styles($gpls_woo_rfq_upload_styles)
{


    $gpls_woo_rfq_page_update_button_styles = '';

    $gpls_woo_rfq_page_update_button_onmouseover_color = '';
    $gpls_woo_rfq_page_update_button_background_onmouseover = '';
    $gpls_woo_rfq_page_update_button_onmouseover = '';

    $gpls_woo_rfq_page_update_button_onmouseout_color = '';
    $gpls_woo_rfq_page_update_button_background_onmouseout = '';


    $gpls_woo_rfq_page_submit_button_styles = '';

    $gpls_woo_rfq_page_submit_button_onmouseover = '';
    $gpls_woo_rfq_page_submit_button_background_onmouseover = '';

    $gpls_woo_rfq_page_submit_button_onmouseout = '';
    $gpls_woo_rfq_page_submit_button_background_onmouseout = '';

    $gpls_woo_rfq_page_update_button_onmouseout = '';


    $rfq_cart_sc_section_rfq_page_update_cart_button_background = get_option('rfq_cart_sc_section_rfq_page_add_customer_note_button_background', '');

    if (($rfq_cart_sc_section_rfq_page_update_cart_button_background) != '') {

        $gpls_woo_rfq_page_update_button_styles .= "background-color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . " !important;";

    }


    $rfq_cart_sc_section_rfq_page_update_cart_button_color = get_option('rfq_cart_sc_section_rfq_page_add_customer_note_button_color', '');

    if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_color) != '') {

        $gpls_woo_rfq_page_update_button_styles .= "color:" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . " !important;";

    }


    $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background = get_option('rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_background', '');
    // echo $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background;

    if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background) != '') {

        $gpls_woo_rfq_page_update_button_background_onmouseover .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_background . "';";
        $gpls_woo_rfq_page_update_button_background_onmouseout .= "this.style.background='" . $rfq_cart_sc_section_rfq_page_update_cart_button_background . "';";

    }


    $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color = get_option('rfq_cart_sc_section_rfq_page_add_customer_note_button_mouse_over_color', '');

    if (trim($rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color) != '') {

        $gpls_woo_rfq_page_update_button_onmouseover .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_update_cart_button_mouse_over_color . "';";
        $gpls_woo_rfq_page_update_button_onmouseout .= "this.style.color='" . $rfq_cart_sc_section_rfq_page_update_cart_button_color . "';";

    }


    $gpls_woo_rfq_upload_styles = array(

        'gpls_woo_rfq_page_button_styles' => $gpls_woo_rfq_page_update_button_styles,

        'gpls_woo_rfq_page_button_onmouseover_color' => $gpls_woo_rfq_page_update_button_onmouseover_color,
        'gpls_woo_rfq_page_button_background_onmouseover' => $gpls_woo_rfq_page_update_button_background_onmouseover,

        'gpls_woo_rfq_page_button_onmouseout_color' => $gpls_woo_rfq_page_update_button_onmouseout_color,
        'gpls_woo_rfq_page_button_background_onmouseout' => $gpls_woo_rfq_page_update_button_background_onmouseout,

        'gpls_woo_rfq_page_button_onmouseover' => $gpls_woo_rfq_page_update_button_onmouseover,
        'gpls_woo_rfq_page_button_onmouseout' => $gpls_woo_rfq_page_update_button_onmouseout,


    );

    return $gpls_woo_rfq_upload_styles;


}


function rfqtk_save_quote_sent_note($post_id, $post, $update)
{


    // echo $post_id;
    //d($_POST);//exit;

    if (!isset($_POST['quote_sent_note_editor'])) {
        return false;
    }

    if (!isset($_POST["meta-box-nonce"]) || !wp_verify_nonce($_POST["meta-box-nonce"], "meta-box-nonce"))
        //  return $post_id;

        if (!current_user_can("edit_post", $post_id))
            return $post_id;

    if (defined("DOING_AUTOSAVE") && DOING_AUTOSAVE)
        return $post_id;


    if ('shop_order' != $post->post_type)
        return $post_id;

    // Check user has permission to edit
    if (!current_user_can('edit_post', $post_id)) {
        return 0;
    }
    // check if there was a multisite switch before
    if (is_multisite() && ms_is_switched()) {
        return $post_id;
    }


    if (isset($_POST['quote_sent_note_editor'])) {

        update_post_meta($post_id, '_quote_sent_note', esc_html($_POST['quote_sent_note_editor']));
    }

    if (isset($_POST['include_proposal_pay_link'])) {

        update_post_meta($post_id, '_include_proposal_pay_link', "yes");
    } else {
        update_post_meta($post_id, '_include_proposal_pay_link', "no");
    }

    if (isset($_POST['include_respond_link'])) {

        update_post_meta($post_id, '_include_respond_link', "yes");
    } else {
        update_post_meta($post_id, '_include_respond_link', "no");
    }


    if (isset($_POST['include_accept_link'])) {

        update_post_meta($post_id, '_include_accept_link', "yes");
    } else {
        update_post_meta($post_id, '_include_accept_link', "no");
    }

    if (isset($_POST['allow_multiple_offers'])) {

        update_post_meta($post_id, '_allow_multiple_offers', "yes");
    } else {
        update_post_meta($post_id, '_allow_multiple_offers', "no");
    }

    if (isset($_POST['gpls_woo_rfq_no_expire'])) {
        update_post_meta($post_id, '_gpls_woo_rfq_no_expire', "yes");
    } else {
        update_post_meta($post_id, '_gpls_woo_rfq_no_expire', "no");
    }


    if (isset($_POST['gpls_woo_rfq_email_sender'])) {
        update_post_meta($post_id, '_gpls_woo_rfq_email_sender', $_POST['gpls_woo_rfq_email_sender']);
    }

    if (isset($_POST['gpls_woo_rfq_email_cc'])) {
        update_post_meta($post_id, '_gpls_woo_rfq_email_cc', $_POST['gpls_woo_rfq_email_cc']);
    }

    if (isset($_POST['gpls_woo_rfq_email_reply'])) {
        update_post_meta($post_id, '_gpls_woo_rfq_email_reply', $_POST['gpls_woo_rfq_email_reply']);
    }


    // handle your meta box input ...
}


function gpls_woo_rfq_add_order_note($order, $note, $is_customer_note = 0, $added_by_user = false)
{

    if (trim($note) === "") return;

    if (is_user_logged_in() && current_user_can('edit_shop_order', $order->get_id()) && $added_by_user) {
        $user = get_user_by('id', get_current_user_id());
        $comment_author = $user->display_name;
        $comment_author_email = $user->user_email;
    } else {
        $comment_author = __('Customer', 'rfqtk');
        $comment_author_email = strtolower(__('Customer', 'rfqtk')) . '@';

        //$link_to_rfq_page = preg_replace('{/$}', '',  gpls_woo_rfq_remove_http(get_site_url()));
        //$comment_author_email .= isset($http_host) ? str_replace('www.', '', $_SERVER['HTTP_HOST']) : 'noreply.com';
        $comment_author_email .= isset($http_host) ? str_replace('www.', '', gpls_woo_rfq_remove_http(get_site_url())) : 'noreply.com';
        $comment_author_email = sanitize_email($comment_author_email);
    }


    $comment_post_ID = $order->get_id();
    $comment_author_url = '';
    $comment_content = $note;
    $comment_agent = 'Customer';
    $comment_type = 'order_note';
    $comment_parent = 0;
    $comment_approved = 1;
    $commentdata = apply_filters('woocommerce_new_order_note_data', compact('comment_post_ID', 'comment_author', 'comment_author_email', 'comment_author_url', 'comment_content', 'comment_agent', 'comment_type', 'comment_parent', 'comment_approved'), array('order_id' => $order->get_id(), 'is_customer_note' => $is_customer_note));

    $comment_id = wp_insert_comment($commentdata);

    if ($is_customer_note) {
        add_comment_meta($comment_id, 'is_customer_note', 1);
    }

    if ($added_by_user) {
        add_comment_meta($comment_id, 'note_added_by_customer', 1);
    }


    return $comment_id;
}

function gpls_woo_rfq_plus_add_customer_response($order_id)
{

    //ob_start();



    $gpls_woo_rfq_upload_styles = array();

    $gpls_woo_rfq_upload_styles = apply_filters('gpls_woo_rfq_customer_notes_styles', $gpls_woo_rfq_upload_styles);

    $of = new WC_Order_Factory();
    $order = $of::get_order($order_id);
    $status = $order->get_status();
    $order_total = $order->get_formatted_order_total();


    $gpls_accepted_offer = get_post_meta($order_id, '_gpls_accepted_offer', true);

    if ($gpls_accepted_offer == '') {
        $gpls_accepted_offer = false;
    }

    $gpls_accepted_offer_date = get_post_meta($order_id, '_gpls_accepted_offer_date', true);

    if ($gpls_accepted_offer_date == '') {
        $gpls_accepted_offer_date = false;
    }

    $show_accept_offer = get_option('settings_gpls_woo_rfq_show_accept_offer');

    $allow_customer_offer = get_option('settings_gpls_woo_rfq_allow_customer_offer', 'no') ;

    $quote_request_based_on_items_in_cart = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

    $items = WC()->cart->get_cart();

    $has_rfq = false;

    $specific_gateway = 'gpls-rfq';

    WC()->initialize_session();

    $chosen_method = WC()->session->get('chosen_payment_method');

    if ($chosen_method == $specific_gateway) {
        WC()->session->set('chosen_payment_method', null);
    }

    foreach ($items as $item => $values) {

        $_product = wc_get_product($values['product_id']);

       // $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
      //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $_product->get_id());

        $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);


        if ($rfq_enable == 'yes') {
            $has_rfq = true;
            break;
        }
    }

    $customer_note_text = get_option('settings_gpls_woo_rfq_customer_note_text', __('Submit', 'rfqtk'));
    $customer_note_text = __($customer_note_text, 'rfqtk');

    $status_allowed = array('gplsquote-sent','gplsquote-req');

    $show_notes = get_option('settings_gpls_woo_rfq_show_notes', 'yes');

    $include_pay_link = get_post_meta($order->get_id(), '_include_proposal_pay_link', true);

    $combine_notes_with_upload = "no";

    if (class_exists('GPLS_WOO_RFQ_UPLOAD')
        && get_option('settings_gpls_woo_rfq_combine_upload_note', "no") === "yes")
    {
        $combine_notes_with_upload="yes";
    }
    $gpls_woo_rfq_Plus_file_category = 'quote';
    $gpls_woo_rfq_Plus_image_caption = '';


    $show_submit= "no";

    if ((in_array($status,$status_allowed) && $show_notes === 'yes') &&
        (($show_accept_offer === 'yes' && in_array($status,$status_allowed)
                && !$gpls_accepted_offer)
            || $show_notes === 'yes')){

        $show_submit="yes";

    }
    
    $template_args=array(

        'order_id' => $order_id,
        'gpls_woo_rfq_upload_styles' =>$gpls_woo_rfq_upload_styles,
        'order_total' => $order_total,
        'gpls_accepted_offer' => $gpls_accepted_offer,
        'gpls_accepted_offer_date' => $gpls_accepted_offer_date,
        'show_accept_offer' => $show_accept_offer,
        'allow_customer_offer' => $allow_customer_offer,
        'quote_request_based_on_items_in_cart' => $quote_request_based_on_items_in_cart,
        'cart_has_quote_item' => $has_rfq,
        'customer_note_text' => __($customer_note_text, 'rfqtk'),
        'status_allowed' => $status_allowed,
        'show_notes' => $show_notes,
        'include_pay_link' => $include_pay_link,
        'combine_notes_with_upload' => $combine_notes_with_upload,
        'gpls_woo_rfq_Plus_file_category' => $gpls_woo_rfq_Plus_file_category,
        'gpls_woo_rfq_Plus_image_caption' => $gpls_woo_rfq_Plus_image_caption,
        'show_submit' => $show_submit,
        'status' => $status,
        'order' => $order

    );



    wc_get_template('woo-rfq/myacct/cust-notes.php', $template_args,'',
        gpls_woo_rfq_plus_DIR . 'woocommerce/');


    echo '<div  style=" margin-top:5px;margin-bottom:5px; display:block;"><h3>&nbsp;</h3></div>';

    //echo ob_get_clean();

}