<?php
if (!defined('ABSPATH'))
    exit;
/**
 * Main class
 *
 */
if (!class_exists('rfqtk_offer_functions')) {

    class rfqtk_offer_functions
    {

        function __construct()
        {
            $checkout_option = "";

            $rfq_check = false;
            $normal_check = false;
            gpls_woo_rfq_get_mode($rfq_check, $normal_check);

            if (isset($GLOBALS["gpls_woo_rfq_checkout_option"])) {
                $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];
            }





            if (get_option('settings_gpls_woo_rfq_allow_customer_offer', 'no') == 'yes') {

                if ($rfq_check) {


                    add_action('woocommerce_after_checkout_validation', 'gpls_woo_rfq_plus_customer_bid_rfq_required', 100, 1);

                    $checkout_position = get_option('settings_gpls_woo_rfq_customer_offer_checkout_position', '1');

                    switch ($checkout_position) {

                        case 1:
                            add_action('woocommerce_checkout_before_order_review', 'gpls_woo_rfq_plus_customer_bid', -1000);
                            break;
                        case 2:
                            add_action('woocommerce_checkout_order_review', 'gpls_woo_rfq_plus_customer_bid', 11);
                            break;

                        case 3:
                            add_action('woocommerce_checkout_billing', 'gpls_woo_rfq_plus_customer_bid', -1000);
                            break;
                        case 4:
                            add_action('woocommerce_checkout_shipping', 'gpls_woo_rfq_plus_customer_bid', 1000);
                            break;
                    }

                } else {

                    add_action('gpls_woo_rfq_cart_actions_customer_bid', 'gpls_woo_rfq_plus_customer_bid_quote_request_page', 1);

                }

            }


            //if(!function_exists('add_gpls_rfq_toolkit_meta_boxes'))
            {
                add_action('add_meta_boxes', 'add_gpls_rfq_toolkit_meta_boxes', 1000);
            }

            add_action('woocommerce_checkout_update_order_meta', 'gpls_woo_rfq_plus_save_customer_offer', 1000, 2);
            //add_action('gpls_woo_rfq_customer_checkout_end', 'gpls_woo_rfq_plus_save_customer_offer', 100,1);







            if ($rfq_check) {
               // add_action('gpls_woo_rfq_woocommerce_before_add_to_rfq_cart', 'gpls_woo_rfq_plus_offer_add_to_cart_rfq', -1, 8);
            } else {
                //add_action('gpls_woo_rfq_woocommerce_before_add_to_rfq_cart', 'gpls_woo_rfq_plus_offer_add_to_cart_normal', -1, 8);
               // add_action('gpls_woo_rfq_woocommerce_before_add_to_rfq_cart', 'gpls_woo_rfq_plus_offer_add_to_cart_normal', -1, 8);
            }

          //  add_action('woocommerce_ajax_added_to_cart', 'gpls_woo_rfq_plus_custom_redirect', 100, 1);

            add_filter('manage_edit-shop_order_columns', 'gpls_woo_rfq_custom_shop_order_column', 11);
            add_action('manage_shop_order_posts_custom_column', 'gpls_woo_rfq_auction_custom_orders_cols', 10, 2);
            add_filter('manage_edit-shop_order_sortable_columns', 'gpls_woo_rfq_auction_shop_order_sortable_columns');



            add_filter('request', 'gpls_woo_rfq_auction_request_query', 1000);

            add_action('woocommerce_email_order_meta', 'gpls_woo_rfq_plus_auction_customer_email_order_meta_display', 100, 3);

          //  add_filter('pre_get_posts', 'gpls_woo_rfq_plus_auction_column_orderby_qbstatus');

            }

    }
    function gpls_woo_rfq_plus_auction_column_orderby_qbstatus($query)
    {
        $orderby = $query->get( 'orderby' );



        if ( 'customer_bid' == $orderby )
        {

            $meta_query = array(
                'relation' => 'OR',
                array(
                    'key' => '_woo_rfq_customer_bid',
                    'compare' => '>'
                ),
                array(
                    'key' => '_woo_rfq_customer_bid',
                    'compare' => 'NOT EXISTS'
                ),
            );

            $query->set( 'meta_query', $meta_query );
            $query->set( 'orderby', 'meta_value_num' );

        }

    }

    function gpls_woo_rfq_plus_auction_customer_email_order_meta_display($order, $sent_to_admin, $plain_text)
    {
        //ob_start();


        $customer_offer = get_post_meta($order->get_id(), '_woo_rfq_customer_bid', true);

        if (!gpls_empty($customer_offer) && $customer_offer != '') {


            $customer_offer_text = __('Customer Bid', 'rfqtk');
            echo '<div  style="clear: both; margin-top:20px; height: 20px; display:block;"></div>';
            echo '<div  style="clear: both; margin-top:20px; display:block;"></div>
<div style="float:left; "><p /><h4>' . $customer_offer_text . ':' . wc_price(get_post_meta($order->get_id(), '_woo_rfq_customer_bid', true)) . '</h4><p /></div>';
        }


        // echo ob_get_clean();
    }

    function gpls_woo_rfq_auction_request_query($vars)
    {
        {
            if (isset($vars['orderby'])) {
                if ('_woo_rfq_customer_bid' == $vars['orderby']) {
                    $vars = array_merge($vars, array(
                        'meta_key' => '_woo_rfq_customer_bid',
                        'orderby' => 'meta_value_num',
                    ));
                }

            }
        }

        return $vars;
    }


    function gpls_woo_rfq_auction_shop_order_sortable_columns($columns)
    {
        $columns['customer_bid'] = '_woo_rfq_customer_bid';

        return $columns;
    }


    function gpls_woo_rfq_custom_shop_order_column($columns)
    {
        //add columns
        $columns['customer_bid'] = __('Bid', 'rfqtk');

        return $columns;
    }

    function gpls_woo_rfq_auction_custom_orders_cols($column, $post_id)
    {
        global $post;
        $order_id = $post_id;

        $the_order = WC_Order_Factory::get_order($order_id);


        switch ($column) {
            case 'customer_bid' :
                $customer_bid = get_post_meta($the_order->get_id(), '_woo_rfq_customer_bid', true);

                if (!gpls_empty($customer_bid)) {
                    echo wc_price($customer_bid);
                }

                break;



        }
    }




    function gpls_woo_rfq_plus_offer_add_to_cart_rfq($is_an_rfq, $request, $cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data)
    {



        $remove = false;
        global $message;
        $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];

        $is_prod_exclusive = "no";


        $is_prod_exclusive = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quote', true);

        if (WC()->cart->get_cart_contents_count() > 0) {

            if ($is_prod_exclusive == "yes") {

                foreach (WC()->cart->get_cart() as $cart_item_key_temp => $cart_item_temp) {

                    $temp_prod_id = $cart_item_temp['product_id'];

                    if ($product_id == $temp_prod_id) {
                        continue;
                    } else {
                        $exclusive_product = WC()->product_factory->get_product($product_id);

                        $message = $exclusive_product->get_title() . ' ';
                        $is_exclusive_message_option = get_option('settings_gpls_woo_rfq_customer_offer_global_exclusive_message', '');
                        $is_exclusive_message_option = __($is_exclusive_message_option, 'rfqtk');

                        if ($is_exclusive_message_option == '') {
                            $is_exclusive_message_option = __('Product is an exclusive item and cannot be combined with other products in the order.','rfqtk');
                        }
                        $message .= $is_exclusive_message_option;

                        $is_exclusive_text = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quote_warning', true);

                        if (!gpls_empty($is_exclusive_text)) {
                            $message = $is_exclusive_text;
                        }
                      //  WC()->cart->cart_contents[$cart_item_key]['restore'] = 'no';
                      //  WC()->cart->cart_contents[$cart_item_key]['man_deleted'] = 'no';

                        WC()->cart->remove_cart_item($cart_item_key);


                      //  wc_clear_notices();
                        wc_add_notice($message, 'notice');


                        if (defined('DOING_AJAX') && DOING_AJAX) {
                            $data = array(
                                'error' => true,
                                'product_url' => wp_get_referer(),
                            );

                            wp_send_json($data);
//
                            exit();
                        } else {
                            wp_safe_redirect(wp_get_referer());
                            exit;
                        }


                    }


                }


            } else {

                foreach (WC()->cart->get_cart() as $cart_item_key_temp => $cart_item_temp) {

                    $temp_prod_id = $cart_item_temp['product_id'];

                    if ($product_id == $temp_prod_id) continue;

                    $is_exclusive = rftk_auction_prod_cat_has_meta($temp_prod_id, '_gpls_woo_rfq_plus_product_exclusive_quote', true);

                    if ($is_exclusive == "yes") {


                        $exclusive_product = WC()->product_factory->get_product($temp_prod_id);

                        $message = $exclusive_product->get_title() . ' ';
                        $is_exclusive_message_option = get_option('settings_gpls_woo_rfq_customer_offer_global_exclusive_message', '');
                        $is_exclusive_message_option = __($is_exclusive_message_option, 'rfqtk');

                        if ($is_exclusive_message_option == '') {
                            $is_exclusive_message_option = __('Product is an exclusive item and cannot be combined with other products in the order.','rfqtk');
                        }
                        $message .= $is_exclusive_message_option;


                        $is_exclusive_text = rftk_auction_prod_cat_has_meta($temp_prod_id, '_gpls_woo_rfq_plus_product_exclusive_quote_warning', true);

                        if (!gpls_empty($is_exclusive_text)) {
                            $message = $is_exclusive_text;

                        }


                     //   WC()->cart->cart_contents[$cart_item_key]['restore'] = 'no';
                     //   WC()->cart->cart_contents[$cart_item_key]['man_deleted'] = 'no';

                        WC()->cart->remove_cart_item($cart_item_key);

                        wc_add_notice($message, 'notice');

                        if (defined('DOING_AJAX') && DOING_AJAX) {
                            $data = array(
                                'error' => true,
                                'product_url' => wp_get_referer(),
                            );

                            wp_send_json($data);

                            exit();
                        } else {
                            wp_safe_redirect(wp_get_referer());
                            exit;
                        }


                    }

                }
            }
        }
        // if ($is_prod_exclusive == "yes")
        {
            /*$prod_exclusive_min = get_post_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_min', true);
            $prod_exclusive_max = get_post_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_max', true);
            $prod_exclusive_qty_message = get_post_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quantity_warning', true);*/

            $prod_exclusive_min = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_min', true);
            $prod_exclusive_max = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_max', true);
            $prod_exclusive_qty_message = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quantity_warning', true);

            $cart_item_temp = WC()->cart->get_cart_item($cart_item_key);

            if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) == "")) {
                return $cart_item_key;
            }

            $old_qty = $quantity;
            $new_qty = $quantity;

            if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) == "")) {
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;

            }

            if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) != "")) {
                if ($new_qty > $prod_exclusive_max) $new_qty = $prod_exclusive_max;
            }

            if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) != "")) {
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;
                if ($new_qty > $prod_exclusive_max) $new_qty = $prod_exclusive_max;
                if ($prod_exclusive_min == $prod_exclusive_max) $new_qty = $prod_exclusive_max;

            }

            if ($new_qty != '') {

                WC()->cart->set_quantity($cart_item_key, $new_qty);



                if ($prod_exclusive_qty_message == '') {
                    $exclusive_product = WC()->product_factory->get_product($product_id);
                    $exclusive_product = WC()->product_factory->get_product($product_id);


                    if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) != "")) {
                        $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be between ', 'rfqtk') . $prod_exclusive_min . __(' and ','rfqtk') . $prod_exclusive_max;

                    }
                    if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) == "")) {
                        $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be at least ', 'rfqtk') . $prod_exclusive_min;

                    }
                    if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) != "")) {
                        $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be at most ', 'rfqtk') . $prod_exclusive_max;

                    }
                    $prod_exclusive_qty_message .= __('. Quantity has been adjusted.', 'rfqtk');
                }


                if ($old_qty != $new_qty) {
                    //wc_clear_notices();
                    wc_add_notice($prod_exclusive_qty_message, 'notice');
                }
                if (defined('DOING_AJAX') && DOING_AJAX) {
                    $data = array(
                        'error' => true,
                        'product_url' => wp_get_referer(),
                    );

                    wp_send_json($data);

                    exit();
                } else {
                    wp_safe_redirect(wp_get_referer());
                    exit;
                }
            }
            return $cart_item_key;
        }


    }

    function gpls_woo_rfq_plus_offer_add_to_cart_normal($is_an_rfq, $request, $cart_item_key, $product_id, $quantity, $variation_id, $variation, $cart_item_data)
    {

//d($is_an_rfq);exit;
        if ($is_an_rfq != true) {
            return;
        }

       // $rfq_enable = get_post_meta($product_id, '_gpls_woo_rfq_rfq_enable', true);
        //$rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable,$product_id);

        $product = wc_get_product($product_id);

         $rfq_enable = gpls_woo_plus_get_rfq_enable($product);

        if ($rfq_enable != 'yes') {
            return;
        }


        $is_limited = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_offer_period_limit', true);

        if ($is_limited == "yes") {
            if (rftk_auction_is_in_effect($product_id) == false) {
                return;
            }
        }

        $remove = false;
        global $message;

        $is_prod_exclusive = "no";

        $is_prod_exclusive = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quote', true);

        $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');


        // d($gpls_woo_rfq_cart);exit;

        if ($gpls_woo_rfq_cart == false) {
            return;
        }

        if ($gpls_woo_rfq_cart == true) {

            if ($is_prod_exclusive == "yes") {

                foreach ($gpls_woo_rfq_cart as $cart_item_key_temp => $cart_item_temp) {

                    if (!isset($cart_item_temp['product_id'])) {
                        continue;
                    }
                    $temp_prod_id = $cart_item_temp['product_id'];

                    if ($product_id == $temp_prod_id) {
                        continue;
                    } else {
                        $exclusive_product = WC()->product_factory->get_product($product_id);
                        $message = $exclusive_product->get_title() . ' ';
                        $is_exclusive_message_option = get_option('settings_gpls_woo_rfq_customer_offer_global_exclusive_message', '');
                        $is_exclusive_message_option = __($is_exclusive_message_option, 'rfqtk');


                        if ($is_exclusive_message_option == '') {
                            $is_exclusive_message_option = __('Product is an exclusive item and cannot be combined with other products in the order.','rfqtk');
                        }
                        $message .= $is_exclusive_message_option;

                        $is_exclusive_text = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quote_warning', true);

                        if (!gpls_empty($is_exclusive_text)) {
                            $message = $is_exclusive_text;
                        }
                        // WC()->cart->cart_contents[$cart_item_key]['restore'] = 'no';
                        // WC()->cart->cart_contents[$cart_item_key]['man_deleted'] = 'no';
                        WC()->cart->remove_cart_item($cart_item_key);

                        unset($gpls_woo_rfq_cart[$cart_item_key]);

                        $wp_session = gpls_woo_get_session();

                        $wp_session->write_data($wp_session->session_id);

                        add_filter('gpls_woo_rfq_cart_do_set', function () {
                            return false;
                        });


                        gpls_woo_rfq_add_notice($message, 'info');
                        wc_add_notice($message, 'info');


                        $home = home_url() . '/quote-request/';

                        $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);
                        wp_safe_redirect($home);

                        exit();


                    }


                }

                $home = home_url() . '/quote-request/';

                $rfq_page = get_option('rfq_cart_sc_section_show_link_to_rfq_page', $home);
                wp_safe_redirect($home);

                exit();


            } else {

                foreach ($gpls_woo_rfq_cart as $cart_item_key_temp => $cart_item_temp) {

                    if (!isset($cart_item_temp['product_id'])) {
                        continue;
                    }
                    $temp_prod_id = $cart_item_temp['product_id'];

                    if ($product_id == $temp_prod_id) continue;

                    $is_exclusive = rftk_auction_prod_cat_has_meta($temp_prod_id, '_gpls_woo_rfq_plus_product_exclusive_quote', true);

                    if ($is_exclusive == "yes") {


                        $exclusive_product = WC()->product_factory->get_product($temp_prod_id);

                        $message = $exclusive_product->get_title() . ' ';
                        $is_exclusive_message_option = get_option('settings_gpls_woo_rfq_customer_offer_global_exclusive_message', '');
                        $is_exclusive_message_option = __($is_exclusive_message_option, 'rfqtk');

                        if ($is_exclusive_message_option == '') {
                            $is_exclusive_message_option = __('Product is an exclusive item and cannot be combined with other products in the order.','rfqtk');
                        }
                        $message .= $is_exclusive_message_option;


                        $is_exclusive_text = rftk_auction_prod_cat_has_meta($temp_prod_id, '_gpls_woo_rfq_plus_product_exclusive_quote_warning', true);

                        if (!gpls_empty($is_exclusive_text)) {
                            $message = $is_exclusive_text;

                        }


                       // WC()->cart->cart_contents[$cart_item_key]['restore'] = 'no';
                       // WC()->cart->cart_contents[$cart_item_key]['man_deleted'] = 'no';

                        WC()->cart->remove_cart_item($cart_item_key);
                        unset($gpls_woo_rfq_cart[$cart_item_key]);

                        $wp_session = gpls_woo_get_session();
                        $wp_session->write_data($wp_session->session_id);



                        add_filter('gpls_woo_rfq_cart_do_set', function () {
                            return false;
                        });

                        gpls_woo_rfq_add_notice($message, 'info');
                        $home = home_url() . '/quote-request/';
                        wp_safe_redirect($home);
                        exit();


                    }

                }
            }
        }



    }


    function gpls_woo_rfq_normal_stock_amount_rfq_cart_item($quantity, $product_id, $cart_item_key, $cart_item_temp)
    {


        $is_limited = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_offer_period_limit', true);

        if ($is_limited == "yes" || $quantity == 0) {
            if (rftk_auction_is_in_effect($product_id) == false) {
                return $quantity;
            }
        }


        $remove = false;
        global $message;
        $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];

        $is_prod_exclusive = "no";

        $is_prod_exclusive = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_purchase', true);


        {
            $prod_exclusive_min = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_min', true);
            $prod_exclusive_max = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_max', true);
            $prod_exclusive_qty_message = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quantity_warning', true);


            if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) == "")) {
                return $quantity;
            }

            $old_qty = $quantity;
            $new_qty = $quantity;

            if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) == "")) {
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;

            }

            if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) != "")) {
                if ($new_qty > $prod_exclusive_max) $new_qty = $prod_exclusive_max;
            }

            if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) != "")) {
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;
                if ($new_qty > $prod_exclusive_max) $new_qty = $prod_exclusive_max;
                if ($prod_exclusive_min == $prod_exclusive_max) $new_qty = $prod_exclusive_max;

            }


            if ($new_qty != '') {

                $exclusive_product = WC()->product_factory->get_product($product_id);


                if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) != "")) {
                    $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be between ','rfqtk') . $prod_exclusive_min . __(' and ','rfqtk') . $prod_exclusive_max;

                }
                if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) == "")) {
                    $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be at least ','rfqtk') . $prod_exclusive_min;

                }
                if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) != "")) {
                    $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be at most ','rfqtk') . $prod_exclusive_max;

                }

                $prod_exclusive_qty_message .= __('. Quantity has been adjusted.','rfqtk');

                //  wc_clear_notices();
                //  wc_add_notice($prod_exclusive_qty_message, 'notice');
                if ($old_qty != $new_qty) {
                    gpls_woo_rfq_add_notice($prod_exclusive_qty_message, 'info');
                }

            }
            return $new_qty;
        }


    }

    function gpls_woo_rfq_normal_stock_amount_cart_item($quantity, $cart_item_key)
    {

        $cart_item_temp = WC()->cart->get_cart_item($cart_item_key);

        $product_id = $cart_item_temp['product_id'];


        $is_limited = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_offer_period_limit', true);

        if ($is_limited == "yes" || $quantity == 0) {
            if (rftk_auction_is_in_effect($product_id) == false) {
                return $quantity;
            }
        }


        $remove = false;
        global $message;
        $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];

        $is_prod_exclusive = "no";

        $is_prod_exclusive = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_purchase', true);

        if (WC()->cart->get_cart_contents_count() > 0) {

            if ($is_prod_exclusive == "yes") {

                foreach (WC()->cart->get_cart() as $cart_item_key_temp => $cart_item_temp) {

                    $temp_prod_id = $cart_item_temp['product_id'];

                    if ($product_id == $temp_prod_id) {
                        continue;
                    } else {
                        $exclusive_product = WC()->product_factory->get_product($product_id);

                        $message = $exclusive_product->get_title() . ' ';
                        $is_exclusive_message_option = get_option('settings_gpls_woo_rfq_customer_offer_global_exclusive_message', '');
                        $is_exclusive_message_option = __($is_exclusive_message_option, 'rfqtk');

                        if ($is_exclusive_message_option == '') {
                            $is_exclusive_message_option = __('Product is an exclusive item and cannot be combined with other products in the order.','rfqtk');
                        }
                        $message .= $is_exclusive_message_option;

                        $is_exclusive_text = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quote_warning', true);

                        if (!gpls_empty($is_exclusive_text)) {
                            $message = $is_exclusive_text;
                        }
                      //  WC()->cart->cart_contents[$cart_item_key]['restore'] = 'no';
                      //  WC()->cart->cart_contents[$cart_item_key]['man_deleted'] = 'no';
                        WC()->cart->remove_cart_item($cart_item_key);


                        wc_add_notice($message, 'notice');

                        if (defined('DOING_AJAX') && DOING_AJAX) {
                            $data = array(
                                'error' => true,
                                'product_url' => wp_get_referer(),
                            );

                            wp_send_json($data);
//
                            exit();
                        } else {
                            wp_safe_redirect(wp_get_referer());
                            exit;
                        }


                    }


                }


            } else {

                foreach (WC()->cart->get_cart() as $cart_item_key_temp => $cart_item_temp) {

                    $temp_prod_id = $cart_item_temp['product_id'];

                    if ($product_id == $temp_prod_id) continue;

                    $is_exclusive = rftk_auction_prod_cat_has_meta($temp_prod_id, '_gpls_woo_rfq_plus_product_exclusive_purchase', true);

                    if ($is_exclusive == "yes") {


                        $exclusive_product = WC()->product_factory->get_product($temp_prod_id);

                        $message = $exclusive_product->get_title() . ' ';
                        $is_exclusive_message_option = get_option('settings_gpls_woo_rfq_customer_offer_global_exclusive_message', '');
                        $is_exclusive_message_option = __($is_exclusive_message_option, 'rfqtk');

                        if ($is_exclusive_message_option == '') {
                            $is_exclusive_message_option = __('Product is an exclusive item and cannot be combined with other products in the order.','rfqtk');
                        }
                        $message .= $is_exclusive_message_option;


                        $is_exclusive_text = rftk_auction_prod_cat_has_meta($temp_prod_id, '_gpls_woo_rfq_plus_product_exclusive_quote_warning', true);

                        if (!gpls_empty($is_exclusive_text)) {
                            $message = $is_exclusive_text;

                        }


                     //   WC()->cart->cart_contents[$cart_item_key]['restore'] = 'no';
                     //   WC()->cart->cart_contents[$cart_item_key]['man_deleted'] = 'no';
                        WC()->cart->remove_cart_item($cart_item_key);

                        wc_add_notice($message, 'notice');

                        if (defined('DOING_AJAX') && DOING_AJAX) {
                            $data = array(
                                'error' => true,
                                'product_url' => wp_get_referer(),
                            );

                            wp_send_json($data);

                            exit();
                        } else {
                            wp_safe_redirect(wp_get_referer());
                            exit;
                        }


                    }

                }
            }
        }


        {
            $prod_exclusive_min = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_min', true);
            $prod_exclusive_max = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_max', true);
            $prod_exclusive_qty_message = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quantity_warning', true);


            if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) == "")) {
                return $quantity;
            }

            $old_qty = $quantity;
            $new_qty = $quantity;

            if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) == "")) {
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;

            }

            if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) != "")) {
                if ($new_qty > $prod_exclusive_max) $new_qty = $prod_exclusive_max;
            }

            if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) != "")) {
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;
                if ($new_qty > $prod_exclusive_max) $new_qty = $prod_exclusive_max;
                if ($prod_exclusive_min == $prod_exclusive_max) $new_qty = $prod_exclusive_max;

            }


            if ($new_qty != '') {

                WC()->cart->set_quantity($cart_item_key, $new_qty);
                $exclusive_product = WC()->product_factory->get_product($product_id);

                if ($prod_exclusive_qty_message == '') {
                    $exclusive_product = WC()->product_factory->get_product($product_id);


                    if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) != "")) {
                        $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be between ','rfqtk') . $prod_exclusive_min . __(' and ','rfqtk') . $prod_exclusive_max;

                    }
                    if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) == "")) {
                        $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be at least ','rfqtk') . $prod_exclusive_min;

                    }
                    if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) != "")) {
                        $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be at most ','rfqtk') . $prod_exclusive_max;

                    }
                    $prod_exclusive_qty_message .= __('. Quantity has been adjusted.','rfqtk');
                }

                if ($old_qty != $new_qty) {
                   // wc_clear_notices();
                    wc_add_notice($prod_exclusive_qty_message, 'notice');
                }


            }
            return $new_qty;
        }


    }


    function gpls_woo_rfq_plus_normal_single_request_add_to_cart_quantity($new_quantity, $cart_item_key, $product_id)
    {
      //  $rfq_enable = get_post_meta($product_id, '_gpls_woo_rfq_rfq_enable', true);
     //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product_id);

        $product = wc_get_product($product_id);

        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        if ($rfq_enable != 'yes') {
            return $new_quantity;
        }

        $checkout_option = $GLOBALS["gpls_woo_rfq_checkout_option"];

        $is_prod_exclusive = "no";

        if ($checkout_option == "rfq") {
            return $new_quantity;
        }

        $is_limited = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_offer_period_limit', true);

        if ($is_limited == "yes") {
            if (rftk_auction_is_in_effect($product_id) == false) {
                return $new_quantity;
            }
        }
        $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');

        $is_prod_exclusive = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quote', true);


        {

            $prod_exclusive_min = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_min', true);
            $prod_exclusive_max = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_max', true);
            $prod_exclusive_qty_message = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quantity_warning', true);


            //          $new_qty=$gpls_woo_rfq_cart[$cart_item_key]['quantity']+$new_quantity;

            // echo $prod_exclusive_min.' '.$prod_exclusive_max.'<br />';


            if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) == "")) {
                return $new_quantity;
            }

            //        d($gpls_woo_rfq_cart);
            $old_qty = $new_quantity;
            $new_qty = $new_quantity;

            if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) == "")) {
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;

            }

            if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) != "")) {
                if ($new_qty > $prod_exclusive_max) $new_qty = $prod_exclusive_max;
            }

            if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) != "")) {
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;
                if ($new_qty > $prod_exclusive_max) $new_qty = $prod_exclusive_max;
                if ($prod_exclusive_min == $prod_exclusive_max) $new_qty = $prod_exclusive_max;

            }

            // echo $new_qty.'<br />';
            //   exit;

            if ($new_qty == '') {
                return $new_quantity;
            }
            $exclusive_product = WC()->product_factory->get_product($product_id);

            if ($prod_exclusive_qty_message == '') {
                $exclusive_product = WC()->product_factory->get_product($product_id);


                if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) != "")) {
                    $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be between ','rfqtk') . $prod_exclusive_min . __(' and ','rfqtk') . $prod_exclusive_max;

                }
                if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) == "")) {
                    $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be at least ','rfqtk') . $prod_exclusive_min;

                }
                if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) != "")) {
                    $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be at most ','rfqtk') . $prod_exclusive_max;

                }

                $prod_exclusive_qty_message .= __('. Quantity has been adjusted.','rfqtk');
            }


            if ($old_qty != $new_qty) {
                $notice = array('message' => $prod_exclusive_qty_message, 'type' => 'info', 'expired' => false);
                set_transient('gpls_woo_rfq_auction_notices', $notice, 5);
            }
            return $new_qty;
        }

        //echo '$new_quantity '.$new_quantity.'<br />';exit;
        // return $new_quantity;
    }


    function gpls_woo_rfq_plus_single_request_quantity($quantity, $cart_item_key)
    {


        if ($quantity == 0) return $quantity;

        $cart_item = WC()->cart->get_cart_item($cart_item_key);

        $product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);


      //  $rfq_enable = get_post_meta($product_id, '_gpls_woo_rfq_rfq_enable', true);
      //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product_id);

        $product = wc_get_product($product_id);
        $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


        if ($rfq_enable != 'yes') {            //return;
            // settings_gpls_woo_rfq_apply_exclusive_to_all
            $apply_to_purchases = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_apply_qty_to_purchase', true);
            if ($apply_to_purchases == 'no') {
                return $quantity;
            }


        }


        $is_limited = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_offer_period_limit', true);

        if ($is_limited == "yes") {
            if (rftk_auction_is_in_effect($product_id) == false) {
                return $quantity;
            }
        }
        $is_cart_exclusive = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quote', true);

        global $prod_exclusive_qty_message;

        //if ($is_cart_exclusive == "yes")
        {

            $prod_exclusive_min = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_min', true);
            $prod_exclusive_max = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_max', true);
            $prod_exclusive_qty_message = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_product_exclusive_quantity_warning', true);

            $exclusive_product = WC()->product_factory->get_product($product_id);


            if ($prod_exclusive_qty_message == '') {
                $exclusive_product = WC()->product_factory->get_product($product_id);


                if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) != "")) {
                    $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be between ','rfqtk') . $prod_exclusive_min . __(' and ','rfqtk') . $prod_exclusive_max;

                }
                if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) == "")) {
                    $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be at least ','rfqtk') . $prod_exclusive_min;

                }
                if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) != "")) {
                    $prod_exclusive_qty_message = $exclusive_product->get_title() . __(' Quantity must be at most ','rfqtk') . $prod_exclusive_max;

                }
                $prod_exclusive_qty_message .= __('. Quantity has been adjusted.','rfqtk');
            }

            $new_qty = $quantity;
            if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) == "")) {
                return $quantity;
            }


            if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) == "")) {
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;

            }

            if ((trim($prod_exclusive_min) == "") && (trim($prod_exclusive_max) != "")) {
                if ($new_qty > $prod_exclusive_max) $new_qty = $prod_exclusive_max;
            }

            if ((trim($prod_exclusive_min) != "") && (trim($prod_exclusive_max) != "")) {
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;
                if ($new_qty < $prod_exclusive_min) $new_qty = $prod_exclusive_min;
                if ($new_qty > $prod_exclusive_max) $new_qty = $prod_exclusive_max;
                if ($prod_exclusive_min == $prod_exclusive_max) $new_qty = $prod_exclusive_max;

            }


            if ($new_qty == '') return $quantity;

            if ($new_qty != $quantity) {

                add_filter('wc_add_to_cart_message_html', 'gpls_rfq_toolkit_add_to_cart_message_html', 10, 2);

                wc_add_notice($prod_exclusive_qty_message, 'notice');

            }
            return $new_qty;
        }
        //  return $quantity;

    }




    function gpls_rfq_toolkit_add_to_cart_message_html($message, $products)
    {
        global $message;
        return $message;
    }

    if (!function_exists('add_gpls_rfq_toolkit_meta_boxes')) {
        function add_gpls_rfq_toolkit_meta_boxes()
        {
            add_meta_box('woocommerce-gpls_woo_rfq_plus_display_in_admin', __('RFQ-ToolKit'), 'gpls_woo_rfq_plus_display_in_admin', 'shop_order', 'normal', 'default');

        }
    }
    if (!function_exists('gpls_woo_rfq_plus_display_in_admin')) {

        function gpls_woo_rfq_plus_display_in_admin($object)
        {
            wp_nonce_field("meta-box-nonce", "meta-box-nonce");

            $post = $object;
            $order = wc_get_order($post->ID);

            echo '<div style="width:auto">';

            if (function_exists('rfqtk_display_proposal_in_admin')) {
                rfqtk_display_proposal_in_admin($order);
            }


            if (function_exists('rfqtk_display_offer_in_admin')) {
                rfqtk_display_offer_in_admin($order);
            }


            if (function_exists('rfqtk_display_ninja_in_admin')) {
                rfqtk_display_ninja_in_admin($order);
            }

            if (function_exists('rfqtk_display_files_in_admin')) {
                rfqtk_display_files_in_admin($order);
            }

            if (function_exists('gpls_woo_rfq_pdf_display_in_admin')) {
                gpls_woo_rfq_pdf_display_in_admin($order);
            }
            echo '</div>';

        }

    }

    function gpls_woo_rfq_pay_woocommerce_locate_bid_template($template, $template_name, $template_path)
    {

        // global $woocommerce;

        $_template = $template;
        if (!$template_path)
            $template_path = WC()->template_url;

        $plugin_path = gpls_woo_rfq_plus_DIR . 'woocommerce/';

        // Look within passed path within the theme - this is priority
        $template = locate_template(
            array(
                $template_path . $template_name,
                $template_name
            )
        );

        if (!$template && file_exists($plugin_path . $template_name))
            $template = $plugin_path . $template_name;

        if (!$template)
            $template = $_template;
        // d($template);
        return $template;
        // Return what we found

    }

    function gpls_woo_rfq_woocommerce_validation_plus($true, $product_id)
    {

        $is_limited = rftk_auction_prod_cat_has_meta($product_id, '_gpls_woo_rfq_plus_offer_period_limit', true);

        if ($is_limited == "yes") {
            if (rftk_auction_is_in_effect($product_id) == false) {
                return false;
            }
        }

        $exclusive_new_product = rftk_auction_prod_cat_has_meta($product_id, 'gpls_woo_rfq_plus_product_exclusive_quote', true);

        $_pf = new WC_Product_Factory();

        $new_product = $_pf->get_product($product_id);

      //  $rfq_enable = get_post_meta($product_id, '_gpls_woo_rfq_rfq_enable', true);
      //  $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $product_id);

        $rfq_enable = gpls_woo_plus_get_rfq_enable($new_product);


        foreach (WC()->cart->cart_contents as $key => $values) {

            if (!isset($values['product_id'])) {
                continue;
            }
            $existing_product = $_pf->get_product($values['product_id']);

            $exclusive_existing_product = rftk_auction_prod_cat_has_meta($existing_product->get_id(), 'gpls_woo_rfq_plus_product_exclusive_quote', true);

            if ($existing_product->get_id() != $product_id && (!gpls_empty($exclusive_new_product) || !gpls_empty($exclusive_existing_product))) {
                $true = false;


                if (!gpls_empty($exclusive_existing_product)) {
                    wc_add_notice('<strong>' . $existing_product->get_title() . '</strong> ' . __(' is a single request item and must be the only item in the quote request.','rfqtk'), 'error');
                }

                if (!gpls_empty($exclusive_new_product)) {
                    wc_add_notice('<strong>' . $new_product->get_title() . '</strong> ' . __(' is a single request item and must be the only item in the quote request.','rfqtk'), 'error');

                }
                return $true;

            }
        }

        return $true;


    }

    function gpls_woo_rfq_plus_customer_bid_rfq_required($posted)
    {

        $customer_bid_required = gpls_woo_rfq_is_bid_required();

        if ($customer_bid_required == false) {
            return;
        }

        if ("" === $_POST['gpls_woo_rfq_plus_customer_bid']) {
            wc_add_notice($customer_bid_required . '<strong>Customer Offer</strong> ' . __(' is a required field.', 'rfqtk'), 'error');
        }
    }


    function gpls_woo_rfq_is_bid_required()
    {

        if (!is_admin()) {
            return false;
        }

        $customer_bid_required = false;

        $rfq_check = false;

        $normal_check = false;

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
            if (get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'no') {
                $rfq_check = true;
            }
        }


        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "normal_checkout") {
            //  if (get_option('settings_gpls_woo_rfq_normal_checkout_show_prices','no') == 'no' )
            {
                $normal_check = true;
            }
        }

        if (function_exists('wp_get_current_user')) {
            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
                $rfq_check = true;
                $normal_check = false;
            }
        }


        $customer_bid_required_global = get_option('settings_gpls_woo_rfq_make_customer_offer_required', 'no');



        if ($normal_check == true) {

            $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');


            if (($gpls_woo_rfq_cart == false)) {
                return false;
            }

            foreach ($gpls_woo_rfq_cart as $key => $values) {

                //$product = $values['data']->get_post();
                if (!isset($values['product_id'])) {
                    continue;
                }

                $is_limited = rftk_auction_prod_cat_has_meta($values['product_id'], '_gpls_woo_rfq_plus_offer_period_limit', true);

                if ($is_limited == "yes") {

                    if (rftk_auction_is_in_effect($values['product_id']) == false) {
                        continue;
                    }
                }

                $customer_bid_required_product = rftk_auction_prod_cat_has_meta($values['product_id'], '_gpls_woo_rfq_plus_product_customer_offer_required', true);


               // $rfq_enable = get_post_meta($values['product_id'], '_gpls_woo_rfq_rfq_enable', true);
               // $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $values['product_id']);

                $product = wc_get_product($values['product_id']);
                $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


                if ($normal_check == true && $customer_bid_required_product == 'yes' && $rfq_enable == "yes") {

                    $customer_bid_required = true;

                    break;
                }
                if ($normal_check == true && $customer_bid_required_global == 'yes' && $rfq_enable == "yes") {

                    $customer_bid_required = true;

                    break;
                }


            }


        }


        if ($rfq_check == true) {

            foreach (WC()->cart->cart_contents as $key => $values) {

                //$product = $values['data']->get_post();
                if (!isset($values['product_id'])) {
                    continue;
                }
                $is_limited = rftk_auction_prod_cat_has_meta($values['product_id'], '_gpls_woo_rfq_plus_offer_period_limit', true);

                if ($is_limited == "yes") {
                    if (rftk_auction_is_in_effect($values['product_id']) == false) {
                        continue;
                    }
                }

                $customer_bid_required_product = rftk_auction_prod_cat_has_meta($values['product_id'], '_gpls_woo_rfq_plus_product_customer_offer_required', true);


                if ($rfq_check == true && $customer_bid_required_product == 'yes') {

                    $customer_bid_required = true;

                    break;
                }

                if ($rfq_check == true && $customer_bid_required_global == 'yes') {

                    $customer_bid_required = true;

                    break;
                }

            }


        }


        $customer_bid_required = apply_filters('gpls_woo_rfq_customer_bid_required', $customer_bid_required);
        return $customer_bid_required;
    }


    function gpls_woo_rfq_plus_customer_bid()
    {

        //ob_start();
        if (get_option('settings_gpls_woo_rfq_allow_customer_offer', 'no') != 'yes') {
            return;
        }

        if (get_option('settings_gpls_woo_rfq_allow_customer_offer', 'no') == 'yes') {

            $settings_gpls_woo_rfq_limit_to_rfq_only = get_option('settings_gpls_woo_rfq_limit_to_rfq_only', '');

            $items = WC()->cart->get_cart();

            $has_rfq = false;

            $specific_gateway = 'gpls-rfq';

            WC()->initialize_session();

            $chosen_method = WC()->session->get( 'chosen_payment_method' );

            if( $chosen_method == $specific_gateway ) {
                WC()->session->set('chosen_payment_method',null);
            }

            foreach ($items as $item => $values) {


                $_product = wc_get_product($values['product_id']);

               // $rfq_enable = get_post_meta($_product->get_id(), '_gpls_woo_rfq_rfq_enable', true);
              //  $rfq_enable = apply_filters('gpls_rfq_enable',$rfq_enable,$_product->get_id());

                $rfq_enable = gpls_woo_plus_get_rfq_enable($_product);

                if ($rfq_enable == 'yes' ) {
                    $has_rfq = true;
                    break;
                }
            }




            if ($settings_gpls_woo_rfq_limit_to_rfq_only == "yes" && $has_rfq == true) {


                wc_get_template('woo-rfq/bid/bid-rfq.php', array(),
                    '', gpls_woo_rfq_plus_DIR . 'woocommerce/');

            }
        }
        //echo ob_get_clean();


    }

    function gpls_woo_rfq_plus_customer_bid_quote_request_page()
    {

        $customer_bid_required = "no";

        $rfq_check = false;

        $normal_check = false;

        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "rfq") {
            if (get_option('settings_gpls_woo_rfq_show_prices', 'no') == 'no') {
                $rfq_check = true;
            }
        }


        if (get_option('settings_gpls_woo_rfq_checkout_option', 'normal_checkout') == "normal_checkout") {
            //  if (get_option('settings_gpls_woo_rfq_normal_checkout_show_prices','no') == 'no' )
            {
                $normal_check = true;
            }
        }

        if (function_exists('wp_get_current_user')) {
            if (get_option('settings_gpls_woo_rfq_hide_visitor_prices', 'no') == 'yes' && !wp_get_current_user()->exists()) {
                $rfq_check = true;
                $normal_check = false;
            }
        }

        $customer_bid_required_global = get_option('settings_gpls_woo_rfq_make_customer_offer_required', 'no');

        if ($normal_check == true && $customer_bid_required_global == 'yes') {

            $customer_bid_required = "yes";


        }
        if ($rfq_check == true && $customer_bid_required_global == 'yes') {

            $customer_bid_required = "yes";
        }

        $gpls_woo_rfq_cart = gpls_woo_rfq_get_item('gpls_woo_rfq_cart');

        foreach ($gpls_woo_rfq_cart as $key => $values) {

           // $product = $values['data']->post;

            $is_limited = rftk_auction_prod_cat_has_meta($values['product_id'], '_gpls_woo_rfq_plus_offer_period_limit', true);

            if ($is_limited == "yes") {
                if (rftk_auction_is_in_effect($values['product_id']) == false) {
                    continue;
                }
            }

            $customer_bid_required_product = rftk_auction_prod_cat_has_meta($values['product_id'], '_gpls_woo_rfq_plus_product_customer_offer_required', true);

         //   $rfq_enable = get_post_meta($values['product_id'], '_gpls_woo_rfq_rfq_enable', true);
         //   $rfq_enable = apply_filters('gpls_rfq_enable', $rfq_enable, $values['product_id']);

            $product = wc_get_product($values['product_id']);
            $rfq_enable = gpls_woo_plus_get_rfq_enable($product);


            if ($normal_check == true && $customer_bid_required_product == 'yes' && $rfq_enable == "yes") {

                $customer_bid_required = "yes";

                break;
            }

            if ($rfq_check == true && $customer_bid_required_product == 'yes' && $rfq_enable == "yes") {

                $customer_bid_required = "yes";

                break;
            }


        }

        $customer_bid_required = apply_filters('gpls_woo_rfq_customer_bid_required', $customer_bid_required);


        if ($customer_bid_required == 'yes') {

            $url_js = gpls_woo_rfq_plus_URL . 'assets/js/rfqtk.js';
            $url_js_path = gpls_woo_rfq_plus_DIR . 'assets/js/rfqtk.js';
            wp_enqueue_script('gpls_woo_rfq_plus_js', $url_js, array('jquery'), rand(10,100000), true);


            $custom_js =
                "jQuery('#gpls_woo_rfq_Plus_submit').on('click', function(){

    if (typeof jQuery('#gpls_woo_rfq_plus_customer_bid') != 'undefined')
    {
        jQuery('#gpls_woo_rfq_plus_customer_bid').attr(\"required\", false);
        jQuery('#gpls_woo_rfq_plus_customer_bid').removeClass(\"required\");
    }
});
jQuery('.gpls-woo-rfq_checkout_button').on('click', function(){jQuery('#gpls_woo_rfq_plus_customer_bid').attr('required',true);});";

            wp_add_inline_script('gpls_woo_rfq_plus_js', $custom_js);

        }


        //ob_start();

        wc_get_template('woo-rfq/bid/bid-normal.php',array()
            ,'',gpls_woo_rfq_plus_DIR . 'woocommerce/');

        //echo ob_get_clean();


    }


    function gpls_woo_rfq_plus_save_customer_offer($order_id, $data)
    {
        //customer bid


        if (isset($_POST['gpls_woo_rfq_plus_customer_bid']) && $_POST['gpls_woo_rfq_plus_customer_bid'] != '') {

            update_post_meta($order_id, '_woo_rfq_customer_bid', $_POST['gpls_woo_rfq_plus_customer_bid']);

            $of = new WC_Order_Factory();

            $order = $of::get_order($order_id);


            gpls_woo_rfq_add_order_note($order,'Customer Offer ' . wc_price($_POST['gpls_woo_rfq_plus_customer_bid'],1,true));

            $order->update_meta_data('_woo_rfq_customer_bid', $_POST['gpls_woo_rfq_plus_customer_bid']);

            do_action('woocommerce_new_admin_note', array('order_id' => $order->get_id(),
                'accepted_offer' => false, 'customer_note' => 'Customer Offer ' . wc_price($_POST['gpls_woo_rfq_plus_customer_bid'])));

            do_action('gplsrfq_new_admin_note', $order->get_id(), 'Customer Offer ' . wc_price($_POST['gpls_woo_rfq_plus_customer_bid']));

        }


    }


    function rfqtk_display_offer_in_admin($order)
    {
        $ends=gpls_woo_rfq_plus_startsWith(get_option(GPLS_WOO_RFQ_PLUS::instance()->ame_activated_key),'D');
        if ($ends==1) {
            return;
        }

        $customer_offer = get_post_meta($order->get_id(), '_woo_rfq_customer_bid', true);

        if (!gpls_empty($customer_offer)) {

            $customer_offer_text = __('Customer Bid', 'rfqtk');
            echo '<div  style="clear: both; margin-top:5px; height: 20px; display:block;font-size:larger "></div>';
            echo '<div  style="clear: both; margin-top:5px; display:block;;font-weight: bold;font-size:larger"><h1>' . $customer_offer_text . '</h1></div>';
            echo '<div style="font-size:medium">
<strong>' . __('Bid', '') . ':</strong> ' . wc_price(get_post_meta($order->get_id(), '_woo_rfq_customer_bid', true) ). '<br />

</div>';

        }

    }


    function rftk_auction_is_in_effect($product_id)
    {


        $start_date = rftk_auction_prod_cat_has_meta($product_id, "_gpls_woo_rfq_plus_product_rfq_start_date", true);
        $end_date = rftk_auction_prod_cat_has_meta($product_id, "_gpls_woo_rfq_plus_product_rfq_end_date", true);

        // convert dates to timestamps (strings to integers)

//echo $start_date.'<br />';;
        // echo $end_date.'<br /$now = new DateTime();
        $now = date('m-d-Y');
        $now = DateTime::createFromFormat('m-d-Y', $now);
        $startdate = DateTime::createFromFormat('m-d-Y', $start_date);
        $enddate = DateTime::createFromFormat('m-d-Y', $end_date);


// isBetween is Boolean TRUE if reference date is greater or equal fromDate and smaller or equal toDate
        if ($startdate <= $now && $now <= $enddate) {
            //echo 't';
            return true;
        } else {
            //echo 'f';
            return false;
        }


    }


    function rftk_auction_prod_cat_has_meta($product_id, $meta_key, $single = true)
    {

        $override = get_post_meta($product_id, '_gpls_woo_rfq_plus_auction_override_category_rules', true);

        if ($override == "yes") {

            $meta_val = get_post_meta($product_id, $meta_key, true);
            $start_date = get_post_meta($product_id, "_gpls_woo_rfq_plus_product_rfq_start_date", true);
            $end_date = get_post_meta($product_id, "_gpls_woo_rfq_plus_product_rfq_end_date", true);

            $now = date('m-d-Y');
            $now = DateTime::createFromFormat('m-d-Y', $now);
            $startdate = DateTime::createFromFormat('m-d-Y', $start_date);
            $enddate = DateTime::createFromFormat('m-d-Y', $end_date);

            if ($meta_val != false && ($startdate <= $now && $now <= $enddate)) {
                return $meta_val;
            }

        } else {
            $product = wc_get_product($product_id);

            $category_ids = $product->get_category_ids('');

            $last_valid_cat=false;

            foreach ($category_ids as $category_id) {



                $meta_val = get_term_meta($category_id, $meta_key, true);

                $start_date = get_term_meta($category_id, "_gpls_woo_rfq_plus_product_rfq_start_date", true);
                $end_date = get_term_meta($category_id, "_gpls_woo_rfq_plus_product_rfq_end_date", true);

                $now = date('m-d-Y');
                $now = DateTime::createFromFormat('m-d-Y', $now);
                $startdate = DateTime::createFromFormat('m-d-Y', $start_date);
                $enddate = DateTime::createFromFormat('m-d-Y', $end_date);

                if($meta_key=='_gpls_woo_rfq_plus_product_exclusive_quantity_warning'){
                    if (($startdate <= $now && $now <= $enddate)) {



                        $last_valid_cat = $meta_val;
                    }

                }else{
                    if ($meta_val != false && ($startdate <= $now && $now <= $enddate)) {



                        $last_valid_cat = $meta_val;
                    }
                }



            }

            if ($last_valid_cat != false) {
                return $last_valid_cat;
            }
        }

        return false;
    }


}
