<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


if (!class_exists('class_rfq_page_plus')) {

    /**
     * Customer Processing RFQ Email
     *
     * An email sent to the customer when a new RFQ is received.
     * @extends     WC_Email
     */
    class class_rfq_page_plus
    {


        /**
         * Constructor
         */
        function __construct()
        {

            add_filter('gpls_woo_rfq_before_cart_gpls_woo_rfq_styles', 'gpls_woo_rfq_before_cart_gpls_woo_rfq_create_styles', 10, 1);

            //gpls_woo_rfq_request_page_top_html_desc



                add_action('gpls_woo_rfq_request_page_top_html_desc', 'gpls_woo_rfq_request_page_output_top_html', 10);



            $settings_gpls_woo_rfq_enabled_page_desc_bottom = get_option('settings_gpls_woo_rfq_enabled_page_desc_bottom', 'no');
            $settings_gpls_woo_rfq_enabled_page_desc_bottom = __($settings_gpls_woo_rfq_enabled_page_desc_bottom,'rfqtk');

            if ($settings_gpls_woo_rfq_enabled_page_desc_bottom === 'yes') {

                add_action('gpls_woo_rfq_request_page_bottom_html_desc', 'gpls_woo_rfq_request_page_output_bottom_html', 10);

            }


            add_action('wp_enqueue_scripts', 'gpls_woo_add_rfq_custom_rfq_page_css_js', 1000);
            add_action('wp_print_scripts', 'gpls_woo_add_rfq_custom_rfq_page_css_js', 1000);
            add_action('wp_print_footer_scripts', 'gpls_woo_add_rfq_custom_rfq_page_css_js', 1000);

            add_action('gpls_woo_rfq_before_cart', 'gpls_woo_add_rfq_custom_rfq_page_css', 1000);

            add_filter('wp_header', 'gpls_woo_add_rfq_custom_rfq_page_css', 1000);







//button colors
//"background-color: #fff; color:#eee"


        }


    }
}


