<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


if (function_exists('Ninja_Forms')) {


    $ninja_data = get_post_meta($order->get_id(), '_ninja_forms_fields', true);

    if ($ninja_data == '') return;

if (!isset($ninja_data) || !is_array($ninja_data) || count($ninja_data)==0 ) {
    return;
}

    $formid = get_option('settings_gpls_woo_ninja_form_option', '');
    $data = array();

    $all_forms = Ninja_Forms()->form()->get_forms();

    foreach ($all_forms as $form) {

        $data[] = array(
            'id' => $form->get_id(),
            'title' => $form->get_setting('title'),
            'shortcode' => apply_filters('ninja_forms_form_list_shortcode', '[ninja_form id=' . $form->get_id() . ']', $form->get_id()),
            'date' => $form->get_setting('created_at')
        );
    }


    foreach ($data as $form_data) {

        if ($form_data['id'] == $formid)

            $form_title = $form_data['title'];
        break;
    }


    if (!isset($form_title)) {
        $form_title = __('Customer Request Form', 'rfqtk');
    }

    if (isset($ninja_data) && is_array($ninja_data) && count($ninja_data)>0 ) {

        echo '<h1><hr width="100%"></h1>';
        echo '<h1>' . $form_title . '</h1>';

        foreach ($ninja_data as $key) {
            echo '<strong>' . ($key["label"]) . '</strong><br />' . '&nbsp;&nbsp;' . ($key["value"]) . '<br /><br />';
        }

    }

}

?>


