<?php
/**
 * Customer Notes
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/woo-rfq/myacct/cust-notes.php.
 * @author  Neah Plugins
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
?>

<?php

do_action('gpls_woo_rfq_before_customer_note_form');


?>
<div style="text-align: left;inline-block;">

    <div style="float:left;margin-top:20px;margin-bottom:20px; display:block; ">
        <form id="gpls_woo_rfq_Plus_customer_note_form" class="gpls_woo_rfq_Plus_customer_note_form"
              method="post" action="" enctype="multipart/form-data">

            <?php wp_nonce_field('gpls_woo_rfq_Plus_customer_note_form_nonce'); ?>

            <?php if ($show_accept_offer == 'yes'): ?>

                <?php if ($status == 'gplsquote-sent' && !$gpls_accepted_offer && $order->needs_payment()): ?>

                    <?php

                    if ($allow_customer_offer == 'yes') {

                        if ($cart_is_quote_request_based_on_items_in_cart == "yes" && $cart_has_quote_item == true) {

                            wc_get_template('woo-rfq/bid/bid-rfq.php', array()
                                , '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
                        }

                    }

                    ?>
                    <?php wc_get_template('woo-rfq/myacct/note_accept_offer.php', array()
                        , '', gpls_woo_rfq_plus_DIR . 'woocommerce/'); ?>


                <?php endif; ?>

                <?php
                if ($gpls_accepted_offer): ?>

                    <h3>
                        <?php
                        echo __('Quote accepted on ', 'rfqtk') . date_i18n(get_option('date_format'), $gpls_accepted_offer_date) . '.</br>';

                        ?>
                    </h3>


                <?php endif; ?>


                <?php


                if ($gpls_accepted_offer && $order->needs_payment() && $include_pay_link == 'yes'): ?>

                    <h3>
                        <?php
                        printf(__('You can pay by using the following link: %s', 'rfqtk'), '<a href="' . esc_url($order->get_checkout_payment_url()) . '">' . __('pay', 'rfqtk') . '</a>');

                        ?>
                    </h3>


                <?php endif; ?>

            <?php else: ?>

                <?php if ($status == 'gplsquote-sent' && $order->needs_payment()): ?>
                    <h2><?php echo __('Total: ', 'rfqtk') . $order_total; ?></h2>

                    <h2>
                        <?php

                        printf(__('You can pay by using the following link: %s', 'rfqtk'),
                            '<a href="' . esc_url($order->get_checkout_payment_url()) . '"><strong>' . __('pay', 'rfqtk') . '</strong></a>');

                        ?>
                    </h2>

                <?php endif; ?>

            <?php endif; ?>


            <?php if ((in_array($status,$status_allowed) && $show_notes === 'yes')): ?>

                <?php wc_get_template('woo-rfq/myacct/note_form.php', array('order_id' => $order_id)
                    , '', gpls_woo_rfq_plus_DIR . 'woocommerce/'); ?>

            <?php endif; ?>

            <?php

            if ($combine_notes_with_upload === "yes")
            {

                ?>

                <input type="hidden" name="admin_note" value="<?php echo uniqid($order_id . '_', true) ?>"/>&nbsp;

                <?php


                wc_get_template('woo-rfq/upload/file-custnotes.php', array(
                    'gpls_woo_rfq_Plus_file_category' => $gpls_woo_rfq_Plus_file_category,
                    'order_id' => $order_id

                ), '', gpls_woo_rfq_plus_DIR . 'woocommerce/');
            }
            ?>
            <input type="hidden" name="order_id" value="<?php echo $order_id ?>"/>&nbsp;&nbsp;

            <?php if ($show_submit === 'yes'): ?>

                <div style="text-align:center ">
                    <input type="submit" id="gpls_woo_rfq_Plus_submit"
                           name="gpls_woo_rfq_Plus_submit"
                           value="<?php echo $customer_note_text ?>"
                           style="<?php echo $gpls_woo_rfq_upload_styles['gpls_woo_rfq_page_button_styles'] ?>;"
                           onmouseover="<?php echo $gpls_woo_rfq_upload_styles['gpls_woo_rfq_page_button_onmouseover'] . ';' . $gpls_woo_rfq_upload_styles['gpls_woo_rfq_page_button_background_onmouseover'] ?>"
                           onmouseout="<?php echo $gpls_woo_rfq_upload_styles['gpls_woo_rfq_page_button_onmouseout'] . ';' . $gpls_woo_rfq_upload_styles['gpls_woo_rfq_page_button_background_onmouseout'] ?>"
                    >
                </div>
            <?php endif; ?>


        </form>
    </div>
    <div style="clear: both; margin-top:20px;margin-bottom:20px; display:block;"></div>
</div>

<?php
do_action('gpls_woo_rfq_after_customer_note_form');
?>


