<?php
if (!defined('ABSPATH'))
    exit;

//echo '<br />notes_items:';
echo '<ul class="order_notes">';
        foreach ($notes as $note) {

            $note_classes = array('note');
            $note_classes[] = get_comment_meta($note->comment_ID, 'is_customer_note', true) ? 'customer-note' : '';
            $note_classes[] = $note->comment_author === __('WooCommerce', 'rfqtk') ? 'system-note' : '';
            $note_classes = apply_filters('woocommerce_order_note_class', array_filter($note_classes), $note);


            $background='';
            if ($note->comment_agent == 'Customer'){
                $background='background: #a7cedc;';
            }

            ?>
            <li rel="<?php echo absint($note->comment_ID); ?>"
                class="<?php echo esc_attr(implode(' ', $note_classes)); ?>">
                <div class="note_content" style="<?php echo $background; ?>">
                    <?php echo wpautop(wptexturize(wp_kses_post($note->comment_content))); ?>
                </div>
                <p class="meta" >
                    <abbr class="exact-date"
                          title="<?php echo $note->comment_date; ?>"><?php printf(__('added on %1$s at %2$s', 'rfqtk'), date_i18n(wc_date_format(), strtotime($note->comment_date)), date_i18n(wc_time_format(), strtotime($note->comment_date))); ?></abbr>
                    <?php if ($note->comment_agent == 'Customer') echo(' ' . __('by', 'rfqtk'). ' '. $note->comment_author); ?>

                </p>
            </li>
            <?php
        }

echo '</ul>';


