<?php

/**
 * Proposal Detail Items
 * @author  Neah Plugins

 * @author  Neah Plugins
 * This template can be overridden by copying it to yourtheme/woocommerce/woo-rfq/rfqtk-proposal-order-items.php.php
 */

defined( 'ABSPATH' ) || exit;

$text_align = is_rtl() ? 'right' : 'left';

foreach ( $items as $item_id => $item ) :
    $product       = $item->get_product();
    $sku           = '';
    $purchase_note = '';
    $image         = '';

    if ( ! apply_filters( 'woocommerce_order_item_visible', true, $item ) ) {
        continue;
    }

    if ( is_object( $product ) ) {
        $sku           = $product->get_sku();
        $purchase_note = $product->get_purchase_note();
        $image         = $product->get_image( $image_size );
    }

    ?>
    <tr class="<?php echo esc_attr( apply_filters( 'woocommerce_order_item_class', 'order_item', $item, $order ) ); ?>">
        <td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align: middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; word-wrap:break-word;">
            <?php

            // Show title/image etc.
            if ( $show_image ) {
                echo wp_kses_post( apply_filters( 'woocommerce_order_item_thumbnail', $image, $item ) );
            }

            // Product name.
            echo wp_kses_post( apply_filters( 'woocommerce_order_item_name', $item->get_name(), $item, false ) );

            if ( $show_desc=="yes" ) {
                echo '<div class="" style="display:block; clear:both">' . apply_filters('woocommerce_short_description', get_post($product->get_id())->post_content) . '</div>';
            }
            // SKU.
            if ( $show_sku && $sku ) {
                echo wp_kses_post( ' (#' . $sku . ')' );
            }

            // allow other plugins to add additional product information here.
            do_action( 'woocommerce_order_item_meta_start', $item_id, $item, $order, $plain_text );

            wc_display_item_meta( $item, array(
                'label_before' => '<strong class="wc-item-meta-label" style="float: left; margin-right: .25em; clear: both">',
            ) );

            // allow other plugins to add additional product information here.
            do_action( 'woocommerce_order_item_meta_end', $item_id, $item, $order, $plain_text );

            ?>
        </td>
        <td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align:middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;">
            <?php echo wp_kses_post( apply_filters( 'woocommerce_email_order_item_quantity', $item->get_quantity(), $item ) ); ?>
        </td>
        <td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align:middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;">
            <?php echo wp_kses_post( $order->get_formatted_line_subtotal( $item ) ); ?>
        </td>
    </tr>
    <?php

    if ( $show_purchase_note && $purchase_note ) {
        ?>
        <tr>
            <td colspan="3" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align:middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif;">
                <?php
                echo wp_kses_post( wpautop( do_shortcode( $purchase_note ) ) );
                ?>
            </td>
        </tr>
        <?php
    }
    ?>

<?php endforeach; ?>
