<?php

namespace CTXFeed\V5\Merchant;
class MerchantAttributeReplaceFactory {
	public static function data( $template, $file_type ) {
		$data = [
			'google'                 => [
				'XML'  => [
					'id'                            => array( 'g:id', false ),
					'webitemid'                     => array( 'g:webitemid', false ),
					'region_id'                     => array( 'g:region_id', false ),
					'title'                         => array( 'g:title', true ),
					'description'                   => array( 'g:description', true ),
					'link'                          => array( 'link', true ),
					'canonical_link'                => array( 'g:canonical_link', true ),
					'mobile_link'                   => array( 'mobile_link', true ),
					'product_type'                  => array( 'g:product_type', true ),
					'current_category'              => array( 'g:google_product_category', true ),
					'image'                         => array( 'g:image_link', true ),
					'images'                        => array( 'g:additional_image_link', false ),
					'images_1'                      => array( 'g:additional_image_link', true ),
					'images_2'                      => array( 'g:additional_image_link', true ),
					'images_3'                      => array( 'g:additional_image_link', true ),
					'images_4'                      => array( 'g:additional_image_link', true ),
					'images_5'                      => array( 'g:additional_image_link', true ),
					'images_6'                      => array( 'g:additional_image_link', true ),
					'images_7'                      => array( 'g:additional_image_link', true ),
					'images_8'                      => array( 'g:additional_image_link', true ),
					'images_9'                      => array( 'g:additional_image_link', true ),
					'images_10'                     => array( 'g:additional_image_link', true ),
					'lifestyle_image'               => array( 'g:lifestyle_image_link', true ),
					'condition'                     => array( 'g:condition', false ),
					'availability'                  => array( 'g:availability', false ),
					'availability_date'             => array( 'g:availability_date', false ),
					'inventory'                     => array( 'g:inventory', false ),
					'price'                         => array( 'g:price', true ),
					'sale_price'                    => array( 'g:sale_price', true ),
					'sale_price_effective_date'     => array( 'g:sale_price_effective_date', true ),
					'auto_pricing_min_price'     	=> array( 'g:auto_pricing_min_price', true ),
					'brand'                         => array( 'g:brand', true ),
					'sku'                           => array( 'g:mpn', true ),
					'upc'                           => array( 'g:gtin', true ),
					'identifier_exists'             => array( 'g:identifier_exists', true ),
					'item_group_id'                 => array( 'g:item_group_id', false ),
					'external_seller_id'            => array( 'g:external_seller_id', false ),
					'product_length'                => array( 'g:product_length', true ),
					'product_width'                 => array( 'g:product_width', true ),
					'product_height'                => array( 'g:product_height', true ),
					'product_weight'                => array( 'g:product_weight', true ),
					'product_highlight_1'           => array( 'g:product_highlight', true ),
					'product_highlight_2'           => array( 'g:product_highlight', true ),
					'product_highlight_3'           => array( 'g:product_highlight', true ),
					'product_highlight_4'           => array( 'g:product_highlight', true ),
					'product_highlight_5'           => array( 'g:product_highlight', true ),
					'product_highlight_6'           => array( 'g:product_highlight', true ),
					'product_highlight_7'           => array( 'g:product_highlight', true ),
					'product_highlight_8'           => array( 'g:product_highlight', true ),
					'product_highlight_9'           => array( 'g:product_highlight', true ),
					'product_highlight_10'          => array( 'g:product_highlight', true ),
					'color'                         => array( 'g:color', true ),
					'gender'                        => array( 'g:gender', true ),
					'age_group'                     => array( 'g:age_group', true ),
					'material'                      => array( 'g:material', true ),
					'pattern'                       => array( 'g:pattern', true ),
					'size'                          => array( 'g:size', true ),
					'size_type'                     => array( 'g:size_type', true ),
					'size_system'                   => array( 'g:size_system', true ),
					'tax'                           => array( 'g:tax', true ),
					'country'                       => array( 'g:country', true ),
					'region'                        => array( 'g:region', true ),
					'postal_code'                   => array( 'g:postal_code', true ),
					'rate'                          => array( 'g:rate', true ),
					'tax_ship'                      => array( 'g:tax_ship', true ),
					'tax_category'                  => array( 'g:tax_category', true ),
					'free_shipping_label'           => array( 'g:free_shipping_label', true ),
					'free_shipping_limit'           => array( 'g:free_shipping_limit', true ),
					'average_review_rating'         => array( 'g:average_review_rating', true ),
					'number_of_ratings'             => array( 'g:number_of_ratings', true ),
					'number_of_reviews'             => array( 'g:number_of_reviews', true ),
					'shipping'                      => array( 'g:shipping', true ),
					'weight'                        => array( 'g:shipping_weight', false ),
					'length'                        => array( 'g:shipping_length', false ),
					'width'                         => array( 'g:shipping_width', false ),
					'height'                        => array( 'g:shipping_height', false ),
					'ships_from_country'            => array( 'g:ships_from_country', false ),
					'shipping_label'                => array( 'g:shipping_label', false ),
					'multipack'                     => array( 'g:multipack', true ),
					'is_bundle'                     => array( 'g:is_bundle', true ),
					'adult'                         => array( 'g:adult', true ),
					'ads_redirect'                  => array( 'g:ads_redirect', true ),
					'pause'                  		=> array( 'g:pause', true ),
					'ads_labels'                    => array( 'g:ads_labels', true ),
					'ads_grouping'                  => array( 'g:ads_grouping', true ),
					'custom_label_0'                => array( 'g:custom_label_0', true ),
					'custom_label_1'                => array( 'g:custom_label_1', true ),
					'custom_label_2'                => array( 'g:custom_label_2', true ),
					'custom_label_3'                => array( 'g:custom_label_3', true ),
					'custom_label_4'                => array( 'g:custom_label_4', true ),
					'excluded_destination'          => array( 'g:excluded_destination', true ),
					'shopping_ads_excluded_country' => array( 'g:shopping_ads_excluded_country', true ),
					'included_destination'          => array( 'g:included_destination', true ),
					'expiration_date'               => array( 'g:expiration_date', true ),
					'unit_pricing_measure'          => array( 'g:unit_pricing_measure', true ),
					'unit_pricing_base_measure'     => array( 'g:unit_pricing_base_measure', true ),
					'subscription_cost'             => array( 'g:subscription_cost', true ),
					'months'                        => array( 'g:months', true ),
					'amount'                        => array( 'g:amount', true ),
					'period'                        => array( 'g:period', true ),
					'product_detail'                => array( 'g:product_detail', true ),
					'section_name'                  => array( 'g:section_name', true ),
					'attribute_name'                => array( 'g:attribute_name', true ),
					'attribute_value'               => array( 'g:attribute_value', true ),
					'product_highlight'             => array( 'g:product_highlight', true ),

					'material_1'                          => array( 'g:material', true ),
					'material_2'                          => array( 'g:material', true ),
					'energy_efficiency_class'             => array( 'g:energy_efficiency_class', true ),
					'min_energy_efficiency_class'         => array( 'g:min_energy_efficiency_class', true ),
					'max_energy_efficiency_class'         => array( 'g:max_energy_efficiency_class', true ),
					'loyalty_points'                      => array( 'g:loyalty_points', true ),
					'installment'                         => array( 'g:installment', true ),
					'promotion_id'                        => array( 'g:promotion_id', true ),
					'product_applicability'               => array( 'g:product_applicability', true ),
					'offer_type'                          => array( 'g:offer_type', true ),
					'long_title'                          => array( 'g:long_title', true ),
					'promotion_effective_dates'           => array( 'g:promotion_effective_dates', true ),
					'redemption_channel'                  => array( 'g:redemption_channel', true ),
					'promotion_destination'               => array( 'g:promotion_destination', true ),
					'percent_off'                         => array( 'g:percent_off', true ),
					'money_off_amount'                    => array( 'g:money_off_amount', true ),
					'get_this_quantity_discounted'        => array( 'g:get_this_quantity_discounted', true ),
					'free_shipping'                       => array( 'g:free_shipping', true ),
					'free_gift_value'                     => array( 'g:free_gift_value', true ),
					'free_gift_description'               => array( 'g:free_gift_description', true ),
					'promotion_display_dates'             => array( 'g:promotion_display_dates', true ),
					'generic_redemption_code'             => array( 'g:generic_redemption_code', true ),
					'fine_print'                          => array( 'g:fine_print', true ),
					'promotion_price'                     => array( 'g:promotion_price', true ),
					'coupon_value_type'                   => array( 'g:coupon_value_type', true ),
					'limit_quantity'                      => array( 'g:limit_quantity', true ),
					'limit_value'                         => array( 'g:limit_value', true ),
					'minimum_purchase_amount'             => array( 'g:minimum_purchase_amount', true ),
					'item_id_exclusion'                   => array( 'g:item_id_exclusion', true ),
					'product_type_exclusion'              => array( 'g:product_type_exclusion', true ),
					'brand_exclusion'                     => array( 'g:brand_exclusion', true ),
					'item_group_id_exclusion'             => array( 'g:item_group_id_exclusion', true ),
					'cost_of_goods_sold'                  => array( 'g:cost_of_goods_sold', true ),
					'sell_on_google_quantity'             => array( 'g:sell_on_google_quantity', false ),
					'location_id'                         => array( 'g:location_id', false ),
					'location_group_name'                 => array( 'g:location_group_name', false ),
					'min_handling_time'                   => array( 'g:min_handling_time', false ),
					'max_handling_time'                   => array( 'g:max_handling_time', false ),
					'max_transit_time'                    => array( 'g:max_transit_time', false ),
					'min_transit_time'                    => array( 'g:min_transit_time', false ),
					'transit_time_label'                  => array( 'g:transit_time_label', false ),
					'return_address_label'                => array( 'g:return_address_label', false ),
					'return_policy_label'                 => array( 'g:return_policy_label', false ),
					'store_code'                          => array( 'g:store_code', false ),
					'quantity'                            => array( 'g:quantity', true ),
					'pickup_method'                       => array( 'g:pickup_method', true ),
					'pickup_sla'                          => array( 'g:pickup_sla', true ),
					'pickup_link_template'                => array( 'g:pickup_link_template', true ),
					'link_template'                       => array( 'g:link_template', true ),
					'mobile_link_template'                => array( 'g:mobile_link_template', true ),
					'mobile_pickup_link_template'         => array( 'g:mobile_pickup_link_template', true ),
					'local_shipping_label'         		  => array( 'g:local_shipping_label', true ),
					'certification'         			  => array( 'g:certification', true ),
					'capacity'         			  		  => array( 'g:capacity', true ),
					'google_funded_promotion_eligibility' => array(
						'g:google_funded_promotion_eligibility',
						false,
					),
					'certified_pre-owned'         			  		  => array( 'g:certified_pre-owned', true ),
				],
				'CSV'  => [
					'id'                                  => array( 'id', false ),
					'webitemid'                           => array( 'webitemid', false ),
					'region_id'                           => array( 'region_id', false ),
					'title'                               => array( 'title', true ),
					'description'                         => array( 'description', true ),
					'link'                                => array( 'link', true ),
					'canonical_link'                      => array( 'canonical link', true ),
					'mobile_link'                         => array( 'mobile_link', true ),
					'product_type'                        => array( 'product type', true ),
					'current_category'                    => array( 'google product category', true ),
					'image'                               => array( 'image link', true ),
					'images'                              => array( 'additional image link', true ),
					'images_1'                            => array( 'additional image link', true ),
					'images_2'                            => array( 'additional image link', true ),
					'images_3'                            => array( 'additional image link', true ),
					'images_4'                            => array( 'additional image link', true ),
					'images_5'                            => array( 'additional image link', true ),
					'images_6'                            => array( 'additional image link', true ),
					'images_7'                            => array( 'additional image link', true ),
					'images_8'                            => array( 'additional image link', true ),
					'images_9'                            => array( 'additional image link', true ),
					'images_10'                           => array( 'additional image link', true ),
					'lifestyle_image'                     => array( 'lifestyle image link', true ),
					'condition'                           => array( 'condition', false ),
					'availability'                        => array( 'availability', false ),
					'availability_date'                   => array( 'availability date', false ),
					'inventory'                           => array( 'inventory', false ),
					'price'                               => array( 'price', true ),
					'sale_price'                          => array( 'sale price', true ),
					'sale_price_effective_date'           => array( 'sale price effective date', true ),
					'auto_pricing_min_price'              => array( 'auto pricing minimum price', true ),
					'brand'                               => array( 'brand', true ),
					'sku'                                 => array( 'mpn', true ),
					'upc'                                 => array( 'gtin', true ),
					'identifier_exists'                   => array( 'identifier exists', true ),
					'item_group_id'                       => array( 'item group id', false ),
					'external_seller_id'                  => array( 'external seller id', false ),
					'product_length'                      => array( 'product length', true ),
					'product_width'                       => array( 'product width', true ),
					'product_height'                      => array( 'product height', true ),
					'product_weight'                      => array( 'product weight', true ),
					'product_highlight'                   => array( 'product highlight', true ),
					'color'                               => array( 'color', true ),
					'gender'                              => array( 'gender', true ),
					'age_group'                           => array( 'age group', true ),
					'material'                            => array( 'material', true ),
					'pattern'                             => array( 'pattern', true ),
					'size'                                => array( 'size', true ),
					'size_type'                           => array( 'size type', true ),
					'size_system'                         => array( 'size system', true ),
					'free_shipping_label'                 => array( 'free_shipping_label', true ),
					'free_shipping_limit'                 => array( 'free_shipping_limit', true ),
					'average_review_rating'               => array( 'average_review_rating', true ),
					'number_of_ratings'                   => array( 'number_of_ratings', true ),
					'number_of_reviews'                   => array( 'number_of_reviews', true ),
					'checkout_link_template'              => array( 'checkout link template', true ),
					'tax'                                 => array(
						'tax(country:region:rate:postal_code:tax_ship)',
						true
					),
					'tax_category'                        => array( 'tax category', true ),
					'shipping'                                 => array(
						'shipping(country:state:service:price)',
						true
					),
					//'shipping'                            => array( 'shipping', true ),
					'weight'                              => array( 'shipping weight', false ),
					'length'                              => array( 'shipping length', false ),
					'width'                               => array( 'shipping width', false ),
					'height'                              => array( 'shipping height', false ),
					'ships_from_country'                  => array( 'ships from country', false ),
					'shipping_label'                      => array( 'shipping label', false ),
					'shipping_country'                    => array( 'shipping country', false ),
					'shipping_service'                    => array( 'shipping service', false ),
					'shipping_price'                      => array( 'shipping price', false ),
					'shipping_region'                     => array( 'shipping region', false ),
					'multipack'                           => array( 'multipack', true ),
					'is_bundle'                           => array( 'is bundle', true ),
					'adult'                               => array( 'adult', true ),
					'ads_redirect'                        => array( 'ads redirect', true ),
					'pause'                        		  => array( 'pause', true ),
					'custom_label_0'                      => array( 'custom label 0', true ),
					'custom_label_1'                      => array( 'custom label 1', true ),
					'custom_label_2'                      => array( 'custom label 2', true ),
					'custom_label_3'                      => array( 'custom label 3', true ),
					'custom_label_4'                      => array( 'custom label 4', true ),
					'excluded_destination'                => array( 'excluded destination', true ),
					'shopping_ads_excluded_country'       => array( 'shopping ads excluded country', true ),
					'included_destination'                => array( 'included destination', true ),
					'expiration_date'                     => array( 'expiration date', true ),
					'unit_pricing_measure'                => array( 'unit pricing measure', true ),
					'unit_pricing_base_measure'           => array( 'unit pricing base measure', true ),
					'installment_months'                  => array( 'months', true ),
					'installment_amount'                  => array( 'amount', true ),
					'subscription_period'                 => array( 'period', true ),
					'subscription_period_length'          => array( 'period_length', true ),
					'subscription_amount'                 => array( 'amount', true ),
					'energy_efficiency_class'             => array( 'energy efficiency class', true ),
					'min_energy_efficiency_class'         => array( 'min energy efficiency class', true ),
					'max_energy_efficiency_class'         => array( 'max energy efficiency class', true ),
					'loyalty_points'                      => array( 'loyalty points', true ),
					'installment'                         => array( 'installment', true ),
					'promotion_id'                        => array( 'promotion id', true ),
					'cost_of_goods_sold'                  => array( 'cost of goods sold', true ),
					'sell_on_google_quantity'             => array( 'sell on google quantity', false ),
					'min_handling_time'                   => array( 'min handling time', false ),
					'max_handling_time'                   => array( 'max handling time', false ),
					'transit_time_label'                  => array( 'transit time label', false ),
					'return_address_label'                => array( 'return address label', false ),
					'return_policy_label'                 => array( 'return policy label', false ),
					'store_code'                          => array( 'store code', false ),
					'pickup_method'                       => array( 'pickup method', true ),
					'pickup_sla'                          => array( 'pickup sla', true ),
					'pickup_link_template'                => array( 'pickup link template', true ),
					'link_template'                       => array( 'link template', true ),
					'mobile_link_template'                => array( 'mobile link template', true ),
					'mobile_pickup_link_template'         => array( 'mobile pickup link template', true ),
					'local_shipping_label'         		  => array( 'g:local_shipping_label', true ),
					'google_funded_promotion_eligibility' => array(
						'google funded promotion eligibility',
						false,
					),
				],
				'JSON' => [],
			],
			'facebook'               => [
				'XML'  => [
					'id'                           => array( 'g:id', false ),
					'title'                        => array( 'g:title', true ),
					'description'                  => array( 'g:description', true ),
					'link'                         => array( 'g:link', true ),
					'mobile_link'                  => array( 'g:mobile_link', true ),
					'product_type'                 => array( 'g:product_type', true ),
					'current_category'             => array( 'g:google_product_category', true ),
					'image'                        => array( 'g:image_link', true ),
					'images'                       => array( 'g:additional_image_link', false ),
					'images_1'                     => array( 'g:additional_image_link', true ),
					'images_2'                     => array( 'g:additional_image_link', true ),
					'images_3'                     => array( 'g:additional_image_link', true ),
					'images_4'                     => array( 'g:additional_image_link', true ),
					'images_5'                     => array( 'g:additional_image_link', true ),
					'images_6'                     => array( 'g:additional_image_link', true ),
					'images_7'                     => array( 'g:additional_image_link', true ),
					'images_8'                     => array( 'g:additional_image_link', true ),
					'images_9'                     => array( 'g:additional_image_link', true ),
					'images_10'                    => array( 'g:additional_image_link', true ),
					'condition'                    => array( 'g:condition', false ),
					'availability'                 => array( 'g:availability', false ),
					'inventory'                    => array( 'g:inventory', false ),
					'override'                     => array( 'g:override', false ),
					'price'                        => array( 'g:price', true ),
					'sale_price'                   => array( 'g:sale_price', true ),
					'sale_price_effective_date'    => array( 'g:sale_price_effective_date', true ),
					'brand'                        => array( 'g:brand', true ),
					'sku'                          => array( 'g:mpn', true ),
					'upc'                          => array( 'g:gtin', true ),
					'identifier_exists'            => array( 'g:identifier_exists', true ),
					'item_group_id'                => array( 'g:item_group_id', false ),
					'color'                        => array( 'g:color', true ),
					'gender'                       => array( 'g:gender', true ),
					'age_group'                    => array( 'g:age_group', true ),
					'material'                     => array( 'g:material', true ),
					'pattern'                      => array( 'g:pattern', true ),
					'size'                         => array( 'g:size', true ),
					'size_type'                    => array( 'g:size_type', true ),
					'size_system'                  => array( 'g:size_system', true ),
					'tax'                          => array( 'g:tax', true ),
					'weight'                       => array( 'g:shipping_weight', false ),
					'length'                       => array( 'g:shipping_length', false ),
					'width'                        => array( 'g:shipping_width', false ),
					'height'                       => array( 'g:shipping_height', false ),
					'shipping'                     => array( 'g:shipping', true ),
					'ships_from_country'           => array( 'g:ships_from_country', false ),
					'shipping_label'               => array( 'g:shipping_label', false ),
					'shipping_country'             => array( 'g:shipping_country', false ),
					'shipping_service'             => array( 'g:shipping_service', false ),
					'shipping_price'               => array( 'g:shipping_price', false ),
					'shipping_region'              => array( 'g:shipping_region', false ),
					'multipack'                    => array( 'g:multipack', true ),
					'is_bundle'                    => array( 'g:is_bundle', true ),
					'adult'                        => array( 'g:adult', true ),
					'adwords_redirect'             => array( 'g:adwords_redirect', true ),
					'internal_label'               => array( 'g:internal_label', true ),
					'custom_label_0'               => array( 'g:custom_label_0', true ),
					'custom_label_1'               => array( 'g:custom_label_1', true ),
					'custom_label_2'               => array( 'g:custom_label_2', true ),
					'custom_label_3'               => array( 'g:custom_label_3', true ),
					'custom_label_4'               => array( 'g:custom_label_4', true ),
					'excluded_destination'         => array( 'g:excluded_destination', true ),
					'expiration_date'              => array( 'g:expiration_date', true ),
					'unit_pricing_measure'         => array( 'g:unit_pricing_measure', true ),
					'unit_pricing_base_measure'    => array( 'g:unit_pricing_base_measure', true ),
					'energy_efficiency_class'      => array( 'g:energy_efficiency_class', true ),
					'loyalty_points'               => array( 'g:loyalty_points', true ),
					'installment'                  => array( 'g:installment', true ),
					'promotion_id'                 => array( 'g:promotion_id', true ),
					'cost_of_goods_sold'           => array( 'g:cost_of_goods_sold', true ),
					'availability_date'            => array( 'g:availability_date', true ),
					'tax_category'                 => array( 'g:tax_category', true ),
					'included_destination'         => array( 'g:included_destination', true ),
					'quantity_to_sell_on_facebook' => array( 'g:quantity_to_sell_on_facebook', true ),
				],
				'CSV'  => [
					'id'                           => array( 'id', false ),
					'title'                        => array( 'title', true ),
					'description'                  => array( 'description', true ),
					'link'                         => array( 'link', true ),
					'mobile_link'                  => array( 'mobile_link', true ),
					'product_type'                 => array( 'product type', true ),
					'current_category'             => array( 'google product category', true ),
					'image'                        => array( 'image link', true ),
					'images'                       => array( 'additional image link', true ),
					'additional_image_link'        => array( 'additional image link', true ),
					'images_1'                     => array( 'additional image link', true ),
					'images_2'                     => array( 'additional image link', true ),
					'images_3'                     => array( 'additional image link', true ),
					'images_4'                     => array( 'additional image link', true ),
					'images_5'                     => array( 'additional image link', true ),
					'images_6'                     => array( 'additional image link', true ),
					'images_7'                     => array( 'additional image link', true ),
					'images_8'                     => array( 'additional image link', true ),
					'images_9'                     => array( 'additional image link', true ),
					'images_10'                    => array( 'additional image link', true ),
					'condition'                    => array( 'condition', false ),
					'availability'                 => array( 'availability', false ),
					'inventory'                    => array( 'inventory', false ),
					'override'                     => array( 'override', false ),
					'price'                        => array( 'price', true ),
					'sale_price'                   => array( 'sale price', true ),
					'sale_price_effective_date'    => array( 'sale price effective date', true ),
					'brand'                        => array( 'brand', true ),
					'sku'                          => array( 'mpn', true ),
					'upc'                          => array( 'gtin', true ),
					'identifier_exists'            => array( 'identifier exists', true ),
					'item_group_id'                => array( 'item group id', false ),
					'color'                        => array( 'color', true ),
					'gender'                       => array( 'gender', true ),
					'age_group'                    => array( 'age group', true ),
					'material'                     => array( 'material', true ),
					'pattern'                      => array( 'pattern', true ),
					'size'                         => array( 'size', true ),
					'size_type'                    => array( 'size type', true ),
					'size_system'                  => array( 'size system', true ),
					'tax'                          => array( 'tax', true ),
					'weight'                       => array( 'shipping weight', false ),
					'length'                       => array( 'shipping length', false ),
					'width'                        => array( 'shipping width', false ),
					'height'                       => array( 'shipping height', false ),
					'ships_from_country'           => array( 'ships from country', false ),
					'shipping_label'               => array( 'shipping label', false ),
					'shipping_country'             => array( 'shipping country', false ),
					'shipping_service'             => array( 'shipping service', false ),
					'shipping_price'               => array( 'shipping price', false ),
					'shipping_region'              => array( 'shipping region', false ),
					'multipack'                    => array( 'multipack', true ),
					'is_bundle'                    => array( 'is bundle', true ),
					'adult'                        => array( 'adult', true ),
					'adwords_redirect'             => array( 'adwords redirect', true ),
					'internal_label'              => array( 'internal_label', true ),
					'custom_label_0'               => array( 'custom label 0', true ),
					'custom_label_1'               => array( 'custom label 1', true ),
					'custom_label_2'               => array( 'custom label 2', true ),
					'custom_label_3'               => array( 'custom label 3', true ),
					'custom_label_4'               => array( 'custom label 4', true ),
					'excluded_destination'         => array( 'excluded destination', true ),
					'expiration_date'              => array( 'expiration date', true ),
					'unit_pricing_measure'         => array( 'unit pricing measure', true ),
					'unit_pricing_base_measure'    => array( 'unit pricing base measure', true ),
					'energy_efficiency_class'      => array( 'energy efficiency class', true ),
					'loyalty_points'               => array( 'loyalty points', true ),
					'installment'                  => array( 'installment', true ),
					'promotion_id'                 => array( 'promotion id', true ),
					'cost_of_goods_sold'           => array( 'cost of goods sold', true ),
					'availability_date'            => array( 'availability date', true ),
					'tax_category'                 => array( 'tax category', true ),
					'included_destination'         => array( 'included destination', true ),
					'quantity_to_sell_on_facebook' => array( 'quantity_to_sell_on_facebook', true ),
				],
				'JSON' => [],
			],
			'pinterest'              => [
				'XML'  => [
					'id'                        => array( 'g:id', false ),
					'title'                     => array( 'title', true ),
					'description'               => array( 'description', true ),
					'link'                      => array( 'link', true ),
					'mobile_link'               => array( 'mobile_link', true ),
					'product_type'              => array( 'g:product_type', true ),
					'current_category'          => array( 'g:google_product_category', true ),
					'image'                     => array( 'g:image_link', true ),
					'images'                    => array( 'g:additional_image_link', false ),
					'images_1'                  => array( 'g:additional_image_link', true ),
					'images_2'                  => array( 'g:additional_image_link', true ),
					'images_3'                  => array( 'g:additional_image_link', true ),
					'images_4'                  => array( 'g:additional_image_link', true ),
					'images_5'                  => array( 'g:additional_image_link', true ),
					'images_6'                  => array( 'g:additional_image_link', true ),
					'images_7'                  => array( 'g:additional_image_link', true ),
					'images_8'                  => array( 'g:additional_image_link', true ),
					'images_9'                  => array( 'g:additional_image_link', true ),
					'images_10'                 => array( 'g:additional_image_link', true ),
					'condition'                 => array( 'g:condition', false ),
					'availability'              => array( 'g:availability', false ),
					'availability_date'         => array( 'g:availability_date', false ),
					'inventory'                 => array( 'g:inventory', false ),
					'price'                     => array( 'g:price', true ),
					'sale_price'                => array( 'g:sale_price', true ),
					'sale_price_effective_date' => array( 'g:sale_price_effective_date', true ),
					'brand'                     => array( 'g:brand', true ),
					'sku'                       => array( 'g:mpn', true ),
					'upc'                       => array( 'g:gtin', true ),
					'identifier_exists'         => array( 'g:identifier_exists', true ),
					'item_group_id'             => array( 'g:item_group_id', false ),
					'color'                     => array( 'g:color', true ),
					'gender'                    => array( 'g:gender', true ),
					'age_group'                 => array( 'g:age_group', true ),
					'material'                  => array( 'g:material', true ),
					'pattern'                   => array( 'g:pattern', true ),
					'size'                      => array( 'g:size', true ),
					'size_type'                 => array( 'g:size_type', true ),
					'size_system'               => array( 'g:size_system', true ),
					'tax'                       => array( 'g:tax', true ),
					'tax_country'               => array( 'g:tax_country', true ),
					'tax_region'                => array( 'g:tax_region', true ),
					'tax_rate'                  => array( 'g:tax_rate', true ),
					'tax_ship'                  => array( 'g:tax_ship', true ),
					'tax_category'              => array( 'g:tax_category', true ),
					'free_shipping_label'       => array( 'g:free_shipping_label', true ),
					'free_shipping_limit'       => array( 'g:free_shipping_limit', true ),
					'average_review_rating'     => array( 'g:average_review_rating', true ),
					'number_of_ratings'         => array( 'g:number_of_ratings', true ),
					'number_of_reviews'         => array( 'g:number_of_reviews', true ),
					'weight'                    => array( 'g:shipping_weight', false ),
					'length'                    => array( 'g:shipping_length', false ),
					'width'                     => array( 'g:shipping_width', false ),
					'height'                    => array( 'g:shipping_height', false ),
					'ships_from_country'        => array( 'g:ships_from_country', false ),
					'shipping'                  => array( 'g:shipping', true ),
					'shipping_label'            => array( 'g:shipping_label', false ),
					'shipping_country'          => array( 'g:shipping_country', false ),
					'shipping_service'          => array( 'g:shipping_service', false ),
					'shipping_price'            => array( 'g:shipping_price', false ),
					'shipping_region'           => array( 'g:shipping_region', false ),
					'multipack'                 => array( 'g:multipack', true ),
					'is_bundle'                 => array( 'g:is_bundle', true ),
					'adult'                     => array( 'g:adult', true ),
					'adwords_redirect'          => array( 'g:adwords_redirect', true ),
					'custom_label_0'            => array( 'g:custom_label_0', true ),
					'custom_label_1'            => array( 'g:custom_label_1', true ),
					'custom_label_2'            => array( 'g:custom_label_2', true ),
					'custom_label_3'            => array( 'g:custom_label_3', true ),
					'custom_label_4'            => array( 'g:custom_label_4', true ),
					'excluded_destination'      => array( 'g:excluded_destination', true ),
					'included_destination'      => array( 'g:included_destination', true ),
					'expiration_date'           => array( 'g:expiration_date', true ),
					'unit_pricing_measure'      => array( 'g:unit_pricing_measure', true ),
					'unit_pricing_base_measure' => array( 'g:unit_pricing_base_measure', true ),
					'energy_efficiency_class'   => array( 'g:energy_efficiency_class', true ),
					'loyalty_points'            => array( 'g:loyalty_points', true ),
					'installment'               => array( 'g:installment', true ),
					'promotion_id'              => array( 'g:promotion_id', true ),
					'cost_of_goods_sold'        => array( 'g:cost_of_goods_sold', true ),
				],
				'CSV'  => [
					'id'                        => array( 'id', false ),
					'title'                     => array( 'title', true ),
					'description'               => array( 'description', true ),
					'link'                      => array( 'link', true ),
					'mobile_link'               => array( 'mobile_link', true ),
					'product_type'              => array( 'product_type', true ),
					'current_category'          => array( 'google_product_category', true ),
					'image'                     => array( 'image_link', true ),
					'images'                    => array( 'additional_image_link', true ),
					'images_1'                  => array( 'additional_image_link', true ),
					'images_2'                  => array( 'additional_image_link', true ),
					'images_3'                  => array( 'additional_image_link', true ),
					'images_4'                  => array( 'additional_image_link', true ),
					'images_5'                  => array( 'additional_image_link', true ),
					'images_6'                  => array( 'additional_image_link', true ),
					'images_7'                  => array( 'additional_image_link', true ),
					'images_8'                  => array( 'additional_image_link', true ),
					'images_9'                  => array( 'additional_image_link', true ),
					'images_10'                 => array( 'additional_image_link', true ),
					'condition'                 => array( 'condition', false ),
					'availability'              => array( 'availability', false ),
					'availability_date'         => array( 'availability_date', false ),
					'inventory'                 => array( 'inventory', false ),
					'price'                     => array( 'price', true ),
					'sale_price'                => array( 'sale_price', true ),
					'sale_price_effective_date' => array( 'sale_price_effective_date', true ),
					'brand'                     => array( 'brand', true ),
					'sku'                       => array( 'mpn', true ),
					'upc'                       => array( 'gtin', true ),
					'identifier_exists'         => array( 'identifier_exists', true ),
					'item_group_id'             => array( 'item_group_id', false ),
					'color'                     => array( 'color', true ),
					'gender'                    => array( 'gender', true ),
					'age_group'                 => array( 'age_group', true ),
					'material'                  => array( 'material', true ),
					'pattern'                   => array( 'pattern', true ),
					'size'                      => array( 'size', true ),
					'size_type'                 => array( 'size_type', true ),
					'size_system'               => array( 'size_system', true ),
					'tax'                       => array( 'tax', true ),
					'tax_country'               => array( 'tax_country', true ),
					'tax_region'                => array( 'tax_region', true ),
					'tax_rate'                  => array( 'tax_rate', true ),
					'tax_ship'                  => array( 'tax_ship', true ),
					'tax_category'              => array( 'tax_category', true ),
					'free_shipping_label'       => array( 'free_shipping_label', true ),
					'free_shipping_limit'       => array( 'free_shipping_limit', true ),
					'average_review_rating'     => array( 'average_review_rating', true ),
					'number_of_ratings'         => array( 'number_of_ratings', true ),
					'number_of_reviews'         => array( 'number_of_reviews', true ),
					'weight'                    => array( 'shipping_weight', false ),
					'length'                    => array( 'shipping_length', false ),
					'width'                     => array( 'shipping_width', false ),
					'height'                    => array( 'shipping_height', false ),
					'ships_from_country'        => array( 'ships_from_country', false ),
					'shipping_label'            => array( 'shipping_label', false ),
					'shipping_country'          => array( 'shipping_country', false ),
					'shipping_service'          => array( 'shipping_service', false ),
					'shipping_price'            => array( 'shipping_price', false ),
					'shipping_region'           => array( 'shipping_region', false ),
					'multipack'                 => array( 'multipack', true ),
					'is_bundle'                 => array( 'is_bundle', true ),
					'adult'                     => array( 'adult', true ),
					'adwords_redirect'          => array( 'adwords_redirect', true ),
					'custom_label_0'            => array( 'custom_label_0', true ),
					'custom_label_1'            => array( 'custom_label_1', true ),
					'custom_label_2'            => array( 'custom_label_2', true ),
					'custom_label_3'            => array( 'custom_label_3', true ),
					'custom_label_4'            => array( 'custom_label_4', true ),
					'excluded_destination'      => array( 'excluded_destination', true ),
					'included_destination'      => array( 'included_destination', true ),
					'expiration_date'           => array( 'expiration_date', true ),
					'unit_pricing_measure'      => array( 'unit_pricing_measure', true ),
					'unit_pricing_base_measure' => array( 'unit_pricing_base_measure', true ),
					'energy_efficiency_class'   => array( 'energy_efficiency_class', true ),
					'loyalty_points'            => array( 'loyalty_points', true ),
					'installment'               => array( 'installment', true ),
					'promotion_id'              => array( 'promotion_id', true ),
					'cost_of_goods_sold'        => array( 'cost_of_goods_sold', true ),
				],
				'JSON' => [],
			],
			'skroutz'                => [
				'XML'  => [
					'id'                       => array( 'id', false ),
					'name'                     => array( 'name', true ),
					'description'              => array( 'description', true ),
					'link'                     => array( 'link', true ),
					'image'                    => array( 'image', true ),
					'category'                 => array( 'category', true ),
					'price'                    => array( 'price', false ),
					'price_with_vat'           => array( 'price_with_vat', false ),
					'manufacturer'             => array( 'manufacturer', true ),
					'mpn'                      => array( 'mpn', false ),
					'ean'                      => array( 'ean', false ),
					'instock'                  => array( 'instock', false ),
					'availability'             => array( 'availability', false ),
					'color'                    => array( 'color', false ),
					'size'                     => array( 'size', false ),
					'weight'                   => array( 'weight', false ),
					'quantity'                 => array( 'quantity', false ),
					'additional_imageurl'      => array( 'additional_imageurl', true ),
					'additional_imageurl_1'    => array( 'additional_imageurl', true ),
					'additional_imageurl_2'    => array( 'additional_imageurl', true ),
					'additional_imageurl_3'    => array( 'additional_imageurl', true ),
					'additional_imageurl_4'    => array( 'additional_imageurl', true ),
					'additional_imageurl_5'    => array( 'additional_imageurl', true ),
					'additional_imageurl_6'    => array( 'additional_imageurl', true ),
					'additional_imageurl_7'    => array( 'additional_imageurl', true ),
					'additional_imageurl_8'    => array( 'additional_imageurl', true ),
					'additional_imageurl_9'    => array( 'additional_imageurl', true ),
					'additional_imageurl_10'   => array( 'additional_imageurl', true ),
					'lifestyle_image'          => array( 'lifestyle_imageurl', true ),
				],
				'CSV'  => [],
				'JSON' => [],
			],
			'tiktok'                 => [
				'XML'  => [
					'id'                            => array( 'g:id', false ),
					'sku_id'                        => array( 'g:sku_id', true ),
					'webitemid'                     => array( 'g:webitemid', false ),
					'region_id'                     => array( 'g:region_id', false ),
					'title'                         => array( 'g:title', true ),
					'description'                   => array( 'g:description', true ),
					'link'                          => array( 'g:link', true ),
					'canonical_link'                => array( 'g:canonical_link', true ),
					'mobile_link'                   => array( 'mobile_link', true ),
					'product_type'                  => array( 'g:product_type', true ),
					'google_product_category'       => array( 'g:google_product_category', true ),
					'image_link'                    => array( 'g:image_link', true ),
					'additional_image_link'         => array( 'g:additional_image_link', false ),
					'images_1'                      => array( 'g:additional_image_link', true ),
					'images_2'                      => array( 'g:additional_image_link', true ),
					'images_3'                      => array( 'g:additional_image_link', true ),
					'images_4'                      => array( 'g:additional_image_link', true ),
					'images_5'                      => array( 'g:additional_image_link', true ),
					'images_6'                      => array( 'g:additional_image_link', true ),
					'images_7'                      => array( 'g:additional_image_link', true ),
					'images_8'                      => array( 'g:additional_image_link', true ),
					'images_9'                      => array( 'g:additional_image_link', true ),
					'images_10'                     => array( 'g:additional_image_link', true ),
					'lifestyle_image'               => array( 'g:lifestyle_image_link', true ),
					'condition'                     => array( 'g:condition', false ),
					'availability'                  => array( 'g:availability', false ),
					'availability_date'             => array( 'g:availability_date', false ),
					'inventory'                     => array( 'g:inventory', false ),
					'price'                         => array( 'g:price', true ),
					'sale_price'                    => array( 'g:sale_price', true ),
					'sale_price_effective_date'     => array( 'g:sale_price_effective_date', true ),
					'auto_pricing_min_price'     	=> array( 'g:auto_pricing_min_price', true ),
					'brand'                         => array( 'g:brand', true ),
					'sku'                           => array( 'g:mpn', true ),
					'upc'                           => array( 'g:gtin', true ),
					'identifier_exists'             => array( 'g:identifier_exists', true ),
					'item_group_id'                 => array( 'g:item_group_id', false ),
					'external_seller_id'            => array( 'g:external_seller_id', false ),
					'product_length'                => array( 'g:product_length', true ),
					'product_width'                 => array( 'g:product_width', true ),
					'product_height'                => array( 'g:product_height', true ),
					'product_weight'                => array( 'g:product_weight', true ),
					'product_highlight_1'           => array( 'g:product_highlight', true ),
					'product_highlight_2'           => array( 'g:product_highlight', true ),
					'product_highlight_3'           => array( 'g:product_highlight', true ),
					'product_highlight_4'           => array( 'g:product_highlight', true ),
					'product_highlight_5'           => array( 'g:product_highlight', true ),
					'product_highlight_6'           => array( 'g:product_highlight', true ),
					'product_highlight_7'           => array( 'g:product_highlight', true ),
					'product_highlight_8'           => array( 'g:product_highlight', true ),
					'product_highlight_9'           => array( 'g:product_highlight', true ),
					'product_highlight_10'          => array( 'g:product_highlight', true ),
					'color'                         => array( 'g:color', true ),
					'gender'                        => array( 'g:gender', true ),
					'age_group'                     => array( 'g:age_group', true ),
					'material'                      => array( 'g:material', true ),
					'pattern'                       => array( 'g:pattern', true ),
					'size'                          => array( 'g:size', true ),
					'size_type'                     => array( 'g:size_type', true ),
					'size_system'                   => array( 'g:size_system', true ),
					'tax'                           => array( 'g:tax', true ),
					'country'                       => array( 'g:country', true ),
					'region'                        => array( 'g:region', true ),
					'postal_code'                   => array( 'g:postal_code', true ),
					'rate'                          => array( 'g:rate', true ),
					'tax_ship'                      => array( 'g:tax_ship', true ),
					'tax_category'                  => array( 'g:tax_category', true ),
					'free_shipping_label'           => array( 'g:free_shipping_label', true ),
					'free_shipping_limit'           => array( 'g:free_shipping_limit', true ),
					'average_review_rating'         => array( 'g:average_review_rating', true ),
					'number_of_ratings'             => array( 'g:number_of_ratings', true ),
					'number_of_reviews'             => array( 'g:number_of_reviews', true ),
					'shipping'                      => array( 'g:shipping', true ),
					'weight'                        => array( 'g:shipping_weight', false ),
					'length'                        => array( 'g:shipping_length', false ),
					'width'                         => array( 'g:shipping_width', false ),
					'height'                        => array( 'g:shipping_height', false ),
					'ships_from_country'            => array( 'g:ships_from_country', false ),
					'shipping_label'                => array( 'g:shipping_label', false ),
					'multipack'                     => array( 'g:multipack', true ),
					'is_bundle'                     => array( 'g:is_bundle', true ),
					'adult'                         => array( 'g:adult', true ),
					'ads_redirect'                  => array( 'g:ads_redirect', true ),
					'pause'                  		=> array( 'g:pause', true ),
					'custom_label_0'                => array( 'g:custom_label_0', true ),
					'custom_label_1'                => array( 'g:custom_label_1', true ),
					'custom_label_2'                => array( 'g:custom_label_2', true ),
					'custom_label_3'                => array( 'g:custom_label_3', true ),
					'custom_label_4'                => array( 'g:custom_label_4', true ),
					'excluded_destination'          => array( 'g:excluded_destination', true ),
					'shopping_ads_excluded_country' => array( 'g:shopping_ads_excluded_country', true ),
					'included_destination'          => array( 'g:included_destination', true ),
					'expiration_date'               => array( 'g:expiration_date', true ),
					'unit_pricing_measure'          => array( 'g:unit_pricing_measure', true ),
					'unit_pricing_base_measure'     => array( 'g:unit_pricing_base_measure', true ),
					'subscription_cost'             => array( 'g:subscription_cost', true ),
					'months'                        => array( 'g:months', true ),
					'amount'                        => array( 'g:amount', true ),
					'period'                        => array( 'g:period', true ),
					'product_detail'                => array( 'g:product_detail', true ),
					'section_name'                  => array( 'g:section_name', true ),
					'attribute_name'                => array( 'g:attribute_name', true ),
					'attribute_value'               => array( 'g:attribute_value', true ),
					'product_highlight'             => array( 'g:product_highlight', true ),

					'material_1'                          => array( 'g:material', true ),
					'material_2'                          => array( 'g:material', true ),
					'energy_efficiency_class'             => array( 'g:energy_efficiency_class', true ),
					'min_energy_efficiency_class'         => array( 'g:min_energy_efficiency_class', true ),
					'max_energy_efficiency_class'         => array( 'g:max_energy_efficiency_class', true ),
					'loyalty_points'                      => array( 'g:loyalty_points', true ),
					'installment'                         => array( 'g:installment', true ),
					'promotion_id'                        => array( 'g:promotion_id', true ),
					'product_applicability'               => array( 'g:product_applicability', true ),
					'offer_type'                          => array( 'g:offer_type', true ),
					'long_title'                          => array( 'g:long_title', true ),
					'promotion_effective_dates'           => array( 'g:promotion_effective_dates', true ),
					'redemption_channel'                  => array( 'g:redemption_channel', true ),
					'promotion_destination'               => array( 'g:promotion_destination', true ),
					'percent_off'                         => array( 'g:percent_off', true ),
					'money_off_amount'                    => array( 'g:money_off_amount', true ),
					'get_this_quantity_discounted'        => array( 'g:get_this_quantity_discounted', true ),
					'free_shipping'                       => array( 'g:free_shipping', true ),
					'free_gift_value'                     => array( 'g:free_gift_value', true ),
					'free_gift_description'               => array( 'g:free_gift_description', true ),
					'promotion_display_dates'             => array( 'g:promotion_display_dates', true ),
					'generic_redemption_code'             => array( 'g:generic_redemption_code', true ),
					'fine_print'                          => array( 'g:fine_print', true ),
					'promotion_price'                     => array( 'g:promotion_price', true ),
					'coupon_value_type'                   => array( 'g:coupon_value_type', true ),
					'limit_quantity'                      => array( 'g:limit_quantity', true ),
					'limit_value'                         => array( 'g:limit_value', true ),
					'minimum_purchase_amount'             => array( 'g:minimum_purchase_amount', true ),
					'item_id_exclusion'                   => array( 'g:item_id_exclusion', true ),
					'product_type_exclusion'              => array( 'g:product_type_exclusion', true ),
					'brand_exclusion'                     => array( 'g:brand_exclusion', true ),
					'item_group_id_exclusion'             => array( 'g:item_group_id_exclusion', true ),
					'cost_of_goods_sold'                  => array( 'g:cost_of_goods_sold', true ),
					'sell_on_google_quantity'             => array( 'g:sell_on_google_quantity', false ),
					'location_id'                         => array( 'g:location_id', false ),
					'location_group_name'                 => array( 'g:location_group_name', false ),
					'min_handling_time'                   => array( 'g:min_handling_time', false ),
					'max_handling_time'                   => array( 'g:max_handling_time', false ),
					'max_transit_time'                    => array( 'g:max_transit_time', false ),
					'min_transit_time'                    => array( 'g:min_transit_time', false ),
					'transit_time_label'                  => array( 'g:transit_time_label', false ),
					'return_address_label'                => array( 'g:return_address_label', false ),
					'return_policy_label'                 => array( 'g:return_policy_label', false ),
					'store_code'                          => array( 'g:store_code', false ),
					'quantity'                            => array( 'g:quantity', true ),
					'pickup_method'                       => array( 'g:pickup_method', true ),
					'pickup_sla'                          => array( 'g:pickup_sla', true ),
					'pickup_link_template'                => array( 'g:pickup_link_template', true ),
					'link_template'                       => array( 'g:link_template', true ),
					'mobile_link_template'                => array( 'g:mobile_link_template', true ),
					'mobile_pickup_link_template'         => array( 'g:mobile_pickup_link_template', true ),
					'certification'         			  => array( 'g:certification', true ),
					'capacity'         			  		  => array( 'g:capacity', true ),
					'google_funded_promotion_eligibility' => array(
						'g:google_funded_promotion_eligibility',
						false,
					),
				],
				'CSV'  => [],
			],

		];
		// TODO missing other templates replaceable attribute.
		$template=self::replace_template($template);

		return isset( $data[ $template ] ) ? $data[ $template ][ strtoupper( $file_type ) ] : [];
	}

	public static function replace_attribute( $attribute, $config ) {
		$feedType = ( 'xml' === $config->feedType ) ? 'xml' : 'csv';
		$data     = self::data( $config->provider, $feedType );
		if ( isset( $data[ $attribute ] ) ) {
			return $data[ $attribute ][0];
		}

		return $attribute;
	}

	public static function replace_template($template){

		$group_classes = [
			'google' => ['google_shopping_action', 'google_local', 'google_local_inventory'],
		];

		foreach ($group_classes as $class => $providers) {
			if (in_array($template, $providers)) {
				return $class;
			}
		}
		return $template;

	}


}
