<?php

/**
 * The file that defines the merchants attributes
 *
 * A class definition that includes attributes and functions used across the
 * admin area.
 *
 * @link       https://webappick.com/
 * @since      1.0.0
 *
 * @package    Woo_Feed
 * @subpackage Woo_Feed/includes
 * @author     Ohidul Islam <wahid@webappick.com>
 */
class Woo_Feed_Default_Attributes {

	public $googleCSVTXTAttribute
		= array(
			'id'                                  => array( 'id', false ),
			'webitemid'                           => array( 'webitemid', false ),
			'region_id'                           => array( 'region_id', false ),
			'title'                               => array( 'title', true ),
			'description'                         => array( 'description', true ),
			'link'                                => array( 'link', true ),
			'canonical_link'                      => array( 'canonical link', true ),
			'mobile_link'                         => array( 'mobile_link', true ),
			'product_type'                        => array( 'product type', true ),
			'current_category'                    => array( 'google product category', true ),
			'image'                               => array( 'image link', true ),
			'images'                              => array( 'additional image link', true ),
			'images_1'                            => array( 'additional image link 1', true ),
			'images_2'                            => array( 'additional image link 2', true ),
			'images_3'                            => array( 'additional image link 3', true ),
			'images_4'                            => array( 'additional image link 4', true ),
			'images_5'                            => array( 'additional image link 5', true ),
			'images_6'                            => array( 'additional image link 6', true ),
			'images_7'                            => array( 'additional image link 7', true ),
			'images_8'                            => array( 'additional image link 8', true ),
			'images_9'                            => array( 'additional image link 9', true ),
			'images_10'                           => array( 'additional image link 10', true ),
			'condition'                           => array( 'condition', false ),
			'availability'                        => array( 'availability', false ),
			'availability_date'                   => array( 'availability date', false ),
			'inventory'                           => array( 'inventory', false ),
			'price'                               => array( 'price', true ),
			'sale_price'                          => array( 'sale price', true ),
			'sale_price_effective_date'           => array( 'sale price effective date', true ),
			'brand'                               => array( 'brand', true ),
			'sku'                                 => array( 'mpn', true ),
			'upc'                                 => array( 'gtin', true ),
			'identifier_exists'                   => array( 'identifier exists', true ),
			'item_group_id'                       => array( 'item group id', false ),
			'external_seller_id'                  => array( 'external seller id', false ),
			'product_length'                      => array( 'product length', true ),
			'product_width'                       => array( 'product width', true ),
			'product_height'                      => array( 'product height', true ),
			'product_weight'                      => array( 'product weight', true ),
			'product_highlight_1'                 => array( 'product highlight 1', true ),
			'product_highlight_2'                 => array( 'product highlight 2', true ),
			'product_highlight_3'                 => array( 'product highlight 3', true ),
			'product_highlight_4'                 => array( 'product highlight 4', true ),
			'product_highlight_5'                 => array( 'product highlight 5', true ),
			'product_highlight_6'                 => array( 'product highlight 6', true ),
			'product_highlight_7'                 => array( 'product highlight 7', true ),
			'product_highlight_8'                 => array( 'product highlight 8', true ),
			'product_highlight_9'                 => array( 'product highlight 9', true ),
			'product_highlight_10'                => array( 'product highlight 10', true ),
			'color'                               => array( 'color', true ),
			'gender'                              => array( 'gender', true ),
			'age_group'                           => array( 'age group', true ),
			'material'                            => array( 'material', true ),
			'pattern'                             => array( 'pattern', true ),
			'size'                                => array( 'size', true ),
			'size_type'                           => array( 'size type', true ),
			'size_system'                         => array( 'size system', true ),
			'free_shipping_label'                 => array( 'free_shipping_label', true ),
			'free_shipping_limit'                 => array( 'free_shipping_limit', true ),
			'average_review_rating'               => array( 'average_review_rating', true ),
			'number_of_ratings'                   => array( 'number_of_ratings', true ),
			'number_of_reviews'                   => array( 'number_of_reviews', true ),
			'tax'                                 => array( 'tax', true ),
			'tax_category'                        => array( 'tax category', true ),
			'shipping'                            => array( 'shipping', true ),
			'weight'                              => array( 'shipping weight', false ),
			'length'                              => array( 'shipping length', false ),
			'width'                               => array( 'shipping width', false ),
			'height'                              => array( 'shipping height', false ),
			'ships_from_country'                  => array( 'ships from country', false ),
			'shipping_label'                      => array( 'shipping label', false ),
			'shipping_country'                    => array( 'shipping country', false ),
			'shipping_service'                    => array( 'shipping service', false ),
			'shipping_price'                      => array( 'shipping price', false ),
			'shipping_region'                     => array( 'shipping region', false ),
			'multipack'                           => array( 'multipack', true ),
			'is_bundle'                           => array( 'is bundle', true ),
			'adult'                               => array( 'adult', true ),
			'ads_redirect'                        => array( 'ads redirect', true ),
			'custom_label_0'                      => array( 'custom label 0', true ),
			'custom_label_1'                      => array( 'custom label 1', true ),
			'custom_label_2'                      => array( 'custom label 2', true ),
			'custom_label_3'                      => array( 'custom label 3', true ),
			'custom_label_4'                      => array( 'custom label 4', true ),
			'excluded_destination'                => array( 'excluded destination', true ),
			'shopping_ads_excluded_country'       => array( 'shopping ads excluded country', true ),
			'included_destination'                => array( 'included destination', true ),
			'expiration_date'                     => array( 'expiration date', true ),
			'unit_pricing_measure'                => array( 'unit pricing measure', true ),
			'unit_pricing_base_measure'           => array( 'unit pricing base measure', true ),
			'installment_months'                  => array( 'months', true ),
			'installment_amount'                  => array( 'amount', true ),
			'subscription_period'                 => array( 'period', true ),
			'subscription_period_length'          => array( 'period_length', true ),
			'subscription_amount'                 => array( 'amount', true ),
			'energy_efficiency_class'             => array( 'energy efficiency class', true ),
			'min_energy_efficiency_class'         => array( 'min energy efficiency class', true ),
			'max_energy_efficiency_class'         => array( 'max energy efficiency class', true ),
			'loyalty_points'                      => array( 'loyalty points', true ),
			'installment'                         => array( 'installment', true ),
			'promotion_id'                        => array( 'promotion id', true ),
			'cost_of_goods_sold'                  => array( 'cost of goods sold', true ),
			'sell_on_google_quantity'             => array( 'sell on google quantity', false ),
			'min_handling_time'                   => array( 'min handling time', false ),
			'max_handling_time'                   => array( 'max handling time', false ),
			'transit_time_label'                  => array( 'transit time label', false ),
			'return_address_label'                => array( 'return address label', false ),
			'return_policy_label'                 => array( 'return policy label', false ),
			'store_code'                          => array( 'store code', false ),
			'pickup_method'                       => array( 'pickup method', true ),
			'pickup_sla'                          => array( 'pickup sla', true ),
			'pickup_link_template'                => array( 'pickup link template', true ),
			'link_template'                       => array( 'link template', true ),
			'mobile_link_template'                => array( 'mobile link template', true ),
			'mobile_pickup_link_template'         => array( 'mobile pickup link template', true ),
			'google_funded_promotion_eligibility' => array(
				'google funded promotion eligibility',
				false,
			),
		);
	public $googleXMLAttribute
    = array(
		'id'                                  => array( 'g:id', false ),
		'webitemid'                           => array( 'g:webitemid', false ),
		'region_id'                           => array( 'g:region_id', false ),
		'title'                               => array( 'g:title', true ),
		'description'                         => array( 'g:description', true ),
		'link'                                => array( 'link', true ),
		'canonical_link'                      => array( 'g:canonical_link', true ),
		'mobile_link'                         => array( 'mobile_link', true ),
		'product_type'                        => array( 'g:product_type', true ),
		'current_category'                    => array( 'g:google_product_category', true ),
		'image'                               => array( 'g:image_link', true ),
		'images'                              => array( 'g:additional_image_link', false ),
		'images_1'                            => array( 'g:additional_image_link', true ),
		'images_2'                            => array( 'g:additional_image_link', true ),
		'images_3'                            => array( 'g:additional_image_link', true ),
		'images_4'                            => array( 'g:additional_image_link', true ),
		'images_5'                            => array( 'g:additional_image_link', true ),
		'images_6'                            => array( 'g:additional_image_link', true ),
		'images_7'                            => array( 'g:additional_image_link', true ),
		'images_8'                            => array( 'g:additional_image_link', true ),
		'images_9'                            => array( 'g:additional_image_link', true ),
		'images_10'                           => array( 'g:additional_image_link', true ),
		'condition'                           => array( 'g:condition', false ),
		'availability'                        => array( 'g:availability', false ),
		'availability_date'                   => array( 'g:availability_date', false ),
		'inventory'                           => array( 'g:inventory', false ),
		'price'                               => array( 'g:price', true ),
		'sale_price'                          => array( 'g:sale_price', true ),
		'sale_price_effective_date'           => array( 'g:sale_price_effective_date', true ),
		'brand'                               => array( 'g:brand', true ),
		'sku'                                 => array( 'g:mpn', true ),
		'upc'                                 => array( 'g:gtin', true ),
		'identifier_exists'                   => array( 'g:identifier_exists', true ),
		'item_group_id'                       => array( 'g:item_group_id', false ),
		'external_seller_id'                  => array( 'g:external_seller_id', false ),
		'product_length'                      => array( 'g:product_length', true ),
		'product_width'                       => array( 'g:product_width', true ),
		'product_height'                      => array( 'g:product_height', true ),
		'product_weight'                      => array( 'g:product_weight', true ),
		'product_highlight_1'                 => array( 'g:product_highlight', true ),
		'product_highlight_2'                 => array( 'g:product_highlight', true ),
		'product_highlight_3'                 => array( 'g:product_highlight', true ),
		'product_highlight_4'                 => array( 'g:product_highlight', true ),
		'product_highlight_5'                 => array( 'g:product_highlight', true ),
		'product_highlight_6'                 => array( 'g:product_highlight', true ),
		'product_highlight_7'                 => array( 'g:product_highlight', true ),
		'product_highlight_8'                 => array( 'g:product_highlight', true ),
		'product_highlight_9'                 => array( 'g:product_highlight', true ),
		'product_highlight_10'                => array( 'g:product_highlight', true ),
		'color'                               => array( 'g:color', true ),
		'gender'                              => array( 'g:gender', true ),
		'age_group'                           => array( 'g:age_group', true ),
		'material'                            => array( 'g:material', true ),
		'pattern'                             => array( 'g:pattern', true ),
		'size'                                => array( 'g:size', true ),
		'size_type'                           => array( 'g:size_type', true ),
		'size_system'                         => array( 'g:size_system', true ),
		'tax'                                 => array( 'g:tax', true ),
		'tax_country'                         => array( 'g:tax_country', true ),
		'tax_region'                          => array( 'g:tax_region', true ),
		'tax_rate'                            => array( 'g:tax_rate', true ),
		'tax_ship'                            => array( 'g:tax_ship', true ),
		'tax_category'                        => array( 'g:tax_category', true ),
		'free_shipping_label'                 => array( 'g:free_shipping_label', true ),
		'free_shipping_limit'                 => array( 'g:free_shipping_limit', true ),
		'average_review_rating'               => array( 'g:average_review_rating', true ),
		'number_of_ratings'                   => array( 'g:number_of_ratings', true ),
		'number_of_reviews'                   => array( 'g:number_of_reviews', true ),
		'shipping'                            => array( 'g:shipping', true ),
		'weight'                              => array( 'g:shipping_weight', false ),
		'length'                              => array( 'g:shipping_length', false ),
		'width'                               => array( 'g:shipping_width', false ),
		'height'                              => array( 'g:shipping_height', false ),
		'ships_from_country'                  => array( 'g:ships_from_country', false ),
		'shipping_label'                      => array( 'g:shipping_label', false ),
		'multipack'                           => array( 'g:multipack', true ),
		'is_bundle'                           => array( 'g:is_bundle', true ),
		'adult'                               => array( 'g:adult', true ),
		'ads_redirect'                        => array( 'g:ads_redirect', true ),
		'custom_label_0'                      => array( 'g:custom_label_0', true ),
		'custom_label_1'                      => array( 'g:custom_label_1', true ),
		'custom_label_2'                      => array( 'g:custom_label_2', true ),
		'custom_label_3'                      => array( 'g:custom_label_3', true ),
		'custom_label_4'                      => array( 'g:custom_label_4', true ),
		'excluded_destination'                => array( 'g:excluded_destination', true ),
		'shopping_ads_excluded_country'       => array( 'g:shopping_ads_excluded_country', true ),
		'included_destination'                => array( 'g:included_destination', true ),
		'expiration_date'                     => array( 'g:expiration_date', true ),
		'unit_pricing_measure'                => array( 'g:unit_pricing_measure', true ),
		'unit_pricing_base_measure'           => array( 'g:unit_pricing_base_measure', true ),
		'installment_months'                  => array( 'g:months', true ),
		'installment_amount'                  => array( 'g:amount', true ),
		'subscription_period'                 => array( 'g:period', true ),
		'subscription_period_length'          => array( 'g:period_length', true ),
		'subscription_amount'                 => array( 'g:amount', true ),
		'energy_efficiency_class'             => array( 'g:energy_efficiency_class', true ),
		'min_energy_efficiency_class'         => array( 'g:min_energy_efficiency_class', true ),
		'max_energy_efficiency_class'         => array( 'g:max_energy_efficiency_class', true ),
		'loyalty_points'                      => array( 'g:loyalty_points', true ),
		'installment'                         => array( 'g:installment', true ),
		'promotion_id'                        => array( 'g:promotion_id', true ),
		'product_applicability'               => array( 'g:product_applicability', true ),
		'offer_type'                          => array( 'g:offer_type', true ),
		'long_title'                          => array( 'g:long_title', true ),
		'promotion_effective_dates'           => array( 'g:promotion_effective_dates', true ),
		'redemption_channel'                  => array( 'g:redemption_channel', true ),
		'promotion_destination'               => array( 'g:promotion_destination', true ),
		'percent_off'                         => array( 'g:percent_off', true ),
		'money_off_amount'                    => array( 'g:money_off_amount', true ),
		'get_this_quantity_discounted'        => array( 'g:get_this_quantity_discounted', true ),
		'free_shipping'                       => array( 'g:free_shipping', true ),
		'free_gift_value'                     => array( 'g:free_gift_value', true ),
		'free_gift_description'               => array( 'g:free_gift_description', true ),
		'promotion_display_dates'             => array( 'g:promotion_display_dates', true ),
		'generic_redemption_code'             => array( 'g:generic_redemption_code', true ),
		'fine_print'                          => array( 'g:fine_print', true ),
		'promotion_price'                     => array( 'g:promotion_price', true ),
		'coupon_value_type'                   => array( 'g:coupon_value_type', true ),
		'limit_quantity'                      => array( 'g:limit_quantity', true ),
		'limit_value'                         => array( 'g:limit_value', true ),
		'minimum_purchase_amount'             => array( 'g:minimum_purchase_amount', true ),
		'item_id_exclusion'                   => array( 'g:item_id_exclusion', true ),
		'product_type_exclusion'              => array( 'g:product_type_exclusion', true ),
		'brand_exclusion'                     => array( 'g:brand_exclusion', true ),
		'item_group_id_exclusion'             => array( 'g:item_group_id_exclusion', true ),

		'cost_of_goods_sold'                  => array( 'g:cost_of_goods_sold', true ),
		'sell_on_google_quantity'             => array( 'g:sell_on_google_quantity', false ),
		'min_handling_time'                   => array( 'g:min_handling_time', false ),
		'max_handling_time'                   => array( 'g:max_handling_time', false ),
		'transit_time_label'                  => array( 'g:transit_time_label', false ),
		'return_address_label'                => array( 'g:return_address_label', false ),
		'return_policy_label'                 => array( 'g:return_policy_label', false ),
		'store_code'                          => array( 'g:store_code', false ),
		'quantity'                            => array( 'g:quantity', true ),
		'pickup_method'                       => array( 'g:pickup_method', true ),
		'pickup_sla'                          => array( 'g:pickup_sla', true ),
		'pickup_link_template'                => array( 'g:pickup_link_template', true ),
		'link_template'                       => array( 'g:link_template', true ),
		'mobile_link_template'                => array( 'g:mobile_link_template', true ),
		'mobile_pickup_link_template'         => array( 'g:mobile_pickup_link_template', true ),
		'google_funded_promotion_eligibility' => array(
			'g:google_funded_promotion_eligibility',
			false,
		),
	);
	public $facebookXMLAttribute
     = array(
		 'id'                           => array( 'g:id', false ),
		 'title'                        => array( 'g:title', true ),
		 'description'                  => array( 'g:description', true ),
		 'link'                         => array( 'g:link', true ),
		 'mobile_link'                  => array( 'g:mobile_link', true ),
		 'product_type'                 => array( 'g:product_type', true ),
		 'current_category'             => array( 'g:google_product_category', true ),
		 'image'                        => array( 'g:image_link', true ),
		 'images'                       => array( 'g:additional_image_link', false ),
		 'images_1'                     => array( 'g:additional_image_link', true ),
		 'images_2'                     => array( 'g:additional_image_link', true ),
		 'images_3'                     => array( 'g:additional_image_link', true ),
		 'images_4'                     => array( 'g:additional_image_link', true ),
		 'images_5'                     => array( 'g:additional_image_link', true ),
		 'images_6'                     => array( 'g:additional_image_link', true ),
		 'images_7'                     => array( 'g:additional_image_link', true ),
		 'images_8'                     => array( 'g:additional_image_link', true ),
		 'images_9'                     => array( 'g:additional_image_link', true ),
		 'images_10'                    => array( 'g:additional_image_link', true ),
		 'condition'                    => array( 'g:condition', false ),
		 'availability'                 => array( 'g:availability', false ),
		 'inventory'                    => array( 'g:inventory', false ),
		 'override'                     => array( 'g:override', false ),
		 'price'                        => array( 'g:price', true ),
		 'sale_price'                   => array( 'g:sale_price', true ),
		 'sale_price_effective_date'    => array( 'g:sale_price_effective_date', true ),
		 'brand'                        => array( 'g:brand', true ),
		 'sku'                          => array( 'g:mpn', true ),
		 'upc'                          => array( 'g:gtin', true ),
		 'identifier_exists'            => array( 'g:identifier_exists', true ),
		 'item_group_id'                => array( 'g:item_group_id', false ),
		 'color'                        => array( 'g:color', true ),
		 'gender'                       => array( 'g:gender', true ),
		 'age_group'                    => array( 'g:age_group', true ),
		 'material'                     => array( 'g:material', true ),
		 'pattern'                      => array( 'g:pattern', true ),
		 'size'                         => array( 'g:size', true ),
		 'size_type'                    => array( 'g:size_type', true ),
		 'size_system'                  => array( 'g:size_system', true ),
		 'tax'                          => array( 'tax', true ),
		 'weight'                       => array( 'g:shipping_weight', false ),
		 'length'                       => array( 'g:shipping_length', false ),
		 'width'                        => array( 'g:shipping_width', false ),
		 'height'                       => array( 'g:shipping_height', false ),
		 'ships_from_country'           => array( 'g:ships_from_country', false ),
		 'shipping_label'               => array( 'g:shipping_label', false ),
		 'shipping'                     => array( 'g:shipping', false ),
		 'shipping_country'             => array( 'g:shipping_country', false ),
		 'shipping_service'             => array( 'g:shipping_service', false ),
		 'shipping_price'               => array( 'g:shipping_price', false ),
		 'shipping_region'              => array( 'g:shipping_region', false ),
		 'multipack'                    => array( 'g:multipack', true ),
		 'is_bundle'                    => array( 'g:is_bundle', true ),
		 'adult'                        => array( 'g:adult', true ),
		 'adwords_redirect'             => array( 'g:adwords_redirect', true ),
		 'custom_label_0'               => array( 'g:custom_label_0', true ),
		 'custom_label_1'               => array( 'g:custom_label_1', true ),
		 'custom_label_2'               => array( 'g:custom_label_2', true ),
		 'custom_label_3'               => array( 'g:custom_label_3', true ),
		 'custom_label_4'               => array( 'g:custom_label_4', true ),
		 'excluded_destination'         => array( 'g:excluded_destination', true ),
		 'expiration_date'              => array( 'g:expiration_date', true ),
		 'unit_pricing_measure'         => array( 'g:unit_pricing_measure', true ),
		 'unit_pricing_base_measure'    => array( 'g:unit_pricing_base_measure', true ),
		 'energy_efficiency_class'      => array( 'g:energy_efficiency_class', true ),
		 'loyalty_points'               => array( 'g:loyalty_points', true ),
		 'installment'                  => array( 'g:installment', true ),
		 'promotion_id'                 => array( 'g:promotion_id', true ),
		 'cost_of_goods_sold'           => array( 'g:cost_of_goods_sold', true ),
		 'availability_date'            => array( 'g:availability_date', true ),
		 'tax_category'                 => array( 'g:tax_category', true ),
		 'included_destination'         => array( 'g:included_destination', true ),
		 'quantity_to_sell_on_facebook' => array( 'g:quantity_to_sell_on_facebook', true ),
	 );
	public $facebookCSVTXTAttribute
  = array(
		'id'                           => array( 'id', false ),
		'title'                        => array( 'title', true ),
		'description'                  => array( 'description', true ),
		'link'                         => array( 'link', true ),
		'mobile_link'                  => array( 'mobile_link', true ),
		'product_type'                 => array( 'product type', true ),
		'current_category'             => array( 'google product category', true ),
		'image'                        => array( 'image link', true ),
		'images'                       => array( 'additional image link', true ),
		'images_1'                     => array( 'additional image link', true ),
		'images_2'                     => array( 'additional image link', true ),
		'images_3'                     => array( 'additional image link', true ),
		'images_4'                     => array( 'additional image link', true ),
		'images_5'                     => array( 'additional image link', true ),
		'images_6'                     => array( 'additional image link', true ),
		'images_7'                     => array( 'additional image link', true ),
		'images_8'                     => array( 'additional image link', true ),
		'images_9'                     => array( 'additional image link', true ),
		'images_10'                    => array( 'additional image link', true ),
		'condition'                    => array( 'condition', false ),
		'availability'                 => array( 'availability', false ),
		'inventory'                    => array( 'inventory', false ),
		'override'                     => array( 'override', false ),
		'price'                        => array( 'price', true ),
		'sale_price'                   => array( 'sale price', true ),
		'sale_price_effective_date'    => array( 'sale price effective date', true ),
		'brand'                        => array( 'brand', true ),
		'sku'                          => array( 'mpn', true ),
		'upc'                          => array( 'gtin', true ),
		'identifier_exists'            => array( 'identifier exists', true ),
		'item_group_id'                => array( 'item group id', false ),
		'color'                        => array( 'color', true ),
		'gender'                       => array( 'gender', true ),
		'age_group'                    => array( 'age group', true ),
		'material'                     => array( 'material', true ),
		'pattern'                      => array( 'pattern', true ),
		'size'                         => array( 'size', true ),
		'size_type'                    => array( 'size type', true ),
		'size_system'                  => array( 'size system', true ),
		'tax'                          => array( 'tax', true ),
		'weight'                       => array( 'shipping weight', false ),
		'length'                       => array( 'shipping length', false ),
		'width'                        => array( 'shipping width', false ),
		'height'                       => array( 'shipping height', false ),
		'ships_from_country'           => array( 'ships from country', false ),
		'shipping_label'               => array( 'shipping label', false ),
		'shipping_country'             => array( 'shipping country', false ),
		'shipping_service'             => array( 'shipping service', false ),
		'shipping_price'               => array( 'shipping price', false ),
		'shipping_region'              => array( 'shipping region', false ),
		'multipack'                    => array( 'multipack', true ),
		'is_bundle'                    => array( 'is bundle', true ),
		'adult'                        => array( 'adult', true ),
		'adwords_redirect'             => array( 'adwords redirect', true ),
		'custom_label_0'               => array( 'custom label 0', true ),
		'custom_label_1'               => array( 'custom label 1', true ),
		'custom_label_2'               => array( 'custom label 2', true ),
		'custom_label_3'               => array( 'custom label 3', true ),
		'custom_label_4'               => array( 'custom label 4', true ),
		'excluded_destination'         => array( 'excluded destination', true ),
		'expiration_date'              => array( 'expiration date', true ),
		'unit_pricing_measure'         => array( 'unit pricing measure', true ),
		'unit_pricing_base_measure'    => array( 'unit pricing base measure', true ),
		'energy_efficiency_class'      => array( 'energy efficiency class', true ),
		'loyalty_points'               => array( 'loyalty points', true ),
		'installment'                  => array( 'installment', true ),
		'promotion_id'                 => array( 'promotion id', true ),
		'cost_of_goods_sold'           => array( 'cost of goods sold', true ),
		'availability_date'            => array( 'availability date', true ),
		'tax_category'                 => array( 'tax category', true ),
		'included_destination'         => array( 'included destination', true ),
		'quantity_to_sell_on_facebook' => array( 'quantity_to_sell_on_facebook', true ),
	);
	public $pinterestXMLAttribute
    = array(
		'id'                        => array( 'g:id', false ),
		'title'                     => array( 'title', true ),
		'description'               => array( 'description', true ),
		'link'                      => array( 'link', true ),
		'mobile_link'               => array( 'mobile_link', true ),
		'product_type'              => array( 'g:product_type', true ),
		'current_category'          => array( 'g:google_product_category', true ),
		'image'                     => array( 'g:image_link', true ),
		'images'                    => array( 'g:additional_image_link', false ),
		'images_1'                  => array( 'g:additional_image_link', true ),
		'images_2'                  => array( 'g:additional_image_link', true ),
		'images_3'                  => array( 'g:additional_image_link', true ),
		'images_4'                  => array( 'g:additional_image_link', true ),
		'images_5'                  => array( 'g:additional_image_link', true ),
		'images_6'                  => array( 'g:additional_image_link', true ),
		'images_7'                  => array( 'g:additional_image_link', true ),
		'images_8'                  => array( 'g:additional_image_link', true ),
		'images_9'                  => array( 'g:additional_image_link', true ),
		'images_10'                 => array( 'g:additional_image_link', true ),
		'condition'                 => array( 'g:condition', false ),
		'availability'              => array( 'g:availability', false ),
		'availability_date'         => array( 'g:availability_date', false ),
		'inventory'                 => array( 'g:inventory', false ),
		'price'                     => array( 'g:price', true ),
		'sale_price'                => array( 'g:sale_price', true ),
		'sale_price_effective_date' => array( 'g:sale_price_effective_date', true ),
		'brand'                     => array( 'g:brand', true ),
		'sku'                       => array( 'g:mpn', true ),
		'upc'                       => array( 'g:gtin', true ),
		'identifier_exists'         => array( 'g:identifier_exists', true ),
		'item_group_id'             => array( 'g:item_group_id', false ),
		'color'                     => array( 'g:color', true ),
		'gender'                    => array( 'g:gender', true ),
		'age_group'                 => array( 'g:age_group', true ),
		'material'                  => array( 'g:material', true ),
		'pattern'                   => array( 'g:pattern', true ),
		'size'                      => array( 'g:size', true ),
		'size_type'                 => array( 'g:size_type', true ),
		'size_system'               => array( 'g:size_system', true ),
		'tax'                       => array( 'tax', true ),
		'tax_country'               => array( 'g:tax_country', true ),
		'tax_region'                => array( 'g:tax_region', true ),
		'tax_rate'                  => array( 'g:tax_rate', true ),
		'tax_ship'                  => array( 'g:tax_ship', true ),
		'tax_category'              => array( 'g:tax_category', true ),
		'free_shipping_label'       => array( 'g:free_shipping_label', true ),
		'free_shipping_limit'       => array( 'g:free_shipping_limit', true ),
		'average_review_rating'     => array( 'g:average_review_rating', true ),
		'number_of_ratings'         => array( 'g:number_of_ratings', true ),
		'number_of_reviews'         => array( 'g:number_of_reviews', true ),
		'weight'                    => array( 'g:shipping_weight', false ),
		'length'                    => array( 'g:shipping_length', false ),
		'width'                     => array( 'g:shipping_width', false ),
		'height'                    => array( 'g:shipping_height', false ),
		'ships_from_country'        => array( 'g:ships_from_country', false ),
		'shipping_label'            => array( 'g:shipping_label', false ),
		'shipping_country'          => array( 'g:shipping_country', false ),
		'shipping_service'          => array( 'g:shipping_service', false ),
		'shipping_price'            => array( 'g:shipping_price', false ),
		'shipping_region'           => array( 'g:shipping_region', false ),
		'multipack'                 => array( 'g:multipack', true ),
		'is_bundle'                 => array( 'g:is_bundle', true ),
		'adult'                     => array( 'g:adult', true ),
		'adwords_redirect'          => array( 'g:adwords_redirect', true ),
		'custom_label_0'            => array( 'g:custom_label_0', true ),
		'custom_label_1'            => array( 'g:custom_label_1', true ),
		'custom_label_2'            => array( 'g:custom_label_2', true ),
		'custom_label_3'            => array( 'g:custom_label_3', true ),
		'custom_label_4'            => array( 'g:custom_label_4', true ),
		'excluded_destination'      => array( 'g:excluded_destination', true ),
		'included_destination'      => array( 'g:included_destination', true ),
		'expiration_date'           => array( 'g:expiration_date', true ),
		'unit_pricing_measure'      => array( 'g:unit_pricing_measure', true ),
		'unit_pricing_base_measure' => array( 'g:unit_pricing_base_measure', true ),
		'energy_efficiency_class'   => array( 'g:energy_efficiency_class', true ),
		'loyalty_points'            => array( 'g:loyalty_points', true ),
		'installment'               => array( 'g:installment', true ),
		'promotion_id'              => array( 'g:promotion_id', true ),
		'cost_of_goods_sold'        => array( 'g:cost_of_goods_sold', true ),
	);
	public $pinterestCSVTXTAttribute
		= array(
			'id'                        => array( 'id', false ),
			'title'                     => array( 'title', true ),
			'description'               => array( 'description', true ),
			'link'                      => array( 'link', true ),
			'mobile_link'               => array( 'mobile_link', true ),
			'product_type'              => array( 'product_type', true ),
			'current_category'          => array( 'google_product_category', true ),
			'image'                     => array( 'image_link', true ),
			'images'                    => array( 'additional_image_link', true ),
			'images_1'                  => array( 'additional_image_link', true ),
			'images_2'                  => array( 'additional_image_link', true ),
			'images_3'                  => array( 'additional_image_link', true ),
			'images_4'                  => array( 'additional_image_link', true ),
			'images_5'                  => array( 'additional_image_link', true ),
			'images_6'                  => array( 'additional_image_link', true ),
			'images_7'                  => array( 'additional_image_link', true ),
			'images_8'                  => array( 'additional_image_link', true ),
			'images_9'                  => array( 'additional_image_link', true ),
			'images_10'                 => array( 'additional_image_link', true ),
			'condition'                 => array( 'condition', false ),
			'availability'              => array( 'availability', false ),
			'availability_date'         => array( 'availability_date', false ),
			'inventory'                 => array( 'inventory', false ),
			'price'                     => array( 'price', true ),
			'sale_price'                => array( 'sale_price', true ),
			'sale_price_effective_date' => array( 'sale_price_effective_date', true ),
			'brand'                     => array( 'brand', true ),
			'sku'                       => array( 'mpn', true ),
			'upc'                       => array( 'gtin', true ),
			'identifier_exists'         => array( 'identifier_exists', true ),
			'item_group_id'             => array( 'item_group_id', false ),
			'color'                     => array( 'color', true ),
			'gender'                    => array( 'gender', true ),
			'age_group'                 => array( 'age_group', true ),
			'material'                  => array( 'material', true ),
			'pattern'                   => array( 'pattern', true ),
			'size'                      => array( 'size', true ),
			'size_type'                 => array( 'size_type', true ),
			'size_system'               => array( 'size_system', true ),
			'tax'                       => array( 'tax', true ),
			'tax_country'               => array( 'tax_country', true ),
			'tax_region'                => array( 'tax_region', true ),
			'tax_rate'                  => array( 'tax_rate', true ),
			'tax_ship'                  => array( 'tax_ship', true ),
			'tax_category'              => array( 'tax_category', true ),
			'free_shipping_label'       => array( 'free_shipping_label', true ),
			'free_shipping_limit'       => array( 'free_shipping_limit', true ),
			'average_review_rating'     => array( 'average_review_rating', true ),
			'number_of_ratings'         => array( 'number_of_ratings', true ),
			'number_of_reviews'         => array( 'number_of_reviews', true ),
			'weight'                    => array( 'shipping_weight', false ),
			'length'                    => array( 'shipping_length', false ),
			'width'                     => array( 'shipping_width', false ),
			'height'                    => array( 'shipping_height', false ),
			'ships_from_country'        => array( 'ships_from_country', false ),
			'shipping_label'            => array( 'shipping_label', false ),
			'shipping_country'          => array( 'shipping_country', false ),
			'shipping_service'          => array( 'shipping_service', false ),
			'shipping_price'            => array( 'shipping_price', false ),
			'shipping_region'           => array( 'shipping_region', false ),
			'multipack'                 => array( 'multipack', true ),
			'is_bundle'                 => array( 'is_bundle', true ),
			'adult'                     => array( 'adult', true ),
			'adwords_redirect'          => array( 'adwords_redirect', true ),
			'custom_label_0'            => array( 'custom_label_0', true ),
			'custom_label_1'            => array( 'custom_label_1', true ),
			'custom_label_2'            => array( 'custom_label_2', true ),
			'custom_label_3'            => array( 'custom_label_3', true ),
			'custom_label_4'            => array( 'custom_label_4', true ),
			'excluded_destination'      => array( 'excluded_destination', true ),
			'included_destination'      => array( 'included_destination', true ),
			'expiration_date'           => array( 'expiration_date', true ),
			'unit_pricing_measure'      => array( 'unit_pricing_measure', true ),
			'unit_pricing_base_measure' => array( 'unit_pricing_base_measure', true ),
			'energy_efficiency_class'   => array( 'energy_efficiency_class', true ),
			'loyalty_points'            => array( 'loyalty_points', true ),
			'installment'               => array( 'installment', true ),
			'promotion_id'              => array( 'promotion_id', true ),
			'cost_of_goods_sold'        => array( 'cost_of_goods_sold', true ),
		);
	public $skroutzXMLAttributes
     = array(
		 'id'                     => array( 'id', false ),
		 'name'                   => array( 'name', true ),
		 'description'            => array( 'description', true ),
		 'link'                   => array( 'link', true ),
		 'image'                  => array( 'image', true ),
		 'additional_imageurl'    => array( 'additional_imageurl', false ),
		 'additional_imageurl_1'  => array( 'additional_imageurl', true ),
		 'additional_imageurl_2'  => array( 'additional_imageurl', true ),
		 'additional_imageurl_3'  => array( 'additional_imageurl', true ),
		 'additional_imageurl_4'  => array( 'additional_imageurl', true ),
		 'additional_imageurl_5'  => array( 'additional_imageurl', true ),
		 'additional_imageurl_6'  => array( 'additional_imageurl', true ),
		 'additional_imageurl_7'  => array( 'additional_imageurl', true ),
		 'additional_imageurl_8'  => array( 'additional_imageurl', true ),
		 'additional_imageurl_9'  => array( 'additional_imageurl', true ),
		 'additional_imageurl_10' => array( 'additional_imageurl', true ),
		 'category'               => array( 'category', true ),
		 'price'                  => array( 'price', false ),
		 'price_with_vat'         => array( 'price_with_vat', false ),
		 'manufacturer'           => array( 'manufacturer', true ),
		 'mpn'                    => array( 'mpn', false ),
		 'ean'                    => array( 'ean', false ),
		 'instock'                => array( 'instock', false ),
		 'availability'           => array( 'availability', false ),
		 'color'                  => array( 'color', false ),
		 'size'                   => array( 'size', false ),
		 'weight'                 => array( 'weight', false ),
		 'quantity'               => array( 'quantity', false ),
	 );

	public $gLocalAttributes
		= array(
			'description' => array( 'description', true ),
		);

	public $gActionAttributes
		= array(
			'description' => array( 'description', true ),
		);


	/**
	 * Google Attribute List
	 *
	 * @return array
	 */
	public function googleAttributes() {
		return array(
			'--1'                                 => 'Basic Information',
			'id'                                  => 'Product Id[id]',
			'webitemid'                           => 'Product WebItemId[webitemid]',
			'region_id'                           => 'Region Id[region_id]',
			'title'                               => 'Product Title[title]',
			'description'                         => 'Product Description[description]',
			'link'                                => 'Product URL[link]',
			'canonical_link'                      => 'Canonical Link[canonical_link]',
			'mobile_link'                         => 'Product URL[mobile_link]',
			'product_type'                        => 'Product Categories[product_type] ',
			'current_category'                    => 'Google Product Category[google_product_category]',
			'image'                               => 'Main Image[image_link]',
			'images'                              => 'Additional Images [additional_image_link]',
			'images_1'                            => 'Additional Image 1 [additional_image_link]',
			'images_2'                            => 'Additional Image 2 [additional_image_link]',
			'images_3'                            => 'Additional Image 3 [additional_image_link]',
			'images_4'                            => 'Additional Image 4 [additional_image_link]',
			'images_5'                            => 'Additional Image 5 [additional_image_link]',
			'images_6'                            => 'Additional Image 6 [additional_image_link]',
			'images_7'                            => 'Additional Image 7 [additional_image_link]',
			'images_8'                            => 'Additional Image 8 [additional_image_link]',
			'images_9'                            => 'Additional Image 9 [additional_image_link]',
			'images_10'                           => 'Additional Image 10 [additional_image_link]',
			'condition'                           => 'Condition[condition]',
			'---1'                                => '',
			'--2'                                 => 'Availability & Price',
			'availability'                        => 'Stock Status[availability]',
			'availability_date'                   => 'Availability Date[availability_date]',
			'inventory'                           => 'Facebook Inventory[inventory]',
			'override'                            => 'Facebook Override[override]',
			'price'                               => 'Regular Price[price]',
			'sale_price'                          => 'Sale Price[sale_price]',
			'cost_of_goods_sold'                  => 'Cost of Goods Sold[cost_of_goods_sold]',
			'sale_price_effective_date'           => 'Sale Price Effective Date[sale_price_effective_date]',
			'---2'                                => '',
			'--3'                                 => 'Unique Product Identifiers',
			'brand'                               => 'Manufacturer[brand]',
			'upc'                                 => 'GTIN[gtin]',
			'sku'                                 => 'MPN[mpn]',
			'identifier_exists'                   => 'Identifier Exist[identifier_exists]',
			'---3'                                => '',
			'--4'                                 => 'Detailed Product Attributes',
			'item_group_id'                       => 'Item Group Id[item_group_id]',
			'external_seller_id'                  => 'External seller ID[external_seller_id]',
			'color'                               => 'Color[color]',
			'gender'                              => 'Gender[gender]',
			'age_group'                           => 'Age Group[age_group]',
			'material'                            => 'Material[material]',
			'pattern'                             => 'Pattern[pattern]',
			'size'                                => 'Size of the item[size]',
			'size_type'                           => 'Size Type[size_type]',
			'size_system'                         => 'Size System[size_system]',
			'product_length'                      => 'Product Length[product_length]',
			'product_width'                       => 'Product Width[product_width]',
			'product_height'                      => 'Product Height[product_height]',
			'product_weight'                      => 'Product Weight[product_weight]',
			'product_highlight_1'                 => 'Product Highlight 1[product_highlight]',
			'product_highlight_2'                 => 'Product Highlight 2[product_highlight]',
			'product_highlight_3'                 => 'Product Highlight 3[product_highlight]',
			'product_highlight_4'                 => 'Product Highlight 4[product_highlight]',
			'product_highlight_5'                 => 'Product Highlight 5[product_highlight]',
			'product_highlight_6'                 => 'Product Highlight 6[product_highlight]',
			'product_highlight_7'                 => 'Product Highlight 7[product_highlight]',
			'product_highlight_8'                 => 'Product Highlight 8[product_highlight]',
			'product_highlight_9'                 => 'Product Highlight 9[product_highlight]',
			'product_highlight_10'                => 'Product Highlight 10[product_highlight]',
			'section_name'                        => 'Section Name (Product Detail)[section_name]',
			'attribute_name'                      => 'Attribute Name  (Product Detail)[attribute_name]',
			'attribute_value'                     => 'Attribute Value  (Product Detail)[attribute_value]',
			'---4'                                => '',
			'--5'                                 => 'Tax & Shipping',
			'tax'                                 => 'Tax[tax]',
			'tax_country'                         => 'Tax Country[tax_country]',
			'tax_region'                          => 'Tax Region[tax_region]',
			'tax_rate'                            => 'Tax Rate[tax_rate]',
			'tax_ship'                            => 'Tax Ship[tax_ship]',
			'tax_category'                        => 'Tax[tax_category]',
			'shipping'                            => 'Shipping',
			'min_handling_time'                   => 'Min Handling Time[min_handling_time]',
			'max_handling_time'                   => 'Max Handling Time[max_handling_time]',
			'min_transit_time'                    => 'Min Transit Time[min_transit_time]',
			'max_transit_time'                    => 'Max Transit Time[max_transit_time]',
			'weight'                              => 'Shipping Weight[shipping_weight]',
			'length'                              => 'Shipping Length[shipping_length]',
			'width'                               => 'Shipping Width[shipping_width]',
			'height'                              => 'Shipping Height[shipping_height]',
			'ships_from_country'                  => 'Shipping Country[ships_from_country]',
			'shipping_label'                      => 'Shipping Label[shipping_label]',
			'material_1'                          => 'The primary material',
			'material_2'                          => 'The secondary material',
			'material_3'                          => 'The tertiary material',
			'---5'                                => '',
			'--6'                                 => 'Product Combinations',
			'multipack'                           => 'Multipack[multipack]',
			'is_bundle'                           => 'Is Bundle[is_bundle]',
			'---6'                                => '',
			'--7'                                 => 'Adult Products',
			'adult'                               => 'Adult[adult]',
			'---7'                                => '',
			'--8'                                 => 'Ads Attributes',
			'ads_redirect'                        => 'Ads Redirect[ads_redirect]',
			'---8'                                => '',
			'--9'                                 => 'Custom Label Attributes',
			'custom_label_0'                      => 'Custom label 0 [custom_label_0]',
			'custom_label_1'                      => 'Custom label 1 [custom_label_1]',
			'custom_label_2'                      => 'Custom label 2 [custom_label_2]',
			'custom_label_3'                      => 'Custom label 3 [custom_label_3]',
			'custom_label_4'                      => 'Custom label 4 [custom_label_4]',
			'---9'                                => '',
			'--10'                                => 'Additional Attributes',
			'excluded_destination'                => 'Excluded Destination[excluded_destination]',
			'shopping_ads_excluded_country'       => 'Shopping Ads Excluded Country[shopping_ads_excluded_country]',
			'included_destination'                => 'Included Destination[included_destination]',
			'expiration_date'                     => 'Expiration Date [expiration_date]',
			'transit_time_label'                  => 'Transit Time [transit_time_label]',
			'---10'                               => '',
			'--11'                                => 'Unit Prices (EU Countries and Switzerland Only)',
			'unit_pricing_measure'                => 'Unit Pricing Measure[unit_pricing_measure]',
			'unit_pricing_base_measure'           => 'Unit Pricing Base Measure[unit_pricing_base_measure]',
			'installment_months'                  => 'Installment Months[months]',
			'installment_amount'                  => 'Installment Amount[amount]',
			'subscription_period'                 => 'Subscription Period[period]',
			'subscription_period_length'          => 'Subscription Period Length[period_length]',
			'subscription_amount'                 => 'Subscription Amount[amount]',
			'---11'                               => '',
			'--12'                                => 'Energy Labels',
			'energy_efficiency_class'             => 'Energy Efficiency Class[energy_efficiency_class]',
			'min_energy_efficiency_class'         => 'Min Energy Efficiency Class[energy_efficiency_class]',
			'max_energy_efficiency_class'         => 'Max Energy Efficiency Class[energy_efficiency_class]',
			'---12'                               => '',
			'--13'                                => 'Loyalty Points (Japan Only)',
			'loyalty_points'                      => 'loyalty_points[loyalty_points]',
			'---13'                               => '',
			'--14'                                => 'Multiple Installments (Brazil Only)',
			'installment'                         => 'Installment[installment]',
			'---14'                               => '',
			'--15'                                => 'Pinterest Catalog Attributes',
			'free_shipping_label'                 => 'Free Shipping Label[free_shipping_label]',
			'free_shipping_limit'                 => 'Free Shipping Limit[free_shipping_limit]',
			'average_review_rating'               => 'Average Review Rating[average_review_rating]',
			'number_of_ratings'                   => 'Number of Ratings[number_of_ratings]',
			'number_of_reviews'                   => 'Number of Reviews[number_of_reviews]',
			'---15'                               => '',
			'--16'                                => 'Merchant Promotions Attributes',
			'promotion_id'                        => 'Promotion Id[promotion_id]',
			'product_applicability'               => 'Product Applicability[product_applicability]',
			'offer_type'                          => 'Offer Type[offer_type]',
			'long_title'                          => 'Long Title[long_title]',
			'promotion_effective_dates'           => 'Promotion Effective Dates[promotion_effective_dates]',
			'redemption_channel'                  => 'Redemption Channel[redemption_channel]',
			'promotion_destination'               => 'Promotion Destination[promotion_destination]',
			'percent_off'                         => 'Percent Off[percent_off]',
			'money_off_amount'                    => 'Money Off Amount[money_off_amount]',
			'get_this_quantity_discounted'        => 'Get Quantity Discounted[get_this_quantity_discounted]',
			'free_shipping'                       => 'Free Shipping[free_shipping]',
			'free_gift_value'                     => 'Free Gift Value[free_gift_value]',
			'free_gift_description'               => 'Free Gift Description[free_gift_description]',
			'free_gift_item_id'                   => 'Free Gift Item ID[free_gift_item_id]',
			'promotion_display_dates'             => 'Promotion Display Dates[promotion_display_dates]',
			'generic_redemption_code'             => 'Generic Redemption Code[generic_redemption_code]',
			'fine_print'                          => 'Fine Print[fine_print]',
			'promotion_price'                     => 'Promotion Price[promotion_price]',
			'coupon_value_type'                   => 'Coupon Value Type[coupon_value_type]',
			'limit_quantity'                      => 'Limit Quantity[limit_quantity]',
			'limit_value'                         => 'Limit Value[limit_value]',
			'minimum_purchase_amount'             => 'Minimum Purchase Amount[minimum_purchase_amount]',
			'item_id_exclusion'                   => 'Item ID Exclusion[item_id_exclusion]',
			'product_type_exclusion'              => 'Product Type Exclusion[product_type_exclusion]',
			'brand_exclusion'                     => 'Brand Exclusion[brand_exclusion]',
			'item_group_id_exclusion'             => 'Item Group Exclusion[item_group_id_exclusion]',
			'---16'                               => '',
			'--17'                                => 'Shopping Action Attributes',
			'sell_on_google_quantity'             => 'Number of Product Sold On Google [sell_on_google_quantity]',
			'return_address_label'                => 'Return Address [return_address_label]',
			'return_policy_label'                 => 'Return Policy [return_policy_label]',
			'google_funded_promotion_eligibility' => 'Google Funded Promotion Eligibility [google_funded_promotion_eligibility]',
			'---17'                               => '',
			'--18'                                => 'Local Inventory / Product Inventory',
			'store_code'                          => 'Store Code [store_code]',
			'quantity'                            => 'Quantity [quantity]',
			'pickup_method'                       => 'Pickup Method [pickup_method]',
			'pickup_sla'                          => 'Pickup SLA [pickup_sla]',
			'pickup_link_template'                => 'Pickup Link Template [pickup_link_template]',
			'link_template'                       => 'Link Template [link_template]',
			'mobile_link_template'                => 'Mobile Link Template [mobile_link_template]',
			'mobile_pickup_link_template'         => 'Mobile Pickup Link Template [mobile_pickup_link_template]',
			'---18'                               => '',
		);
	}

	/**
	 * Facebook Attribute List
	 *
	 * @return array
	 */
	public function facebookAttributes() {
		return array(
			'--1'                          => 'Basic Information',
			'id'                           => 'Product Id[id]',
			'title'                        => 'Product Title[title]',
			'description'                  => 'Product Description[description]',
			'link'                         => 'Product URL[link]',
			'mobile_link'                  => 'Product URL[mobile_link]',
			'product_type'                 => 'Product Categories[product_type] ',
			'fb_product_category'          => 'Facebook Product Category[fb_product_category]',
			'current_category'             => 'Google Product Category[google_product_category]',
			'image'                        => 'Main Image[image_link]',
			'images'                       => 'Additional Images [additional_image_link]',
			'images_1'                     => 'Additional Image 1 [additional_image_link]',
			'images_2'                     => 'Additional Image 2 [additional_image_link]',
			'images_3'                     => 'Additional Image 3 [additional_image_link]',
			'images_4'                     => 'Additional Image 4 [additional_image_link]',
			'images_5'                     => 'Additional Image 5 [additional_image_link]',
			'images_6'                     => 'Additional Image 6 [additional_image_link]',
			'images_7'                     => 'Additional Image 7 [additional_image_link]',
			'images_8'                     => 'Additional Image 8 [additional_image_link]',
			'images_9'                     => 'Additional Image 9 [additional_image_link]',
			'images_10'                    => 'Additional Image 10 [additional_image_link]',
			'condition'                    => 'Condition[condition]',
			'---1'                         => '',
			'--2'                          => 'Availability & Price',
			'availability'                 => 'Stock Status[availability]',
			'availability_date'            => 'Availability Date[availability_date]',
			'price'                        => 'Regular Price[price]',
			'sale_price'                   => 'Sale Price[sale_price]',
			'sale_price_effective_date'    => 'Sale Price Effective Date[sale_price_effective_date]',
			'---2'                         => '',
			'--3'                          => 'Unique Product Identifiers',
			'brand'                        => 'Manufacturer[brand]',
			'gtin'                         => 'GTIN[gtin]',
			'mpn'                          => 'MPN[mpn]',
			'identifier_exists'            => 'Identifier Exist[identifier_exists]',
			'---3'                         => '',
			'--4'                          => 'Detailed Product Attributes',
			'item_group_id'                => 'Item Group Id[item_group_id]',
			'color'                        => 'Color[color]',
			'gender'                       => 'Gender[gender]',
			'age_group'                    => 'Age Group[age_group]',
			'material'                     => 'Material[material]',
			'pattern'                      => 'Pattern[pattern]',
			'size'                         => 'Size of the item[size]',
			'---4'                         => '',
			'--5'                          => 'Tax & Shipping',
			'tax'                          => 'Tax[tax]',
			'tax_country'                  => 'Tax Country[tax_country]',
			'tax_region'                   => 'Tax Region[tax_region]',
			'tax_rate'                     => 'Tax Rate[tax_rate]',
			'tax_ship'                     => 'Tax Ship[tax_ship]',
			'tax_category'                 => 'Tax[tax_category]',
			'shipping'                     => 'Shipping',
			'shipping_weight'              => 'Shipping Weight[shipping_weight]',
			'---5'                         => '',
			'--6'                          => 'Custom Label Attributes',
			'custom_label_0'               => 'Custom label 0 [custom_label_0]',
			'custom_label_1'               => 'Custom label 1 [custom_label_1]',
			'custom_label_2'               => 'Custom label 2 [custom_label_2]',
			'custom_label_3'               => 'Custom label 3 [custom_label_3]',
			'custom_label_4'               => 'Custom label 4 [custom_label_4]',
			'---6'                         => '',
			'--7'                          => 'Additional Attributes',
			'inventory'                    => 'Facebook Inventory[inventory]',
			'override'                     => 'Facebook Override[override]',
			'status'                       => 'Status [status]',
			'video'                        => 'Video [video]',
			'unit_price_value'             => 'Unit Price > Value [unit_price_value]',
			'unit_price_currency'          => 'Unit Price > Currency [unit_price_currency]',
			'unit_price_unit'              => 'Unit Price > Unit [unit_price_unit]',
			'quantity_to_sell_on_facebook' => 'Quantity to Sell on Facebook [quantity_to_sell_on_facebook]',
			'commerce_tax_category'        => 'Commerce Tax Category [commerce_tax_category]',
			'expiration_date'              => 'Expiration Date[expiration_date]',
			'marked_for_product_launch'    => 'Marked for Product Launce [marked_for_product_launch]',
			'rich_text_description'        => 'Rich Text Description [rich_text_description]',
			'visibility'                   => 'Visibility [visibility]',
			'additional_variant_label'     => 'Additional Variant Attribute > Label [Variant Label]',
			'additional_variant_value'     => 'Additional Variant Attribute > Value [Variant Value]',
			'applink'                      => 'Applink [applink]',
			'origin_country'               => 'Origin Country [origin_country]',
			'importer_name'                => 'Importer Name [importer_name]',
			'importer_address'             => 'Importer Address [importer_address]',
			'manufacturer_info'            => 'Manufacturer Info [manufacturer_info]',
			'return_policy_info'           => 'Return Policy Info [return_policy_info]',
			'---7'                         => '',
		);
	}

	/**
	 * Google Dynamic Ads Attribute List
	 *
	 * @return array
	 */
	public function google_dynamic_adsAttributes() {

		return array(
			'--1'          => 'Basic Information',
			'Page URL'     => 'Page URL[Page URL]',
			'Custom Label' => 'Custom Label [Custom Label]',
			'---1'         => '',

		);
	}

	/**
	 * Bing Attribute List
	 *
	 * @return array
	 */
	public function bingAttributes() {

		return array(
			'--1'                         => 'Basic Information',
			'id'                          => 'Product Id[id]',
			'title'                       => 'Product Title[title]',
			'link'                        => 'Product URL[link]',
			'price'                       => 'Product Price[price]',
			'description'                 => 'Product Description[description]',
			'image_link'                  => 'Image[image_link]',
			'shipping'                    => 'Shipping [shipping]',
			'shipping_country'            => 'Shipping Country[shipping]',
			'shipping_service'            => 'Shipping Service[shipping]',
			'shipping_price'              => 'Shipping Price[shipping]',
			'gtin'                        => 'GTIN[gtin]',
			'mpn'                         => 'MPN[mpn]',
			'brand'                       => 'Brand[brand]',
			'identifier_exists'           => 'Identifier Exists[identifier_exists]',
			'---1'                        => '',
			'--2'                         => 'Apparel Products',
			'gender'                      => 'Gender[gender]',
			'age_group'                   => 'Age Group[age_group]',
			'color'                       => 'Color[color]',
			'size'                        => 'Size[size]',
			'size_type'                   => 'Size Type[size_type]',
			'size_system'                 => 'Size System[size_system]',
			'---2'                        => '',
			'--3'                         => 'Product Variants',
			'item_group_id'               => 'Item Group ID[item_group_id]',
			'material'                    => 'Material[material]',
			'pattern'                     => 'Pattern[pattern]',
			'additional_image_link'       => 'Additional Image Link[additional_image_link]',
			'---3'                        => '',
			'--4'                         => 'Other Information',
			'adult'                       => 'Adult[adult]',
			'availability'                => 'Availability[availability]',
			'product_category'            => 'Product Category[product_category]',
			'condition'                   => 'Condition[condition]',
			'expiration_date'             => 'Expiration Date[expiration_date]',
			'multipack'                   => 'Multipack[multipack]',
			'product_type'                => 'Product Type[product_type]',
			'mobile_link'                 => 'Mobile Link[mobile_link]',
			'unit_pricing_measure'        => 'Unit Pricing Measure[unit_pricing_measure]',
			'unit_pricing_base_measure'   => 'Unit Pricing Base Measure[unit_pricing_base_measure]',
			'installment'                 => 'Installment[installment]',
			'energy_efficiency_class'     => 'Energy Efficiency Class[energy_efficiency_class]',
			'min_energy_efficiency_class' => 'Min Energy Efficiency Class[min_energy_efficiency_class]',
			'max_energy_efficiency_class' => 'Max Energy Efficiency Class[max_energy_efficiency_class]',
			'seller_name'                 => 'Seller Name[seller_name]',
			'ads_redirect'                => 'Ads Redirect[ads_redirect]',
			'custom_label_0'              => 'Custom Label 0[custom_label_0]',
			'custom_label_1'              => 'Custom Label 1[custom_label_1]',
			'custom_label_2'              => 'Custom Label 2[custom_label_2]',
			'custom_label_3'              => 'Custom Label 3[custom_label_3]',
			'custom_label_4'              => 'Custom Label 4[custom_label_4]',
			'---4'                        => '',
			'--5'                         => 'Sales & Promotions',
			'sale_price'                  => 'Sale Price[sale_price]',
			'sale_price_effective_date'   => 'Sale Price Effective Date[sale_price_effective_date]',
			'promotion_ID'                => 'Promotion ID[promotion_ID]',
			'---5'                        => '',
			'--6'                         => 'Local Product Inventory',
			'store_code'                  => 'Store Code[store_code]',
			'itemid'                      => 'Item ID[itemid]',
			'quantity'                    => 'Quantity[quantity]',
			'weeks_of_supply'             => 'Weeks Of Supply[weeks_of_supply]',
			'pick_up_method'              => 'Pick Up Method[pick_up_method]',
			'pick_up_sla'                 => 'Pick Up SLA[pick_up_sla]',
			'---6'                        => '',
		);
	}

	/**
	 * Pinterest RSS Board Attribute List
	 *
	 * @return array
	 */
	public function pinterest_rssAttributes() {

		return array(
			'--1'         => 'Basic Information',
			'title'       => 'Product Title[title]',
			'description' => 'Product Description[description]',
			'link'        => 'Product URL[link]',
			'image'       => 'Main Image[image]',
			'pubDate'     => 'Publish Date[pubDate]',
			'guid'        => 'GUID[guid]',
			'---1'        => '',

		);
	}

	/**
	 * Google Product Review Attribute List
	 *
	 * @return array
	 */
	public function googlereviewAttributes() {
		return array(
			'product_name'      => 'Product Title [product_name]',
			'product_url'       => 'Product URL [product_url]',
			'review_temp_gtin'  => 'GTIN [gtin]',
			'review_temp_mpn'   => 'MPN [mpn]',
			'review_temp_sku'   => 'SKU [sku]',
			'review_temp_brand' => 'Brand [brand]',
		);
	}

	/**
	 * Wine Searcher Attribute List
	 *
	 * @return array
	 */
	public function winesearcherAttributes() {
		return array(
			'--1'           => 'Basic Information',
			'name'          => 'Product Title[name]',
			'description'   => 'Product description[description]',
			'vintage'       => 'Vintage[vintage]',
			'link'          => 'Product URL[link]',
			'unit-size'     => 'Unit Size[unit-size]',
			'price'         => 'Price[price]',
			'url'           => 'URL[url] ',
			'min-order'     => 'Minimum Order[min-order]',
			'tax'           => 'Tax[tax]',
			'offer-type'    => 'Offer Type[offer-type]',
			'delivery-time' => 'Delivery Time[delivery-time]',
			'stock-level'   => 'Stock Level[stock-level]',
		);
	}

	/**
	 * TikTok Attribute List
	 *
	 * @since 4.4.31
	 * @author Nazrul Islam Nayan
	 * @return array
	 */
	public function tiktokAttributes() {
		return array(
			'--1'                       => 'Basic Information',
			'sku_id'                    => 'SKU ID[id]',
			'title'                     => 'Product Title[title]',
			'description'               => 'Product description[description]',
			'availability'              => 'Availability[availability]',
			'condition'                 => 'Condition[condition]',
			'price'                     => 'Price[price]',
			'sale_price'                => 'Sale Price[sale_price]',
			'shipping'                  => 'Shipping[shipping]',
			'tax '                      => 'Tax[tax]',
			'shipping_weight'           => 'Shipping Weight[shipping_weight]',
			'link'                      => 'Product URL[link]',
			'image_link'                => 'Product Image[image_link]',
			'additional_image_link'     => 'Additional Image [additional_image_link]',
			'item_group_id'             => 'Parent ID[item_group_id]',
			'brand'                     => 'Product Brand[brand]',
			'gtin'                      => 'Gtin[gtin]',
			'mpn'                       => 'MPN[mpn]',
			'google_product_category'   => 'Google Product Category[google_product_category]',
			'video_link'                => 'Video Link[video_link]',
			'age_group'                 => 'Age Group[age_group]',
			'color'                     => 'Color[color]',
			'size'                      => 'Size[size]',
			'gender'                    => 'Gender[gender]',
			'material'                  => 'Material[material]',
			'pattern'                   => 'Pattern[pattern]',
			'product_type'              => 'Product Type[product_type]',
			'ios_url'                   => 'IOS URL[ios_url]',
			'ios_app_store_id'          => 'IOS App Store ID[ios_app_store_id]',
			'ios_app_name'              => 'IOS App Name[ios_app_name]',
			'iPhone_url'                => 'iPhone URL[iPhone_url]',
			'iPhone_app_store_id'       => 'iPhone App Store ID[iPhone_app_store_id]',
			'iPhone_app_name'           => 'iPhone App Name[iPhone_app_name]',
			'iPad_url'                  => 'iPad URL[iPad_url]',
			'iPad_app_store_id'         => 'iPad App Store ID[iPad_app_store_id]',
			'iPad_app_name'             => 'iPad App Name[iPad_app_name]',
			'android_url'               => 'Android URL[android_url]',
			'android_package'           => 'Android Package[android_package]',
			'android_app_name'          => 'Android App Name[android_app_name]',
			'custom_label_0'            => 'custom_label_0[custom_label_0]',
			'custom_label_1'            => 'custom_label_1[custom_label_1]',
			'custom_label_2'            => 'custom_label_2[custom_label_2]',
			'custom_label_3'            => 'custom_label_3[custom_label_3]',
			'custom_label_4'            => 'custom_label_4[custom_label_4]',
			'merchant_brand'            => 'Merchant Brand[merchant_brand]',
			'productHisEval'            => 'Purchase Count:FeedBack[productHisEval]',
			'sale_price_effective_date' => 'Sale Price Effective Date[sale_price_effective_date]',
		);
	}

	/**
	 * Modalova Attribute List
	 *
	 * @since 5.2.10
	 * @author Nazrul Islam Nayan
	 * @return array
	 */
	public function modalovaAttributes() {
		return array(
			'--1'               => 'Basic Information',
			'id'                => 'Product ID[id]',
			'title'             => 'Product Title[title]',
			'slug'              => 'Product URL Slug[slug]',
			'description'       => 'Product description[description]',
			'short_description' => 'Product Short description[short_description]',
			'link'              => 'Product URL[link]',
			'sku'               => 'SKU[sku]',
			'brand'             => 'Product Brand[brand]',
			'main_image'        => 'Product Image[main_image]',
			'featured_image'    => 'Featured Image[featured_image]',
			'images'            => 'Images[images]',
			'price'             => 'Price[price]',
			'sale_price'        => 'Sale Price[sale_price]',
			'availability'      => 'Availability[availability]',
			'tags'              => 'Tags[tags]',
			'color'             => 'Color[color]',
			'size'              => 'Size[size]',
			'quantity'          => 'Quantity[quantity]',
			'parent_id'         => 'Parent ID[parent_id]',
			'condition'         => 'Condition[condition]',
			'category'          => 'Category[category]',
			'parent_category'   => 'Parent Category[parent_category]',
			'child_category'    => 'Child Category[child_category]',
			'category_path'     => 'Category Path[category_path]',
			'created_at'        => 'Created At[created_at]',
			'updated_at'        => 'Updated At[updated_at]',
		);
	}

	/**
	 * Catch.com.au Attribute List
	 *
	 * @return array
	 */
	public function catchdotcomAttributes() {
		return array(
			'product-id'          => 'Product ID [product-id]',
			'title'               => 'Product title [title]',
			'product-description' => 'Product Description[product-description]',
			'product-id-type'     => 'Product ID Type[product-id-type]',
			'internal-sku'        => 'Internal SKU[internal-sku]',
			'category'            => 'Product Category[category]',
			'image-1'             => 'Image 1 [image-1]',
			'images-2'            => 'Image 2 [image-2]',
			'images-3'            => 'Image 3 [image-3]',
			'images-4'            => 'Image 4 [image-4]',
			'images-5'            => 'Image 5 [image-5]',
			'images-6'            => 'Image 6 [image-6]',
			'image-size-chart'    => 'Image Size Chart[image-size-chart]',
			'brand'               => 'Brand[brand]',
			'adult'               => 'Adult[adult]',
			'keywords'            => 'Keywords[keywords]',
			'sku'                 => 'Offer SKU[sku]',
			'inventory'           => 'Facebook Inventory[inventory]',
			'override'            => 'Facebook Override[override]',
			'price'               => 'Regular Price[price]',
			'quantity'            => 'Offer Quantity[quantity]',
			'min-quantity-alert'  => 'Minimum Quantity Alert[min-quantity-alert]',
			'state'               => 'Offer State[state]',
			'logistic-class'      => 'Logistic Class[logistic-class]',
			'discount-price'      => 'Discount Price[discount-price]',
			'leadtime-to-ship'    => 'Lead Time to Ship[leadtime-to-ship]',
			'club-catch-eligible' => 'Club Catch eligible[club-catch-eligible]',
			'tax-au'              => 'GST %[tax-au]',
		);
	}

	/**
	 * Fashionchick.nl Attribute List
	 *
	 * @return array
	 */
	public function fashionchickAttributes() {
		return array(
			'Product ID'      => 'Product ID [Product ID]',
			'Titel'           => 'Product Titel [Titel]',
			'Omschrijving'    => 'Product Description [Omschrijving]',
			'Url'             => 'Product URL [Url]',
			'Image'           => 'Image [Image]',
			'Category'        => 'Product Category [Category (pad)]',
			'Prijs'           => 'Regular Price [Prijs]',
			'Merk'            => 'Brand [Merk]',
			'Cluster ID'      => 'Cluster ID [Cluster ID]',
			'internal-sku'    => 'Internal SKU [internal-sku]',
			'sku'             => 'Offer SKU[sku]',
			'Delivery Time'   => 'Delivery Time [Delivery Time]',
			'Shipping Costs'  => 'Shipping Costs [Shipping Costs]',
			'Old price'       => 'Old price [Old price]',
			'Product maten'   => 'Product sizes [Product maten]',
			'Stock'           => 'Stock [Stock]',
			'Voorraad aantal' => 'Stock quantity [Voorraad aantal]',
			'Materiaal'       => 'Material [Materiaal]',
			'Geslacht'        => 'Gender [Geslacht]',
			'Kleur'           => 'Color [Kleur]',
		);
	}

	/**
	 * GoedGeplaatst.nl Attribute List
	 *
	 * @return array
	 */
	public function goedgeplaatstAttributes() {
		return array(
			'title'             => 'Product Title [title]',
			'description'       => 'Product Description [description]',
			'type'              => 'Product Type [type]',
			'price'             => 'Price [price]',
			'images'            => 'Images [images]',
			'categoryId'        => 'Category ID [categoryId]',
			'externalAdId'      => 'External Ad ID [externalAdId]',
			'priceRetail'       => 'Retail Price [priceRetail]',
			'priceOther'        => 'Other Price [priceOther]',
			'bid'               => 'Bid [bid]',
			'showContact'       => 'Show Contact [showContact]',
			'website'           => 'Website [website]',
			'name'              => 'Name [name]',
			'phone'             => 'Phone [phone]',
			'address'           => 'Address [address]',
			'houseNumber'       => 'House Number [houseNumber]',
			'postalCode'        => 'Postal Code [postalCode]',
			'city'              => 'City [city]',
			'country'           => 'Country [country]',
			'autoReplace'       => 'Auto Replace [autoReplace]',
			'directForwardToMp' => 'Direct Forward Mp [directForwardToMp]',
			'priceBidMinimal'   => 'Price Bid Minimal [priceBidMinimal]',
			'priceBidAsking'    => 'Price Bid Asking [priceBidAsking]',
		);
	}

	/**
	 * Skroutz Attribute List
	 *
	 * @return array
	 */
	public function skroutzAttributes() {
		return array(
			'--1'                    => 'Required Information',
			'id'                     => 'Unique ID',
			'name'                   => 'Product Title',
			'description'            => 'Product Description',
			'link'                   => 'Product Link',
			'image'                  => 'Image Link',
			'category'               => 'Category Name',
			'price'                  => 'Price',
			'price_with_vat'         => 'Price With Tax',
			'manufacturer'           => 'Manufacturer',
			'mpn'                    => 'MPN / ISBN',
			'availability'           => 'Availability',
			'---1'                   => '',
			'instock'                => 'Stock Status [InStock]',
			'ean'                    => 'EAN / Barcode',
			'additional_imageurl'    => 'Additional Image Link',
			'additional_imageurl_1'  => 'Additional Image Link 1',
			'additional_imageurl_2'  => 'Additional Image Link 2',
			'additional_imageurl_3'  => 'Additional Image Link 3',
			'additional_imageurl_4'  => 'Additional Image Link 4',
			'additional_imageurl_5'  => 'Additional Image Link 5',
			'additional_imageurl_6'  => 'Additional Image Link 6',
			'additional_imageurl_7'  => 'Additional Image Link 7',
			'additional_imageurl_8'  => 'Additional Image Link 8',
			'additional_imageurl_9'  => 'Additional Image Link 9',
			'additional_imageurl_10' => 'Additional Image Link 10',
			'color'                  => 'Color',
			'size'                   => 'Size',
			'weight'                 => 'Weight',
			'quantity'               => 'Quantity',
		);
	}
	/**
	 * BestPrice Attribute List
	 *
	 * @return array
	 */
	public function bestpriceAttributes() {
		return array(
			'--1'              => 'Required Attributes',
			'productId'        => 'Product ID[productId]',
			'name'             => 'Product Title[name]',
			'description'      => 'Product Description[description]',
			'link'             => 'Product Link[link]',
			'image'            => 'Image Link[image]',
			'categoryPath'     => 'Category Path[categoryPath]',
			'categoryID'       => 'Category Id[categoryID]',
			'price'            => 'Price[price]',
			'manufacturer'     => 'Manufacturer[manufacturer]',
			'mpn'              => 'MPN / ISBN',
			'availability'     => 'Availability',
			'---1'             => 'Recommended Attributes',
			'instock'          => 'Stock Status[instock]',
			'ean'              => 'EAN/Barcode',
			'additional_image' => 'Additional Image Link',
			'color'            => 'Color',
			'size'             => 'Size',
			'weight'           => 'Weight',
			'features'         => 'Features',
			'item_group_id'    => 'Item Group Id'
		);
	}
	/**
	 * Daisycon Attribute List
	 *
	 * @return array
	 */
	public function daisyconAttributes() {
		return array(
			'--1'                  => 'Required Attributes',
			'sku'                  => 'Unique Product ID [SKU]',
			'description'          => 'Description',
			'link'                 => 'Product URL',
			'price'                => 'Price[Current/Sale Price]',
			'title'                => 'Product Title',
			'---1'                 => '',
			'--2'                  => 'Highly Recommended Attributes',
			'image_link_1'         => 'Main Image',
			'brand'                => 'Brand of the product',
			'category'             => 'Main category',
			'category_path'        => 'Category path',
			'delivery_time'        => 'Delivery time in days',
			'ean'                  => 'EAN',
			'google_category_id'   => 'Google category ID',
			'in_stock'             => 'Stock status',
			'in_stock_amount'      => 'Amount of items in stock',
			'price_old'            => 'Old price [Regular Price (in case of discount prices)]',
			'---2'                 => '',
			'--3'                  => 'Recommended Attributes',
			'color_primary'        => 'Primary color of the product',
			'condition'            => 'Product Condition',
			'gender_target'        => 'Gender Target',
			'price_shipping'       => 'Shipping costs',
			'image_link_2'         => 'Image 2',
			'image_link_3'         => 'Image 3',
			'image_link_4'         => 'Image 4',
			'image_link_5'         => 'Image 5',
			'image_link_6'         => 'Image 6',
			'image_link_7'         => 'Image 7',
			'image_link_8'         => 'Image 8',
			'image_link_9'         => 'Image 9',
			'---3'                 => '',
			'--4'                  => 'Optional Attributes',
			'additional_costs'     => 'Additional costs',
			'brand_logo'           => 'Brand Logo URL',
			'delivery_description' => 'Description of the delivery method',
			'keywords'             => 'Keywords [Tags]',
			'model'                => 'Model name/number',
			'material_1'           => 'The primary material',
			'material_2'           => 'The secondary material',
			'material_3'           => 'The tertiary material',
			'priority'             => 'Priority of the product',
			'size'                 => 'General Size field',
			'size_description'     => 'Description for the “size” field',
			'terms_conditions'     => 'Full terms and conditions',
			'---4'                 => '',
		);
	}

	/**
	 * Daisycon Automotive Attribute List
	 *
	 * @return array
	 */
	public function daisycon_automotiveAttributes() {
		return array(
			'--1'                     => 'Required Attributes',
			'description'             => 'Description of the product',
			'link'                    => 'URL to the page of the product',
			'price'                   => 'Price [Current/Sale Price]',
			'sku'                     => 'Unique Product ID [SKU]',
			'title'                   => 'Complete name of the product',
			'---1'                    => '',
			'--2'                     => 'Highly Recommended Attributes',
			'brand'                   => 'Brand of the product',
			'category'                => 'Main category',
			'category_path'           => 'Category path',
			'color_primary'           => 'Primary color of the product',
			'delivery_time'           => 'Delivery time in days',
			'ean'                     => 'EAN',
			'google_category_id'      => 'Google category ID',
			'in_stock'                => 'Stock status',
			'in_stock_amount'         => 'Amount of items in stock',
			'price_old'               => 'Old price [Regular Price]',
			'image_link_1'            => 'Main Image',
			'---2'                    => '',
			'--3'                     => 'Recommended Attributes',
			'condition'               => 'Product Condition',
			'price_shipping'          => 'Shipping costs',
			'image_link_2'            => 'Image 2',
			'image_link_3'            => 'Image 3',
			'image_link_4'            => 'Image 4',
			'image_link_5'            => 'Image 5',
			'image_link_6'            => 'Image 6',
			'image_link_7'            => 'Image 7',
			'image_link_8'            => 'Image 8',
			'image_link_9'            => 'Image 9',
			'---3'                    => '',
			'--4'                     => 'Optional Attributes',
			'additional_costs'        => 'Additional costs',
			'brake_system'            => 'Brake system type',
			'brand_logo'              => 'Brand Logo URL',
			'delivery_description'    => 'Description of the delivery method',
			'fuel_type'               => 'Fuel type',
			'gear_system'             => 'Gear system type',
			'gender_target'           => 'Gender Target',
			'has_airco'               => 'Is there an airco present',
			'keywords'                => 'Keywords [Tags]',
			'model'                   => 'Model name/number',
			'material_1'              => 'The primary material',
			'material_2'              => 'The secondary material',
			'material_3'              => 'The tertiary material',
			'priority'                => 'Priority of the product',
			'rental_location_city'    => 'City of a rental car\'s pick up location (if applicable)',
			'rental_location_country' => 'Country of a rental car\'s pick up location (if applicable)',
			'rental_location_region'  => 'Region of a rental car\'s pick up location (if applicable)',
			'size'                    => 'General field for size',
			'size_description'        => 'Description for the “size” field',
			'tire_size'               => 'The measurements of the tire size of the product.',
			'year_built'              => 'Year in which the product is fabricated',
			'terms_conditions'        => 'Full terms and conditions',
			'---4'                    => '',
		);
	}

	/**
	 * Daisycon Books Attribute List
	 *
	 * @return array
	 */
	public function daisycon_booksAttributes() {
		return array(
			'--1'                  => 'Required Attributes',
			'description'          => 'Description of the product',
			'link'                 => 'URL to the page of the product',
			'price'                => 'Price [Current/Sale Price]',
			'sku'                  => 'Unique Product ID [SKU]',
			'title'                => 'Complete name of the product',
			'---1'                 => '',
			'--2'                  => 'Highly Recommended Attributes',
			'author'               => 'Name of the author',
			'category'             => 'Main category',
			'category_path'        => 'Category path',
			'delivery_time'        => 'Delivery time in days',
			'ean'                  => 'EAN',
			'google_category_id'   => 'Google category ID',
			'in_stock'             => 'Stock status',
			'in_stock_amount'      => 'Amount of items in stock',
			'isbn'                 => 'ISBN of the book/magazine',
			'price_old'            => 'Old price [Regular Price]',
			'image_link_1'         => 'Main Image',
			'---2'                 => '',
			'--3'                  => 'Recommended Attributes',
			'book_publisher'       => 'Publisher of the book',
			'book_type'            => 'Type of book',
			'price_shipping'       => 'Shipping costs',
			'image_link_2'         => 'Image 2',
			'image_link_3'         => 'Image 3',
			'image_link_4'         => 'Image 4',
			'image_link_5'         => 'Image 5',
			'image_link_6'         => 'Image 6',
			'image_link_7'         => 'Image 7',
			'image_link_8'         => 'Image 8',
			'image_link_9'         => 'Image 9',
			'---3'                 => '',
			'--4'                  => 'Low Priority Attributes',
			'condition'            => 'Product Condition',
			'gender_target'        => 'Gender to which the product is aimed',
			'number_of_pages'      => 'Number of pages',
			'release_date'         => 'Date of publication',
			'---4'                 => '',
			'--5'                  => 'Optional Attributes',
			'additional_costs'     => 'Additional costs',
			'book_edition'         => 'Edition of the book',
			'brand'                => 'Brand of the product',
			'brand_logo'           => 'URL to an image of the brand logo',
			'color_primary'        => 'Primary color of the product',
			'delivery_description' => 'Description of the delivery method',
			'file_size'            => 'Total file size in kbps',
			'file_type'            => 'File type (for example: epub)',
			'keywords'             => 'Keywords for this product',
			'language'             => 'Language of the product',
			'model'                => 'Model name/number',
			'priority'             => 'Priority of the product',
			'size'                 => 'General field for size',
			'size_description'     => 'Description for the “size” field',
			'size_length'          => 'Magazine length in mm',
			'size_width'           => 'Magazine width in mm',
			'weight'               => 'Weight in grams',
			'material_1'           => 'The primary material',
			'material_2'           => 'The secondary material',
			'material_3'           => 'The tertiary material',
			'terms_conditions'     => 'Full terms and conditions',
			'---5'                 => '',
		);
	}

	/**
	 * Daisycon Cosmetics Attribute List
	 *
	 * @return array
	 */
	public function daisycon_cosmeticsAttributes() {
		return array(
			'--1'                     => 'Required Attributes',
			'description'             => 'Description of the product',
			'link'                    => 'URL to the page of the product',
			'price'                   => 'Price [Current/Sale Price]',
			'sku'                     => 'Unique Product ID [SKU]',
			'title'                   => 'Complete name of the product',
			'---1'                    => '',
			'--2'                     => 'Highly Recommended Attributes',
			'allergic_info'           => 'Allergy information',
			'amount_content'          => 'Amount of content, for example: 120(in combination with amount_description)',
			'amount_description'      => 'The unit in which the amount is specified for example: ml',
			'category'                => 'Main category',
			'category_path'           => 'Category path',
			'delivery_time'           => 'Delivery time in days',
			'ean'                     => 'EAN',
			'google_category_id'      => 'Google category ID',
			'in_stock'                => 'Stock status',
			'in_stock_amount'         => 'Amount of items in stock',
			'price_old'               => 'Old price [Regular Price]',
			'image_link_1'            => 'Main Image',
			'---2'                    => '',
			'--3'                     => 'Recommended Attributes',
			'description_ingredients' => 'Description of the ingredients',
			'gender_target'           => 'Gender to which the product is aimed',
			'price_shipping'          => 'Shipping costs',
			'skin_type'               => 'Skintype for which the product is made',
			'image_link_2'            => 'Image 2',
			'image_link_3'            => 'Image 3',
			'image_link_4'            => 'Image 4',
			'image_link_5'            => 'Image 5',
			'image_link_6'            => 'Image 6',
			'image_link_7'            => 'Image 7',
			'image_link_8'            => 'Image 8',
			'image_link_9'            => 'Image 9',
			'---3'                    => '',
			'--4'                     => 'Low Priority Attributes',
			'color_primary'           => 'Primary color of the product',
			'--5'                     => 'Optional Attributes',
			'additional_costs'        => 'Additional costs',
			'brand_logo'              => 'URL to an image of the brand logo',
			'condition'               => 'Product Condition',
			'delivery_description'    => 'Description of the delivery method',
			'keywords'                => 'Keywords for this product',
			'made_in_country'         => 'Country in which the product is fabricated',
			'model'                   => 'Model name/number',
			'priority'                => 'Priority of the product',
			'size'                    => 'General field for size',
			'size_description'        => 'Description for the “size” field',
			'weight'                  => 'Weight in grams',
			'material_1'              => 'The primary material',
			'material_2'              => 'The secondary material',
			'material_3'              => 'The tertiary material',
			'terms_conditions'        => 'Full terms and conditions',
			'---5'                    => '',
		);
	}

	/**
	 * Daisycon Daily Offers Attribute List
	 *
	 * @return array
	 */
	public function daisycon_daily_offersAttributes() {
		return array(
			'--1'                  => 'Required Attributes',
			'description'          => 'Description of the product',
			'link'                 => 'URL to the page of the product',
			'price'                => 'Price [Current/Sale Price]',
			'sku'                  => 'Unique Product ID [SKU]',
			'title'                => 'Complete name of the product',
			'---1'                 => '',
			'--2'                  => 'Highly Recommended Attributes',
			'brand'                => 'Brand of the product',
			'category'             => 'Main category',
			'category_path'        => 'Category path',
			'delivery_time'        => 'Delivery time in days',
			'ean'                  => 'EAN',
			'in_stock'             => 'Stock status',
			'in_stock_amount'      => 'Amount of items in stock',
			'price_old'            => 'Old price [Regular Price]',
			'image_link_1'         => 'Main Image',
			'---2'                 => '',
			'--3'                  => 'Recommended Attributes',
			'google_category_id'   => 'Google category ID',
			'price_shipping'       => 'Shipping costs',
			'image_link_2'         => 'Image 2',
			'image_link_3'         => 'Image 3',
			'image_link_4'         => 'Image 4',
			'image_link_5'         => 'Image 5',
			'image_link_6'         => 'Image 6',
			'image_link_7'         => 'Image 7',
			'image_link_8'         => 'Image 8',
			'image_link_9'         => 'Image 9',
			'---3'                 => '',
			'--4'                  => 'Optional Attributes',
			'additional_costs'     => 'Additional costs',
			'brand_logo'           => 'URL to an image of the brand logo',
			'color_primary'        => 'Primary color of the product',
			'condition'            => 'Product Condition',
			'delivery_description' => 'Description of the delivery method',
			'discount_amount'      => 'Amount of discount in euro\'s',
			'discount_percentage'  => 'Amount of discount in percent',
			'gender_target'        => 'Gender to which the product is aimed',
			'keywords'             => 'Keywords for this product',
			'model'                => 'Model name/number',
			'offer_datetime_end'   => 'End (time and) date of the daily offer',
			'offer_datetime_start' => 'Start (time and) date of the daily offer',
			'size'                 => 'General field for size',
			'size_description'     => 'Description for the “size” field',
			'material_1'           => 'The primary material',
			'material_2'           => 'The secondary material',
			'material_3'           => 'The tertiary material',
			'terms_conditions'     => 'Full terms and conditions',
			'---4'                 => '',
		);
	}

	/**
	 * Daisycon Electronics Attribute List
	 *
	 * @return array
	 */
	public function daisycon_electronicsAttributes() {
		return array(
			'--1'                    => 'Required Attributes',
			'description'            => 'Description of the product',
			'link'                   => 'URL to the page of the product',
			'price'                  => 'Price [Current/Sale Price]',
			'sku'                    => 'Unique Product ID [SKU]',
			'title'                  => 'Complete name of the product',
			'---1'                   => '',
			'--2'                    => 'Highly Recommended Attributes',
			'brand'                  => 'Brand of the product',
			'category'               => 'Main category',
			'category_path'          => 'Category path',
			'delivery_time'          => 'Delivery time in days',
			'ean'                    => 'EAN',
			'google_category_id'     => 'Google category ID',
			'in_stock'               => 'Stock status',
			'in_stock_amount'        => 'Amount of items in stock',
			'model'                  => 'Model name/number',
			'price_old'              => 'Old price [Regular Price]',
			'image_link_1'           => 'Main Image',
			'---2'                   => '',
			'--3'                    => 'Recommended Attributes',
			'color_primary'          => 'Primary color of the product',
			'price_shipping'         => 'Shipping costs',
			'image_link_2'           => 'Image 2',
			'image_link_3'           => 'Image 3',
			'image_link_4'           => 'Image 4',
			'image_link_5'           => 'Image 5',
			'image_link_6'           => 'Image 6',
			'image_link_7'           => 'Image 7',
			'image_link_8'           => 'Image 8',
			'image_link_9'           => 'Image 9',
			'---3'                   => '',
			'--4'                    => 'Low Priority Attributes',
			'condition'              => 'Product Condition',
			'---4'                   => '',
			'--5'                    => 'Optional Attributes',
			'additional_costs'       => 'Additional costs',
			'audio_surround'         => 'Has audio surround sound',
			'batteries_included'     => 'Specifies is batteries are included at the purchase of the product',
			'brand_logo'             => 'URL to an image of the brand logo',
			'connection_type'        => 'Connection type, for example: USB',
			'delivery_description'   => 'Description of the delivery method',
			'device_max_content'     => 'Maximum content of the product, for example: 7KG or 3L',
			'device_max_temperature' => 'Maximum temperature the device can reach in Celsius',
			'device_serve_amount'    => 'Amount of portions/persons the product can serve.',
			'device_watt'            => 'Maximum wattage of the product for example: 450',
			'dishwasher_safe'        => 'Product is dishwasher proof',
			'disposal_fee'           => 'Disposal fee of the product in euro’s',
			'file_types_supported'   => 'Supported filetypes',
			'gender_target'          => 'Gender to which the product is aimed',
			'has_alarm'              => 'Product has an alarm',
			'has_grill'              => 'Product has a grill option, or a grill is present',
			'has_microwave'          => 'Product has a microwave option or a microwave is present',
			'has_oven'               => 'Product has an oven option or an oven is present',
			'has_radio'              => 'Product has a radio option or a radio is pressent',
			'has_remote_control'     => 'Product has a remote',
			'has_timer'              => 'Product has a timer',
			'has_wifi'               => 'Product has a wifi connection or wifi is present',
			'keywords'               => 'Keywords for this product',
			'made_in_country'        => 'Country in which the product is fabricated',
			'partnumber'             => 'Part Number [MPN]',
			'power_type'             => 'Type of energysource, for example: gas, electric, ceramic',
			'price_suggested_retail' => 'Suggested price',
			'priority'               => 'Priority of the product',
			'resolution_record'      => 'Camera recording resolution of the product (for example: 1280x768, 350dpi or 10MP)',
			'resolution_screen'      => 'Screenresolution of the product (For example: 1280x768 or 350dpi)',
			'screen_size'            => 'Screensize in inches',
			'screen_type'            => 'Screentype of the product (for example: LED/3D/etc.)',
			'size'                   => 'General field for size',
			'size_description'       => 'Description for the “size” field',
			'size_length'            => 'Product length in mm',
			'size_width'             => 'Product width in mm',
			'specs'                  => 'All specifications/functionalities of the product',
			'terms_conditions'       => 'Full terms and conditions',
			'material_1'             => 'The primary material',
			'material_2'             => 'The secondary material',
			'material_3'             => 'The tertiary material',
			'---5'                   => '',
		);
	}

	/**
	 * Daisycon Food & Drinks Attribute List
	 *
	 * @return array
	 */
	public function daisycon_food_drinksAttributes() {
		return array(
			'--1'                     => 'Required Attributes',
			'description'             => 'Description of the product',
			'link'                    => 'URL to the page of the product',
			'price'                   => 'Price [Current/Sale Price]',
			'sku'                     => 'Unique Product ID [SKU]',
			'title'                   => 'Complete name of the product',
			'---1'                    => '',
			'--2'                     => 'Highly Recommended Attributes',
			'amount_content'          => 'Amount of content, for example: 120 (in combination with amount_description)',
			'amount_description'      => 'Unit of content amount: ml',
			'brand'                   => 'Brand of the product',
			'category'                => 'Main category',
			'category_path'           => 'Category path',
			'delivery_time'           => 'Delivery time in days',
			'ean'                     => 'EAN',
			'google_category_id'      => 'Google category ID',
			'in_stock'                => 'Stock status',
			'in_stock_amount'         => 'Amount of items in stock',
			'price_old'               => 'Old price [Regular Price]',
			'image_link_1'            => 'Main Image',
			'---2'                    => '',
			'--3'                     => 'Recommended Attributes',
			'price_shipping'          => 'Shipping costs',
			'image_link_2'            => 'Image 2',
			'image_link_3'            => 'Image 3',
			'image_link_4'            => 'Image 4',
			'image_link_5'            => 'Image 5',
			'image_link_6'            => 'Image 6',
			'image_link_7'            => 'Image 7',
			'image_link_8'            => 'Image 8',
			'image_link_9'            => 'Image 9',
			'---3'                    => '',
			'--5'                     => 'Optional Attributes',
			'additional_costs'        => 'Additional costs',
			'alcohol_percentage'      => 'Alcohol percentage for example: 15.0',
			'allergic_info'           => 'Allergy information',
			'brand_logo'              => 'URL to an image of the brand logo',
			'color_primary'           => 'Primary color of the product',
			'condition'               => 'Product Condition',
			'customer_rating'         => 'Average rating of the product in customer reviews, for example: 2/5 of 7/10',
			'delivery_area'           => 'Delivery area',
			'delivery_pickup'         => 'Can the order be delivered or only picked up?',
			'delivery_times'          => 'Possible delivery hours',
			'description_ingredients' => 'Ingrediënts of the product',
			'gender_target'           => 'Gender to which the product is aimed',
			'keywords'                => 'Keywords for this product',
			'model'                   => 'Model name/number',
			'priority'                => 'Priority of the product',
			'restaurant_address'      => 'Adress of the restaurant',
			'serving_advice'          => 'Serving tip / serving suggestion',
			'size'                    => 'General field for size',
			'size_description'        => 'Description for the “size” field',
			'taste'                   => 'Description of the taste of the product',
			'taste_type'              => 'Description of the type of taste, for example: sweet or sour',
			'weight'                  => 'Weight in grams',
			'wine_city'               => 'Wine city of heritage',
			'wine_country'            => 'Wine country of heritage',
			'wine_grape'              => 'Type of grape used for the wine',
			'wine_region'             => 'Wine region of heritage',
			'wine_year'               => 'Wine year',
			'material_1'              => 'The primary material',
			'material_2'              => 'The secondary material',
			'material_3'              => 'The tertiary material',
			'terms_conditions'        => 'Full terms and conditions',
			'---5'                    => '',
		);
	}

	/**
	 * Daisycon Home & Garden Attribute List
	 *
	 * @return array
	 */
	public function daisycon_home_gardenAttributes() {
		return array(
			'--1'                  => 'Required Attributes',
			'description'          => 'Description of the product',
			'link'                 => 'URL to the page of the product',
			'price'                => 'Price [Current/Sale Price]',
			'sku'                  => 'Unique Product ID [SKU]',
			'title'                => 'Complete name of the product',
			'---1'                 => '',
			'--2'                  => 'Highly Recommended Attributes',
			'brand'                => 'Brand of the product',
			'category'             => 'Main category',
			'category_path'        => 'Category path',
			'delivery_time'        => 'Delivery time in days',
			'ean'                  => 'EAN',
			'google_category_id'   => 'Google category ID',
			'in_stock'             => 'Stock status',
			'in_stock_amount'      => 'Amount of items in stock',
			'price_old'            => 'Old price [Regular Price]',
			'image_link_1'         => 'Main Image',
			'---2'                 => '',
			'--3'                  => 'Recommended Attributes',
			'model'                => 'Modelname/-number of the manufacturer',
			'price_shipping'       => 'Shipping costs',
			'image_link_2'         => 'Image 2',
			'image_link_3'         => 'Image 3',
			'image_link_4'         => 'Image 4',
			'image_link_5'         => 'Image 5',
			'image_link_6'         => 'Image 6',
			'image_link_7'         => 'Image 7',
			'image_link_8'         => 'Image 8',
			'image_link_9'         => 'Image 9',
			'---3'                 => '',
			'--4'                  => 'Low Priority Attributes',
			'designer'             => 'Name of the designer of the product',
			'made_in_country'      => 'Country where the product is fabricated',
			'---4'                 => '',
			'--5'                  => 'Optional Attributes',
			'additional_costs'     => 'Additional costs',
			'brand_logo'           => 'URL to an image of the brand logo',
			'color_primary'        => 'Primary color of the product',
			'condition'            => 'Product Condition',
			'delivery_description' => 'Description of the delivery method',
			'gender_target'        => 'Gender to which the product is aimed',
			'keywords'             => 'Keywords for this product',
			'priority'             => 'Priority of the product',
			'size'                 => 'General field for size',
			'size_description'     => 'Description for the “size” field',
			'size_length'          => 'Product length in mm',
			'size_width'           => 'Product width in mm',
			'weight'               => 'Weight in grams',
			'material_1'           => 'The primary material',
			'material_2'           => 'The secondary material',
			'material_3'           => 'The tertiary material',
			'terms_conditions'     => 'Full terms and conditions',
			'---5'                 => '',
		);
	}

	/**
	 * Daisycon Housing Attribute List
	 *
	 * @return array
	 */
	public function daisycon_housingAttributes() {
		return array(
			'--1'                               => 'Required Attributes',
			'description'                       => 'Description of the product',
			'link'                              => 'URL to the page of the product',
			'price'                             => 'Price [Current/Sale Price]',
			'sku'                               => 'Unique Product ID [SKU]',
			'title'                             => 'Complete name of the product',
			'---1'                              => '',
			'--2'                               => 'Highly Recommended Attributes',
			'address'                           => 'Adress of the residence',
			'available_from'                    => 'From which date is the product available',
			'available_to'                      => 'Till which date is the product available',
			'category'                          => 'Main category',
			'category_path'                     => 'Category path',
			'city'                              => 'City of the residence',
			'delivery_time'                     => 'Delivery time in days',
			'ean'                               => 'EAN',
			'energy_label'                      => 'Energielabel of the residence',
			'floor_area'                        => 'Area surface in m²',
			'google_category_id'                => 'Google category ID',
			'in_stock'                          => 'Stock status',
			'in_stock_amount'                   => 'Amount of items in stock',
			'latitude'                          => 'Latitude of the location (DDD.dddd format)',
			'longitude'                         => 'Longitude of the location (DDD.dddd format)',
			'price_old'                         => 'Old price [Regular Price]',
			'rental_commission'                 => 'Rental price of the residence',
			'service_costs'                     => 'Servicecosts',
			'year_built'                        => 'Date the residence is constructed',
			'zipcode'                           => 'Zipcode of the residence',
			'---2'                              => '',
			'--3'                               => 'Recommended Attributes',
			'accessibility'                     => 'Is it accessible for elderly people and disabled people',
			'building_type'                     => 'Type of building',
			'contract_type'                     => 'Type of contract',
			'floor'                             => 'Floor of the residence',
			'heating_type'                      => 'Type of heating (gas, cityheating, different)',
			'number_of_bedrooms'                => 'Number of bedrooms in the residence',
			'number_of_floors'                  => 'Number of floors in the residence',
			'number_of_rooms'                   => 'Number of rooms in the residence',
			'parking'                           => 'Is there a parking spot(none, public, payed or private)',
			'plot_area'                         => 'Plot area in m²',
			'image_link_2'                      => 'Image 2',
			'image_link_3'                      => 'Image 3',
			'image_link_4'                      => 'Image 4',
			'image_link_5'                      => 'Image 5',
			'image_link_6'                      => 'Image 6',
			'image_link_7'                      => 'Image 7',
			'image_link_8'                      => 'Image 8',
			'image_link_9'                      => 'Image 9',
			'---3'                              => '',
			'--4'                               => 'Low Priority Attributes',
			'condition'                         => 'Product conditio',
			'---4'                              => '',
			'--5'                               => 'Optional Attributes',
			'additional_costs'                  => 'Additional costs',
			'brand'                             => 'Brand of the product',
			'brand_logo'                        => 'URL to an image of the brand logo',
			'color_primary'                     => 'Primary color of the product',
			'delivery_description'              => 'Description of the delivery method',
			'distance_to_green_area'            => 'Distance to the nearest green (golf) in meters',
			'distance_to_public_transportation' => 'Distance to the nearest public transport in meters',
			'distance_to_residential_area'      => 'Distance to the nearest residential area (0 = situated in residential area)',
			'distance_to_supermarket'           => 'Distance to the nearest supermarket in meters',
			'distance_to_towncenter'            => 'Distance to the nearest towncenter in meters',
			'distance_to_water'                 => 'Distance to the nearest river, lake or sea in meters',
			'gender_target'                     => 'Gender to which the product is aimed',
			'has_balcony'                       => 'Is there a balcony present',
			'has_elevator'                      => 'Is there an elevator present',
			'has_fireplace'                     => 'Is there a fireplace present',
			'has_garage'                        => 'Is there a garage present',
			'has_garden'                        => 'Is there a garden present',
			'has_shared_bathroom'               => 'Does it have a shared bathroom',
			'has_shared_kitchen'                => 'Does it have a shared kitchen',
			'has_shared_livingroom'             => 'Does it have a shared livingroom',
			'has_storage'                       => 'Does it have a storage area',
			'is_allowed_pets'                   => 'Are pets allowed',
			'is_allowed_smoking'                => 'Is smoking allowed',
			'is_furnished'                      => 'Is the residence furnished',
			'is_including_electricity'          => 'Is electricity included',
			'is_including_heating'              => 'Is heating included',
			'is_including_water'                => 'Is water included',
			'keywords'                          => 'Keywords [Tags]',
			'model'                             => 'Model name/number',
			'price_shipping'                    => 'Shipping costs',
			'price_type'                        => 'Type of price (asked price, "bidding starts at" price)',
			'priority'                          => 'Priority of the product',
			'province'                          => 'Province in which the residence is located',
			'rental_deposit'                    => 'Rental deposit',
			'size'                              => 'General field for size',
			'size_description'                  => 'Description for the “size” field',
			'storage_area'                      => 'Surface of the storage area in m²',
			'type_of_property'                  => 'Type of real estate',
			'material_1'                        => 'The primary material',
			'material_2'                        => 'The secondary material',
			'material_3'                        => 'The tertiary material',
			'terms_conditions'                  => 'Full terms and conditions',
			'---5'                              => '',
		);
	}

	/**
	 * Daisycon Fashion Attribute List
	 *
	 * @return array
	 */
	public function daisycon_fashionAttributes() {
		return array(
			'--1'                  => 'Required Attributes',
			'description'          => 'Description of the product',
			'link'                 => 'URL to the page of the product',
			'price'                => 'Price [Current/Sale Price]',
			'sku'                  => 'Unique Product ID [SKU]',
			'title'                => 'Complete name of the product',
			'---1'                 => '',
			'--2'                  => 'Highly Recommended Attributes',
			'brand'                => 'Brand of the product',
			'category'             => 'Main category',
			'category_path'        => 'Keywords for this product',
			'color_primary'        => 'Primary color of the product',
			'condition'            => 'Product Condition',
			'delivery_time'        => 'Delivery time in days',
			'ean'                  => 'EAN',
			'gender_target'        => 'Gender to which the product is aimed',
			'google_category_id'   => 'Google category ID',
			'in_stock'             => 'Stock status',
			'in_stock_amount'      => 'Amount of items in stock',
			'price_old'            => 'Old price [Regular Price]',
			'size'                 => 'General field for size',
			'size_description'     => 'Description for the “size” field',
			'---2'                 => '',
			'--3'                  => 'Recommended Attributes',
			'model'                => 'Model name/number',
			'price_shipping'       => 'Shipping costs',
			'image_link_2'         => 'Image 2',
			'image_link_3'         => 'Image 3',
			'image_link_4'         => 'Image 4',
			'image_link_5'         => 'Image 5',
			'image_link_6'         => 'Image 6',
			'image_link_7'         => 'Image 7',
			'image_link_8'         => 'Image 8',
			'image_link_9'         => 'Image 9',
			'---3'                 => '',
			'--4'                  => 'Low Priority Attributes',
			'material_description' => 'Description of the material that is used for the product',
			'---4'                 => '',
			'--5'                  => 'Optional Attributes',
			'additional_costs'     => 'Additional costs',
			'brand_logo'           => 'URL to an image of the brand logo',
			'delivery_description' => 'Description of the delivery method',
			'keywords'             => 'Keywords for this product',
			'priority'             => 'Priority of the product',
			'material_1'           => 'The primary material',
			'material_2'           => 'The secondary material',
			'material_3'           => 'The tertiary material',
			'terms_conditions'     => 'Full terms and conditions',
			'---5'                 => '',
		);
	}

	/**
	 * Daisycon Studies & Trainings Attribute List
	 *
	 * @return array
	 */
	public function daisycon_studies_trainingsAttributes() {
		return array(
			'--1'                  => 'Required Attributes',
			'description'          => 'Description of the product',
			'link'                 => 'URL to the page of the product',
			'price'                => 'Price [Current/Sale Price]',
			'sku'                  => 'Unique Product ID [SKU]',
			'title'                => 'Complete name of the product',
			'---1'                 => '',
			'--2'                  => 'Highly Recommended Attributes',
			'category'             => 'Main category',
			'category_path'        => 'Category path',
			'course_time_duration' => 'Duration of each lesson/course',
			'course_time_start'    => 'Starting time of each lesson/course',
			'delivery_time'        => 'Delivery time in days',
			'ean'                  => 'EAN',
			'education_duration'   => 'Total duration of the programme/course',
			'education_location'   => 'Location where the lessons are held',
			'google_category_id'   => 'Google category ID',
			'in_stock'             => 'Stock status',
			'in_stock_amount'      => 'Amount of items in stock',
			'monthly_price'        => 'Monthly costs of the study/course',
			'price_old'            => 'Old price [Regular Price]',
			'image_link_1'         => 'Main Image',
			'---2'                 => '',
			'--3'                  => 'Recommended Attributes',
			'education_institute'  => 'Institute where the lessons are held',
			'education_level'      => 'Educational level (For example: HBO)',
			'price_shipping'       => 'Shipping costs',
			'image_link_2'         => 'Image 2',
			'image_link_3'         => 'Image 3',
			'image_link_4'         => 'Image 4',
			'image_link_5'         => 'Image 5',
			'image_link_6'         => 'Image 6',
			'image_link_7'         => 'Image 7',
			'image_link_8'         => 'Image 8',
			'image_link_9'         => 'Image 9',
			'---3'                 => '',
			'--5'                  => 'Optional Attributes',
			'additional_costs'     => 'Additional costs',
			'brand'                => 'Brand of the product',
			'brand_logo'           => 'URL to an image of the brand logo',
			'delivery_description' => 'Description of the delivery method',
			'gender_target'        => 'Gender to which the product is aimed',
			'keywords'             => 'Keywords for this product',
			'model'                => 'Model name/number',
			'priority'             => 'Priority of the product',
			'size'                 => 'General field for size',
			'size_description'     => 'Description for the “size” field',
			'material_1'           => 'The primary material',
			'material_2'           => 'The secondary material',
			'material_3'           => 'The tertiary material',
			'terms_conditions'     => 'Full terms and conditions',
			'---5'                 => '',
		);
	}

	/**
	 * Daisycon Telecom: Accessories Attribute List
	 *
	 * @return array
	 */
	public function daisycon_telecom_accessoriesAttributes() {
		return array(
			'--1'                  => 'Required Attributes',
			'description'          => 'Description of the product',
			'link'                 => 'URL to the page of the product',
			'price'                => 'Price [Current/Sale Price]',
			'sku'                  => 'Unique Product ID [SKU]',
			'title'                => 'Complete name of the product',
			'---1'                 => '',
			'--2'                  => 'Highly Recommended Attributes',
			'brand'                => 'Brand of the product',
			'category'             => 'Main category',
			'category_path'        => 'Category path',
			'delivery_time'        => 'Delivery time in days',
			'ean'                  => 'EAN',
			'google_category_id'   => 'Google category ID',
			'in_stock'             => 'Stock status',
			'in_stock_amount'      => 'Amount of items in stock',
			'mobile_device_brand'  => 'GSM-device brand the product is meant for',
			'mobile_device_model'  => 'Modelname of GSM-device (for example: iPhone 7) the product is meant for',
			'model'                => 'Model name/number',
			'price_old'            => 'Old price [Regular Price]',
			'image_link_1'         => 'Main Image',
			'---2'                 => '',
			'--3'                  => 'Recommended Attributes',
			'color_primary'        => 'Primary color of the product',
			'price_shipping'       => 'Shipping costs',
			'image_link_2'         => 'Image 2',
			'image_link_3'         => 'Image 3',
			'image_link_4'         => 'Image 4',
			'image_link_5'         => 'Image 5',
			'image_link_6'         => 'Image 6',
			'image_link_7'         => 'Image 7',
			'image_link_8'         => 'Image 8',
			'image_link_9'         => 'Image 9',
			'---3'                 => '',
			'--5'                  => 'Optional Attributes',
			'additional_costs'     => 'Additional costs (like private copy levy)',
			'brand_logo'           => 'URL to an image of the brand logo',
			'condition'            => 'Product Condition',
			'delivery_description' => 'Description of the delivery method',
			'incentive'            => 'Incentive text (for example: a gift)',
			'keywords'             => 'Keywords for this product',
			'partnumber'           => 'Part Number [MPN]',
			'priority'             => 'Priority of the product',
			'size'                 => 'General field for size',
			'size_description'     => 'Description for the “size” field',
			'material_1'           => 'The primary material',
			'material_2'           => 'The secondary material',
			'material_3'           => 'The tertiary material',
			'terms_conditions'     => 'Full terms and conditions',
			'---5'                 => '',
		);
	}

	/**
	 * Daisycon Telecom: All-in-one Attribute List
	 *
	 * @return array
	 */
	public function daisycon_telecom_all_in_oneAttributes() {
		return array(
			'--1'                               => 'Required Attributes',
			'allinone_subscription_type'        => 'Subscription type',
			'bandwidth_download'                => 'Download in Mbits',
			'bandwidth_upload'                  => 'Upload in Mbits',
			'description'                       => 'Description of the product',
			'internet_connection_type'          => 'Type of internet connection',
			'link'                              => 'URL to the page of the product',
			'provider'                          => 'Subscription provider',
			'price'                             => 'From price',
			'sku'                               => 'Unique Product ID [SKU]',
			'subscription_duration'             => 'Subscription duration in months',
			'subscription_installation_costs'   => 'Installation costs/ administration costs',
			'title'                             => 'Name of the product',
			'---1'                              => '',
			'--2'                               => 'Highly Recommended Attributes',
			'gift_description'                  => 'Description of gift added to the subscription',
			'has_tv_on_demand'                  => 'On-demand / Missed episode possibility',
			'has_tv_recording'                  => 'TV recording possible',
			'subscription_discount_description' => 'Short description',
			'subscription_discount_duration'    => 'Discount duration in months',
			'subscription_discount_price'       => 'Calculated price including discount',
			'subscription_price_off_peakhours'  => 'Telephone off-peak hour tariff',
			'subscription_price_peakhours'      => 'Telephone peak hour tariff',
			'subscription_price_start_rate'     => 'Telephone starting tariff',
			'tv_channels_analog_count'          => 'Amount of analogue TV channels',
			'tv_channels_digital_count'         => 'Amount of digital TV channels',
			'tv_channels_hd_count'              => 'Amount of HD TV channels',
			'tv_count'                          => 'Amount of TV\'s that can be connected',
			'---2'                              => '',
			'--3'                               => 'Recommended Attributes',
			'category'                          => 'Main category',
			'category_path'                     => 'Category path',
			'delivery_time'                     => 'Delivery time in days',
			'ean'                               => 'EAN',
			'google_category_id'                => 'Google category ID',
			'in_stock'                          => 'Stock status',
			'in_stock_amount'                   => 'Amount of items in stock',
			'price_old'                         => 'Old price [Regular Price]',
			'price_shipping'                    => 'Shipping costs',
			'image_link_2'                      => 'Image 2',
			'image_link_3'                      => 'Image 3',
			'image_link_4'                      => 'Image 4',
			'image_link_5'                      => 'Image 5',
			'image_link_6'                      => 'Image 6',
			'image_link_7'                      => 'Image 7',
			'image_link_8'                      => 'Image 8',
			'image_link_9'                      => 'Image 9',
			'---3'                              => '',
			'--5'                               => 'Optional Attributes',
			'additional_costs'                  => 'Additional costs',
			'brand'                             => 'Brand of the product',
			'brand_logo'                        => 'URL to an image of the brand logo',
			'gender_target'                     => 'Gender to which the product is aimed',
			'keywords'                          => 'Keywords for this product',
			'model'                             => 'Model name/number',
			'offer_datetime_end'                => 'End (time and) date of the offer',
			'offer_datetime_start'              => 'Start (time and) date of the offer',
			'priority'                          => 'Priority of the product',
			'radio_channels_count'              => 'Amount of digital radio channels',
			'radio_channels_description'        => 'Description of the radio channels',
			'tv_channels_analog_description'    => 'Description of the analogue TV channels',
			'tv_channels_digital_description'   => 'Description of the digital TV channels',
			'tv_channels_hd_description'        => 'Description of the HD TV channels',
			'material_1'                        => 'The primary material',
			'material_2'                        => 'The secondary material',
			'material_3'                        => 'The tertiary material',
			'terms_conditions'                  => 'Full terms and conditions',
			'---5'                              => '',
		);
	}

	/**
	 * Daisycon Telecom: GSM + Subscription Attribute List
	 *
	 * @return array
	 */
	public function daisycon_telecom_gsm_subscriptionAttributes() {
		return array(
			'--1'                                 => 'Required Attributes',
			'description'                         => 'Description of the product',
			'link'                                => 'URL to the page of the product',
			'price'                               => 'One-off costs of the GSM-device',
			'sku'                                 => 'Unique Product ID [SKU]',
			'title'                               => 'Name of the product',
			'---1'                                => '',
			'--2'                                 => 'Highly Recommended Attributes',
			'bandwidth_download'                  => 'Download speed in Mbits',
			'bandwidth_upload'                    => 'Upload speed in Mbits',
			'condition'                           => 'Product Condition',
			'delivery_description'                => 'Description of the delivery method',
			'delivery_time'                       => 'Delivery time in days',
			'ean'                                 => 'EAN',
			'has_subscription_4g'                 => 'GSM-device has 4G',
			'in_stock'                            => 'Stock status',
			'in_stock_amount'                     => 'Amount of items in stock',
			'interest_rate'                       => 'The subscriptions interest rate',
			'mobile_device_brand'                 => 'Brand of the GSM-device',
			'mobile_device_color'                 => 'Color of the GSM-device specified by the manufacturer',
			'mobile_device_model'                 => 'Modelname of the GSM-device (for example: iPhone 7)',
			'mobile_device_subscription_duration' => 'Subscription length of the SM subscription in months',
			'mobile_device_subscription_price'    => 'Monthly costs of the GSM subscription',
			'mobile_device_subscription_title'    => 'Description of the GSM subscription',
			'mobile_device_total_costs'           => 'Totale costs GSM-device (GSM subscription + one-off costs)',
			'network'                             => 'Mobile network of the SIM subscription',
			'price_old'                           => 'Old price [Regular Price]',
			'price_shipping'                      => 'Shipping costs',
			'provider'                            => 'Provider SIM subscription',
			'subscription_allowance_data'         => 'Amount of MB’s in SIM subscription',
			'subscription_allowance_minutes'      => 'Amount of minutes in SIM subscription',
			'subscription_allowance_sms'          => 'Amount of text messages in SIM subscription',
			'subscription_discount'               => 'Amount of discount',
			'subscription_discount_description'   => 'Discount description',
			'subscription_discount_duration'      => 'Discount duration in months',
			'subscription_discount_price'         => 'Calculated price (including discount)',
			'subscription_duration'               => 'SIM subscription length in months',
			'subscription_installation_costs'     => 'Installation costs',
			'subscription_name'                   => 'Name of the subscription',
			'subscription_price'                  => 'SIM subscription + GSM subscription costs per month',
			'subscription_renewal'                => 'Is the subscription a continued subscription',
			'subscription_shared_data'            => 'Does the number for the amount of MB\'s data get shared with the amount of calltime / text messages',
			'subscription_shared_minutes'         => 'Does the number for the amount calltime get shared with the amount of text messages',
			'subscription_shared_sms'             => 'Does the number for the amount text messages get shared with the amount of calltime',
			'subscription_subscription_price'     => 'Price SIM subscription',
			'subscription_total_costs'            => 'Totale costs SIM subscription + GSM subscription x subscription length',
			'---2'                                => '',
			'--3'                                 => 'Recommended Attributes',
			'category'                            => 'Main category',
			'category_path'                       => 'Category path',
			'color_primary'                       => 'Primary color of the GSM-device',
			'google_category_id'                  => 'Google category ID',
			'internet_only'                       => 'Does the SIM subscription only offer internet',
			'image_link_2'                        => 'Image 2',
			'image_link_3'                        => 'Image 3',
			'image_link_4'                        => 'Image 4',
			'image_link_5'                        => 'Image 5',
			'image_link_6'                        => 'Image 6',
			'image_link_7'                        => 'Image 7',
			'image_link_8'                        => 'Image 8',
			'image_link_9'                        => 'Image 9',
			'---3'                                => '',
			'--5'                                 => 'Optional Attributes',
			'additional_costs'                    => 'Additional costs (for example: private copy levy)',
			'bandwidth_download_descr'            => 'Download speed written completely',
			'bandwidth_upload_descr'              => 'Upload speed written completely',
			'brand_logo'                          => 'URL to an image of the brand logo',
			'device_connection_type'              => 'Internetconnection type of the GSM-device (for example: 4G)',
			'device_simlock_network'              => 'Does the GSM-device have an active simlock',
			'device_standby_time'                 => 'Standby time of the GSM-device',
			'device_talk_time'                    => 'Talk time of the GSM-device',
			'has_bluetooth'                       => 'GSM-device has bluetooth',
			'has_camera'                          => 'GSM-device has a camera',
			'has_radio'                           => 'GSM-device has radio',
			'incentive'                           => 'Incentive text (For example: an added gift)',
			'internet_connection_type'            => 'Internet connection type of the SIM subscription(bijv. 4G)',
			'keywords'                            => 'Keywords for this product',
			'priority'                            => 'Priority of the product',
			'resolution_record'                   => 'Camera recording resolution GSM-device (for example. 1280x768, 350dpi or 10MP)',
			'resolution_screen'                   => 'Screenresolution GSM-device (for example. 1280x768 or 350dpi)',
			'screen_size'                         => 'Screensize in inches',
			'screen_type'                         => 'Type of screen (for example. LED/3D/etc.)',
			'size_length'                         => 'GSM-device length in mm',
			'size_width'                          => 'GSM-device width in mm',
			'subscription_price_internet'         => 'Price for extra internet bundle',
			'subscription_price_mms'              => 'Price for extra MMS bundle per month',
			'subscription_price_off_peakhours'    => 'Call rates off-peakhours per minute',
			'subscription_price_peakhours'        => 'Call rates peakhours per minute',
			'subscription_price_sms'              => 'Price per text message',
			'weight'                              => 'GSM-device weight in grams',
			'material_1'                          => 'The primary material',
			'material_2'                          => 'The secondary material',
			'material_3'                          => 'The tertiary material',
			'terms_conditions'                    => 'Full terms and conditions',
			'---5'                                => '',
		);
	}

	/**
	 * Daisycon Telecom: GSM only Attribute List
	 *
	 * @return array
	 */
	public function daisycon_telecom_gsmAttributes() {
		return array(
			'--1'                    => 'Required Attributes',
			'description'            => 'Description of the GSM-device',
			'link'                   => 'URL to the page of the GSM-device',
			'price'                  => 'Price of the GSM-device',
			'ku'                     => 'Unique GSM-device ID in the webshop',
			'title'                  => 'Complete name of the GSM-device',
			'---1'                   => '',
			'--2'                    => 'Highly Recommended Attributes',
			'category'               => 'Main category',
			'category_path'          => 'Category path',
			'color_primary'          => 'Primary color of the GSM-device',
			'condition'              => 'Product Condition',
			'delivery_time'          => 'Delivery time in days',
			'ean'                    => 'EAN',
			'google_category_id'     => 'Google category ID',
			'in_stock'               => 'Stock status',
			'in_stock_amount'        => 'Amount of items in stock',
			'mobile_device_brand'    => 'Brand of the GSM-device',
			'mobile_device_color'    => 'Color of the GSM-device specified by the manufacturer',
			'mobile_device_model'    => 'Modelname of the GSM-device (for example: iPhone 7)',
			'price_old'              => 'Old price [Regular Price]',
			'image_link_1'           => 'Main Image',
			'---2'                   => '',
			'--3'                    => 'Recommended Attributes',
			'price_shipping'         => 'Shipping costs',
			'image_link_2'           => 'Image 2',
			'image_link_3'           => 'Image 3',
			'image_link_4'           => 'Image 4',
			'image_link_5'           => 'Image 5',
			'image_link_6'           => 'Image 6',
			'image_link_7'           => 'Image 7',
			'image_link_8'           => 'Image 8',
			'image_link_9'           => 'Image 9',
			'---3'                   => '',
			'--5'                    => 'Optional Attributes',
			'additional_costs'       => 'Additional costs (for example: private copy levy)',
			'brand_logo'             => 'URL to an image of the brand logo',
			'delivery_description'   => 'Description of the delivery method',
			'description_short'      => 'Short product description',
			'device_connection_type' => 'Internetconnection type of the GSM-device (for example: 4G)',
			'device_simlock_network' => 'Does the GSM-device have an active simlock',
			'device_standby_time'    => 'Standby time of the GSM-device',
			'device_talk_time'       => 'Talk time of the GSM-device',
			'has_bluetooth'          => 'GSM-device has bluetooth',
			'has_camera'             => 'GSM-device has a camera',
			'has_radio'              => 'GSM-device has radio',
			'incentive'              => 'Incentive text (For example: an added gift)',
			'keywords'               => 'Keywords for this product',
			'priority'               => 'Priority of the product',
			'resolution_record'      => 'Camera recording resolution GSM-device(for example. 1280x768, 350dpi or 10MP)',
			'resolution_screen'      => 'Screenresolution GSM-device(for example. 1280x768 or 350dpi)',
			'screen_size'            => 'Screensize in inches',
			'screen_type'            => 'Type of screen (for example. LED/3D/etc.)',
			'size'                   => 'General field for size',
			'size_description'       => 'Description for the "size" field',
			'size_length'            => 'GSM-device length in mm',
			'size_width'             => 'GSM-device width in mm',

			'weight'                 => 'GSM-device weight in grams',
			'material_1'             => 'The primary material',
			'material_2'             => 'The secondary material',
			'material_3'             => 'The tertiary material',
			'terms_conditions'       => 'Full terms and conditions',
			'---5'                   => '',
		);
	}

	/**
	 * Daisycon Telecom: Sim only Attribute List
	 *
	 * @return array
	 */
	public function daisycon_telecom_simAttributes() {
		return array(
			'--1'                               => 'Required Attributes',
			'description'                       => 'Description of the subscription',
			'link'                              => 'URL to the page of the subscription',
			'price'                             => 'One-off costs of the subscription',
			'sku'                               => 'Unique subscription ID in the webshop',
			'title'                             => 'Complete name of the subscription',
			'---1'                              => '',
			'--2'                               => 'Highly Recommended Attributes',
			'bandwidth_download'                => 'Download speed in Mbits',
			'bandwidth_upload'                  => 'Upload speed in Mbits',
			'has_subscription_4g'               => 'Subscription has 4G availability',
			'provider'                          => 'Subscription provider',
			'subscription_allowance_data'       => 'Amount of MB\'s in the subscription',
			'subscription_allowance_minutes'    => 'Amount of minutes in the subscription',
			'subscription_allowance_sms'        => 'Amount of text messages in the subscription',
			'subscription_discount_duration'    => 'Discount duration in months',
			'subscription_discount_price'       => 'Calculated price (including discount)',
			'subscription_duration'             => 'Subscription length in months',
			'subscription_installation_costs'   => 'Installation costs',
			'subscription_price'                => 'Monthly subscription costs',
			'subscription_renewal'              => 'Is het abonnement een verlenging',
			'---2'                              => '',
			'--3'                               => 'Recommended Attributes',
			'category'                          => 'Main category',
			'category_path'                     => 'Category path',
			'delivery_time'                     => 'Delivery time in days',
			'ean'                               => 'EAN',
			'google_category_id'                => 'Google category ID',
			'in_stock'                          => 'Stock status',
			'in_stock_amount'                   => 'Amount of items in stock',
			'internet_only'                     => 'Is it an internet only subscription?',
			'network'                           => 'Mobile network of the subscription',
			'price_old'                         => 'Old price [Regular Price]',
			'price_shipping'                    => 'Shipping costs',
			'subscription_shared_data'          => 'Does the number for the amount of MB\'s data get shared with the amount of calltime / text messages',
			'subscription_shared_minutes'       => 'Does the number for the amount calltime get shared with the amount of text messages',
			'subscription_shared_sms'           => 'Does the number for the amount text messages get shared with the amount of calltime',
			'subscription_total_costs'          => 'Totale costs SIM subscription + GSM subscription x subscription length',
			'image_link_2'                      => 'Image 2',
			'image_link_3'                      => 'Image 3',
			'image_link_4'                      => 'Image 4',
			'image_link_5'                      => 'Image 5',
			'image_link_6'                      => 'Image 6',
			'image_link_7'                      => 'Image 7',
			'image_link_8'                      => 'Image 8',
			'image_link_9'                      => 'Image 9',
			'---3'                              => '',
			'--5'                               => 'Optional Attributes',
			'additional_costs'                  => 'Additional costs (for example: private copy levy)',
			'bandwidth_download_descr'          => 'Download speed fully written',
			'bandwidth_upload_descr'            => 'Upload speed fully written',
			'brand'                             => 'Brand',
			'brand_logo'                        => 'URL to an image of the brand logo',
			'delivery_description'              => 'Description of the delivery method',
			'internet_connection_type'          => 'Internetconnection type of the subscription (for example: 4G)',
			'keywords'                          => 'Keywords for this product',
			'priority'                          => 'Priority of the product',
			'size'                              => 'SIM-card format',
			'size_description'                  => 'Description SIM-card format',
			'subscription_discount'             => 'Amount of discount recieved',
			'subscription_discount_description' => 'Discount description',
			'subscription_name'                 => 'Name of the subscription',
			'subscription_price_internet'       => 'Price for extra internet bundle',
			'subscription_price_mms'            => 'Price for extra MMS bundle per month',
			'subscription_price_month_2'        => 'Price from the second month (if applicable)',
			'subscription_price_off_peakhours'  => 'Call rates off-peakhours per minute',
			'subscription_price_peakhours'      => 'Call rates peakhours per minute',
			'subscription_price_sms'            => 'Price per text message',
			'material_1'                        => 'The primary material',
			'material_2'                        => 'The secondary material',
			'material_3'                        => 'The tertiary material',
			'terms_conditions'                  => 'Full terms and conditions',
			'---5'                              => '',
		);
	}

	/**
	 * Daisycon Magazines Attribute List
	 *
	 * @return array
	 */
	public function daisycon_magazinesAttributes() {
		return array(
			'--1'                            => 'Required Attributes',
			'description'                    => 'Description of the magazine',
			'link'                           => 'URL to the page of the magazine',
			'price'                          => 'Price of the magazine',
			'sku'                            => 'Unique magazine ID in the webshop',
			'title'                          => 'Complete name of the magazine',
			'---1'                           => '',
			'--2'                            => 'Highly Recommended Attributes',
			'author'                         => 'Name of the aothor',
			'category'                       => 'Main category',
			'category_path'                  => 'Category path',
			'delivery_time'                  => 'Delivery time in days',
			'ean'                            => 'EAN',
			'google_category_id'             => 'Google category ID',
			'in_stock'                       => 'Stock status',
			'in_stock_amount'                => 'Amount of items in stock',
			'isbn'                           => 'ISBN of the magazine',
			'magazine_name'                  => 'Name of the magazine',
			'magazine_subscription_duration' => 'Duration of the magazine subscription',
			'magazine_subscription_type'     => 'Type of subscriptioncontinuous sample',
			'price_old'                      => 'Old price [Regular Price]',
			'image_link_1'                   => 'Main Image',
			'---2'                           => '',
			'--3'                            => 'Recommended Attributes',
			'price_shipping'                 => 'Shipping costs',
			'image_link_2'                   => 'Image 2',
			'image_link_3'                   => 'Image 3',
			'image_link_4'                   => 'Image 4',
			'image_link_5'                   => 'Image 5',
			'image_link_6'                   => 'Image 6',
			'image_link_7'                   => 'Image 7',
			'image_link_8'                   => 'Image 8',
			'image_link_9'                   => 'Image 9',
			'---3'                           => '',
			'--4'                            => 'Low Priority Attributes',
			'gender_target'                  => 'Gender to which the magazine is aimed',
			'magazine_publisher'             => 'Publisher of the magazine',
			'---4'                           => '',
			'--5'                            => 'Optional Attributes',
			'additional_costs'               => 'Additional costs',
			'brand_logo'                     => 'URL to an image of the brand logo',
			'color_primary'                  => 'Primary color of the magazine',
			'condition'                      => 'Product Condition',
			'delivery_description'           => 'Description of the delivery method',
			'file_size'                      => 'Total filesize in kbps',
			'file_type'                      => 'Filetype (for example: epub)',
			'keywords'                       => 'Keywords for this product',
			'language'                       => 'Language of the product',
			'magazine_gift'                  => 'Can the magazine be ordered as a gift?',
			'magazine_id'                    => 'Magazine ID',
			'magazine_type'                  => 'Magazine typemagazine e-magazine',
			'magazine_per_year'              => 'Amount of magazines per year',
			'model'                          => 'Model name/number',
			'priority'                       => 'Priority of the product',
			'size'                           => 'General field for size',
			'size_description'               => 'Description for the “size” field',
			'size_length'                    => 'Magazine length in mm',
			'size_width'                     => 'Magazine width in mm',
			'weight'                         => 'Weight in grams',
			'material_1'                     => 'The primary material',
			'material_2'                     => 'The secondary material',
			'material_3'                     => 'The tertiary material',
			'terms_conditions'               => 'Full terms and conditions',
			'---5'                           => '',
		);
	}

	/**
	 * Daisycon Holidays: Accommodations Attribute List
	 *
	 * @return array
	 */
	public function daisycon_holidays_accommodationsAttributes() {
		return array(
			'--1'                              => 'Required Attributes',
			'description'                      => 'Description of the product',
			'link'                             => 'URL to the page of the product',
			'price'                            => 'Price [Current/Sale Price]',
			'sku'                              => 'Unique Product ID [SKU]',
			'title'                            => 'Complete name of the product',
			'---1'                             => '',
			'--2'                              => 'Highly Recommended Attributes',
			'accommodation_address'            => 'Accommodation adress',
			'accommodation_name'               => 'Name of the accommodation',
			'accommodation_type'               => 'Accommodation type Aparthotel AppartmentBed & Breakfast Boat BungalowCamping Spot Caravan ChaletCruise Hostel Hotel HouseMobilehome Pension PousadaResort Studio Tent Villa',
			'arrival_date'                     => 'Date of arrival',
			'available'                        => 'Is the product available',
			'available_from'                   => 'From which date is the product available',
			'category'                         => 'Main category',
			'category_path'                    => 'Category path,',
			'delivery_time'                    => 'Delivery time in days',
			'departure_date'                   => 'Date of departure',
			'destination_city'                 => 'City of arrival',
			'destination_country'              => 'Country of arrival',
			'destination_latitude'             => 'Latitude of the arrival location (DDD.dddd formaat)',
			'destination_longitude'            => 'Longitude of the arrival location (DDD.dddd formaat)',
			'duration_days'                    => 'Amount of days for the stay',
			'duration_nights'                  => 'Amount of nights for the stay',
			'google_category_id'               => 'Google category ID',
			'in_stock'                         => 'Stock status',
			'in_stock_amount'                  => 'Amount of items in stock',
			'max_nr_people'                    => 'Maximum number of people allowed',
			'price_old'                        => 'Old price [Regular Price]',
			'star_rating'                      => 'Star rating of the accommodation',
			'travel_trip_type'                 => 'Travel trip typeInput Betekenis LG Logies LO Logies & Ontbijt HP Half Pension VP Vol Pension VB Volgens beschrijving AI All Inclusive',
			'trip_holiday_type'                => 'Holiday trip typeInput Betekenis citytrip Stedentripflydrive Fly & Drivelongtrip Verre Reissummer Zonvakantie tour Rondreiswinter Wintersport',
			'---2'                             => '',
			'--3'                              => 'Recommended Attributes',
			'price_shipping'                   => 'Shipping costs',
			'image_link_2'                     => 'Image 2',
			'image_link_3'                     => 'Image 3',
			'image_link_4'                     => 'Image 4',
			'image_link_5'                     => 'Image 5',
			'image_link_6'                     => 'Image 6',
			'image_link_7'                     => 'Image 7',
			'image_link_8'                     => 'Image 8',
			'image_link_9'                     => 'Image 9',
			'---3'                             => '',
			'--4'                              => 'Low Priority Attributes',
			'accommodation_lowest_date'        => 'First date that the accommodation is available',
			'accommodation_lowest_price'       => 'Lowest price for the accommodation',
			'---4'                             => '',
			'--5'                              => 'Optional Attributes',
			'accommodation_bathrooms'          => 'Amount of bathrooms in the accommodation',
			'accommodation_bedrooms'           => 'Amount of bedrooms in the accommodation',
			'accommodation_child_friendly'     => 'Is the accommodation child-friendly',
			'accommodation_floors'             => 'Amount of floors in the accommodation',
			'accommodation_on_holiday_park'    => 'Is the accommodation in a holiday park',
			'accommodation_pets_allowed'       => 'Are pets allowed at the acommodation',
			'accommodation_rooms'              => 'Amount of rooms in the accommodation',
			'accommodation_smoking_allowed'    => 'Is smoking allowed in the accommodation',
			'accommodation_sqm_floors'         => 'Accommodation surface area in m²',
			'accommodation_toilets'            => 'Amount of toilets in the accommodation',
			'additional_costs'                 => 'Additional costs',
			'brand'                            => 'Brand of the product',
			'brand_logo'                       => 'URL to an image of the brand logo',
			'delivery_description'             => 'Description of the delivery method',
			'destination_city_link'            => 'URL to the landingpage of the destination city',
			'destination_continent'            => 'Continent of arrival',
			'destination_country_description'  => 'Description of the continent of arrival',
			'destination_country_link'         => 'URL to the landingpage of the destination country',
			'destination_language'             => 'Language spoken in the destination country',
			'destination_location_description' => 'Description of the arrival location',
			'destination_port'                 => 'Port of arrival',
			'destination_region'               => 'Region of arrival',
			'destination_region_link'          => 'URL to the landingpage of the destination region',
			'destination_zipcode'              => 'Zipcode of the arrival location',
			'distance_to_bakery'               => 'Distance to the nearest bakery in meters',
			'distance_to_beach'                => 'Distance to the nearest beach in meters',
			'distance_to_citycenter'           => 'Distance to the nearest citycenter in meters',
			'distance_to_golfcourse'           => 'Distance to the nearest golfcourse in meters',
			'distance_to_restaurant'           => 'Distance to the nearest restaurant in meters',
			'distance_to_shopping'             => 'Distance to the nearest shopping centre in meters',
			'distance_to_swimwater'            => 'Distance to the nearest swimwater in meters',
			'ean'                              => 'EAN',
			'gender_target'                    => 'Gender to which the product is aimed',
			'has_airco'                        => 'Is there an airconditioning system present',
			'has_barbecue'                     => 'Is there a barbecue present',
			'has_child_chair'                  => 'Is there a child-chair present',
			'has_dishwasher'                   => 'Is there a dishwasher present',
			'has_electricity'                  => 'Is electricity present',
			'has_garage'                       => 'Is there a garage present',
			'has_garden'                       => 'Is there a garden present',
			'has_heating'                      => 'Is there heating present',
			'has_internet'                     => 'Is there internet present',
			'has_livingroom'                   => 'Does the accommodation have a living room',
			'has_microwave'                    => 'Is there a microwave present',
			'has_playground'                   => 'Is there a playground present',
			'has_sauna'                        => 'Is there a sauna present',
			'has_swimmingpool'                 => 'Is there a pool present',
			'has_telephone'                    => 'Is there a phone present',
			'has_television'                   => 'Is there a television present',
			'has_washingmachine'               => 'Is there a washing machine present',
			'keywords'                         => 'Keywords for this product',
			'model'                            => 'Model name/number',
			'priority'                         => 'Priority of the product',
			'size'                             => 'General field for size',
			'size_description'                 => 'Description for the “size” field',
			'material_1'                       => 'The primary material',
			'material_2'                       => 'The secondary material',
			'material_3'                       => 'The tertiary material',
			'terms_conditions'                 => 'Full terms and conditions',
			'---5'                             => '',
		);
	}

	/**
	 * Daisycon Holidays: Accommodations and transport Attribute List
	 *
	 * @return array
	 */
	public function daisycon_holidays_accommodations_and_transportAttributes() {
		return array(
			'--1'                              => 'Required Attributes',
			'description'                      => 'Description of the product',
			'link'                             => 'URL to the page of the product',
			'price'                            => 'Price [Current/Sale Price]',
			'sku'                              => 'Unique Product ID [SKU]',
			'title'                            => 'Complete name of the product',
			'---1'                             => '',
			'--2'                              => 'Highly Recommended Attributes',
			'accommodation_address'            => 'Accommodation adress',
			'accommodation_name'               => 'Name of the accommodation',
			'accommodation_type'               => 'Accommodation type Aparthotel AppartmentBed & Breakfast Boat BungalowCamping Spot Caravan ChaletCruise Hostel Hotel HouseMobilehome Pension PousadaResort Studio Tent Villa',
			'airline_code'                     => 'IATA Airline Code',
			'airport_departure'                => 'Airport of departure',
			'airport_destination'              => 'Airport of arrival',
			'airportcode_departure'            => 'IATA Airline Code of departure (3 letters)',
			'airportcode_destination'          => 'IATA Airline Code of arrival (3 letters)',
			'available'                        => 'Is the product available',
			'available_from'                   => 'From which date is the product available',
			'category'                         => 'Main category',
			'category_path'                    => 'Category path,',
			'delivery_time'                    => 'Delivery time in days',
			'departure_city'                   => 'City of departure',
			'departure_date'                   => 'Departure date',
			'departure_latitude'               => 'Latitude of the departure location (DDD.dddd formaat)',
			'departure_longitude'              => 'Longitude of the departure location (DDD.dddd formaat)',
			'departure_time'                   => 'Time of departure',
			'departure_times'                  => 'All possible departure times',
			'destination_city'                 => 'City of arrival',
			'destination_country'              => 'Country of arrival',
			'destination_latitude'             => 'Latitude of the arrival location (DDD.dddd formaat)',
			'destination_longitude'            => 'Longitude of the arrival location (DDD.dddd formaat)',
			'duration_days'                    => 'Amount of days of the stay at the accommodation',
			'duration_nights'                  => 'Amount of nights of the stay at the accommodation',
			'google_category_id'               => 'Google category ID',
			'in_stock'                         => 'Stock status',
			'in_stock_amount'                  => 'Amount of items in stock',
			'max_nr_people'                    => 'Maximum number of people allowed',
			'price_old'                        => 'Old price [Regular Price]',
			'travel_tour_operator'             => 'Name of the touroperator',
			'travel_transportation_type'       => 'Type of transportInput Betekenis BO BootBU BusEV Eigen VervoerTR Trein VL Vliegtuig',
			'travel_trip_type'                 => 'Travel trip typeInput Betekenis LG Logies LO Logies & Ontbijt HP Half Pension VP Vol Pension VB Volgens beschrijving AI All Inclusive',
			'trip_holiday_type'                => 'Holiday trip typeInput Betekenis citytrip Stedentripflydrive Fly & Drivelongtrip Verre Reissummer Zonvakantie tour Rondreiswinter Wintersport',
			'---2'                             => '',
			'--3'                              => 'Recommended Attributes',
			'accommodation_lowest_date'        => 'First date that the accommodation is available',
			'accommodation_lowest_price'       => 'Lowest price for the accommodation',
			'price_shipping'                   => 'Shipping costs',
			'trip_lastminute'                  => 'Is it a lastminute trip',
			'image_link_2'                     => 'Image 2',
			'image_link_3'                     => 'Image 3',
			'image_link_4'                     => 'Image 4',
			'image_link_5'                     => 'Image 5',
			'image_link_6'                     => 'Image 6',
			'image_link_7'                     => 'Image 7',
			'image_link_8'                     => 'Image 8',
			'image_link_9'                     => 'Image 9',
			'---3'                             => '',
			'--5'                              => 'Optional Attributes',
			'accommodation_bathrooms'          => 'Amount of bathrooms in the accommodation',
			'accommodation_bedrooms'           => 'Amount of bedrooms in the accommodation',
			'accommodation_child_friendly'     => 'Is the accommodation child-friendly',
			'accommodation_floors'             => 'Amount of floors in the accommodation',
			'accommodation_on_holiday_park'    => 'Is the accommodation in a holiday park',
			'accommodation_pets_allowed'       => 'Are pets allowed at the acommodation',
			'accommodation_rooms'              => 'Amount of rooms in the accommodation',
			'accommodation_smoking_allowed'    => 'Is smoking allowed in the accommodation',
			'accommodation_sqm_floors'         => 'Accommodation surface area in m²',
			'accommodation_toilets'            => 'Amount of toilets in the accommodation',
			'additional_costs'                 => 'Additional costs',
			'arrival_date'                     => 'Date of arrival',
			'brand'                            => 'Brand of the product',
			'brand_logo'                       => 'URL to an image of the brand logo',
			'delivery_description'             => 'Description of the delivery method',
			'departure_continent'              => 'Continent of departure',
			'departure_country'                => 'Country of departure',
			'departure_date_price'             => 'Price for this departure date',
			'departure_port'                   => 'Port of departure',
			'departure_region'                 => 'Region of departure',
			'destination_city_link'            => 'URL to the landingpage of the destination city',
			'destination_continent'            => 'Continent of arrival',
			'destination_country_description'  => 'Description of the country of arrival',
			'destination_country_link'         => 'URL to the landingpage of the destination country',
			'destination_language'             => 'Language spoken in the destination country',
			'destination_location_description' => 'Description of the arrival location',
			'destination_port'                 => 'Port of arrival',
			'destination_region'               => 'Region of arrival',
			'destination_region_link'          => 'URL to the landingpage of the destination region',
			'destination_zipcode'              => 'Zipcode of the arrival location',
			'distance_to_bakery'               => 'Distance to the nearest bakery in meters',
			'distance_to_beach'                => 'Distance to the nearest beach in meters',
			'distance_to_citycenter'           => 'Distance to the nearest citycenter in meters',
			'distance_to_golfcourse'           => 'Distance to the nearest golfcourse in meters',
			'distance_to_restaurant'           => 'Distance to the nearest restaurant in meters',
			'distance_to_shopping'             => 'Distance to the nearest shopping centre in meters',
			'distance_to_swimwater'            => 'Distance to the nearest swimwater in meters',
			'ean'                              => 'EAN',
			'gender_target'                    => 'Gender to which the product is aimed',
			'has_airco'                        => 'Is there an airconditioning system present',
			'has_barbecue'                     => 'Is there a barbecue present',
			'has_child_chair'                  => 'Is there a child-chair present',
			'has_dishwasher'                   => 'Is there a dishwasher present',
			'has_electricity'                  => 'Is electricity present',
			'has_garage'                       => 'Is there a garage present',
			'has_garden'                       => 'Is there a garden present',
			'has_heating'                      => 'Is there heating present',
			'has_internet'                     => 'Is there internet present',
			'has_livingroom'                   => 'Does the accommodation have a living room',
			'has_microwave'                    => 'Is there a microwave present',
			'has_playground'                   => 'Is there a playground present',
			'has_sauna'                        => 'Is there a sauna present',
			'has_swimmingpool'                 => 'Is there a pool present',
			'has_telephone'                    => 'Is there a phone present',
			'has_television'                   => 'Is there a television present',
			'has_washingmachine'               => 'Is there a washing machine present',
			'keywords'                         => 'Keywords for this product',
			'model'                            => 'Model name/number',
			'priority'                         => 'Priority of the product',
			'size'                             => 'General field for size',
			'size_description'                 => 'Description for the “size” field',
			'star_rating'                      => 'Star rating of the accommodation',
			'material_1'                       => 'The primary material',
			'material_2'                       => 'The secondary material',
			'material_3'                       => 'The tertiary material',
			'terms_conditions'                 => 'Full terms and conditions',
			'---5'                             => '',
		);
	}

	/**
	 * Daisycon Holidays: Trips Attribute List
	 *
	 * @return array
	 */
	public function daisycon_holidays_tripsAttributes() {
		return array(
			'--1'                            => 'Required Attributes',
			'description'                    => 'Description of the product',
			'link'                           => 'URL to the page of the product',
			'price'                          => 'Price [Current/Sale Price]',
			'sku'                            => 'Unique Product ID [SKU]',
			'title'                          => 'Complete name of the product',
			'airline_code'                   => 'IATA Airline Code',
			'airline_code_return'            => 'IATA Airline Code return trip',
			'---1'                           => '',
			'--2'                            => 'Highly Recommended Attributes',
			'airport_departure'              => 'Airport of departure',
			'airport_destination'            => 'Airport of arrival',
			'airportcode_departure'          => 'Airport (IATA) code of departure (3 letters)',
			'airportcode_destination'        => 'Airport (IATA) code of arrival (3 letters)',
			'category'                       => 'Main category',
			'category_path'                  => 'Category path,',
			'delivery_time'                  => 'Delivery time in days',
			'departure_city'                 => 'City of departure',
			'departure_date'                 => 'Date of departure',
			'departure_times'                => 'All possible departure times',
			'destination_city'               => 'City of arrival',
			'destination_country'            => 'Country of arrival',
			'destination_latitude'           => 'Latitude of the arrival location (DDD.dddd formaat)',
			'destination_longitude'          => 'Longitude of the arrival location (DDD.dddd formaat)',
			'duration_days'                  => 'Amount of days of the stay at the accommodation',
			'duration_nights'                => 'Amount of nights of the stay at the accommodation',
			'google_category_id'             => 'Google category ID',
			'in_stock'                       => 'Stock status',
			'in_stock_amount'                => 'Amount of items in stock',
			'price_old'                      => 'Old price [Regular Price]',
			'travel_tour_operator'           => 'Name of the touroperator',
			'travel_transportation_type'     => 'Type of transportInput Betekenis BO BootBU BusEV Eigen VervoerTR Trein VL Vliegtuig',
			'---2'                           => '',
			'--3'                            => 'Recommended Attributes',
			'airport_departure_return'       => 'Airport of departure return trip',
			'airport_destination_return'     => 'Airport of departure return trip',
			'airportcode_departure_return'   => 'Airport (IATA) code of departure return trip (3 letters)',
			'airportcode_destination_return' => 'Airport (IATA) code of arrival return trip (3 letters)',
			'price_shipping'                 => 'Shipping costs',
			'trip_lastminute'                => 'Is it a lastminute trip',
			'image_link_2'                   => 'Image 2',
			'image_link_3'                   => 'Image 3',
			'image_link_4'                   => 'Image 4',
			'image_link_5'                   => 'Image 5',
			'image_link_6'                   => 'Image 6',
			'image_link_7'                   => 'Image 7',
			'image_link_8'                   => 'Image 8',
			'image_link_9'                   => 'Image 9',
			'---3'                           => '',
			'--5'                            => 'Optional Attributes',
			'additional_costs'               => 'Additional costs',
			'brand'                          => 'Brand of the product',
			'brand_logo'                     => 'URL to an image of the brand logo',
			'delivery_description'           => 'Description of the delivery method',
			'departure_country'              => 'Country of departure',
			'departure_date_return'          => 'Date of departure return trip',
			'departure_port'                 => 'Port of departure',
			'destination_city_link'          => 'URL to the landingpage of the destination city',
			'destination_continent'          => 'Continent of arrival',
			'destination_country_link'       => 'URL to the landingpage of the destination country',
			'destination_port'               => 'Port of arrival',
			'destination_region'             => 'Region of arrival',
			'destination_region_link'        => 'URL to the landingpage of the destination region',
			'ean'                            => 'EAN',
			'gender_target'                  => 'Gender to which the product is aimed',
			'keywords'                       => 'Keywords for this product',
			'model'                          => 'Model name/number',
			'priority'                       => 'Priority of the product',
			'size'                           => 'General field for size',
			'size_description'               => 'Description for the “size” field',
			'material_1'                     => 'The primary material',
			'material_2'                     => 'The secondary material',
			'material_3'                     => 'The tertiary material',
			'terms_conditions'               => 'Full terms and conditions',
			'---5'                           => '',
		);
	}

	/**
	 * Daisycon Work & Jobs Attribute List
	 *
	 * @return array
	 */
	public function daisycon_work_jobsAttributes() {
		return array(
			'--1'                  => 'Required Attributes',
			'description'          => 'Description of the product',
			'link'                 => 'URL to the page of the product',
			'price'                => 'Price [Current/Sale Price]',
			'sku'                  => 'Unique Product ID [SKU]',
			'title'                => 'Complete name of the product',
			'---1'                 => '',
			'--2'                  => 'Highly Recommended Attributes',
			'category'             => 'Main category',
			'category_path'        => 'Category path,',
			'company_description'  => 'Description of the organisation',
			'company_name'         => 'Name of the organisation',
			'google_category_id'   => 'Google category ID',
			'in_stock'             => 'Stock status',
			'in_stock_amount'      => 'Amount of items in stock',
			'job_education'        => 'Required educational level for the job',
			'job_experience'       => 'Required job experience for the job',
			'job_industry'         => 'Industry field of the job',
			'job_location_city'    => 'City of the job occupation',
			'job_location_country' => 'Country of the job occupation',
			'job_salary_from'      => 'Start salary for the job',
			'job_salary_per'       => 'Is the salary daily/weekly/monthly/yearly',
			'job_salary_to'        => 'Maximum salary for the job',
			'job_skills'           => 'Required skills for the job',
			'job_type'             => 'Terms of employment (definite/indefinite)',
			'---2'                 => '',
			'--3'                  => 'Recommended Attributes',
			'available_from'       => 'From which date is the product available',
			'job_location_region'  => 'Region of the job occupation',
			'job_location_zipcode' => 'Zipcode of the job\'s location',
			'image_link_2'         => 'Image 2',
			'image_link_3'         => 'Image 3',
			'image_link_4'         => 'Image 4',
			'image_link_5'         => 'Image 5',
			'image_link_6'         => 'Image 6',
			'image_link_7'         => 'Image 7',
			'image_link_8'         => 'Image 8',
			'image_link_9'         => 'Image 9',
			'---3'                 => '',
			'--5'                  => 'Optional Attributes',
			'additional_costs'     => 'Additional costs',
			'brand'                => 'Brand of the product',
			'brand_logo'           => 'URL to an image of the brand logo',
			'color_primary'        => 'Primary color of the product',
			'delivery_description' => 'Description of the delivery method',
			'delivery_time'        => 'Delivery time in days',
			'ean'                  => 'EAN',
			'gender_target'        => 'Gender to which the product is aimed',
			'keywords'             => 'Keywords for this product',
			'model'                => 'Model name/number',
			'price_old'            => 'Old price [Regular Price]',
			'price_shipping'       => 'Shipping costs',
			'priority'             => 'Priority of the product',
			'size'                 => 'General field for size',
			'size_description'     => 'Description for the “size” field',
			'material_1'           => 'The primary material',
			'material_2'           => 'The secondary material',
			'material_3'           => 'The tertiary material',
			'terms_conditions'     => 'Full terms and conditions',
			'---5'                 => '',
		);
	}
}
