<?php
namespace Aws\Backup;

use Aws\AwsClient;

/**
 * This client is used to interact with the **AWS Backup** service.
 * @method \Aws\Result createBackupPlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createBackupPlanAsync(array $args = [])
 * @method \Aws\Result createBackupSelection(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createBackupSelectionAsync(array $args = [])
 * @method \Aws\Result createBackupVault(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createBackupVaultAsync(array $args = [])
 * @method \Aws\Result createFramework(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createFrameworkAsync(array $args = [])
 * @method \Aws\Result createReportPlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createReportPlanAsync(array $args = [])
 * @method \Aws\Result deleteBackupPlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteBackupPlanAsync(array $args = [])
 * @method \Aws\Result deleteBackupSelection(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteBackupSelectionAsync(array $args = [])
 * @method \Aws\Result deleteBackupVault(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteBackupVaultAsync(array $args = [])
 * @method \Aws\Result deleteBackupVaultAccessPolicy(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteBackupVaultAccessPolicyAsync(array $args = [])
 * @method \Aws\Result deleteBackupVaultLockConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteBackupVaultLockConfigurationAsync(array $args = [])
 * @method \Aws\Result deleteBackupVaultNotifications(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteBackupVaultNotificationsAsync(array $args = [])
 * @method \Aws\Result deleteFramework(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteFrameworkAsync(array $args = [])
 * @method \Aws\Result deleteRecoveryPoint(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteRecoveryPointAsync(array $args = [])
 * @method \Aws\Result deleteReportPlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteReportPlanAsync(array $args = [])
 * @method \Aws\Result describeBackupJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeBackupJobAsync(array $args = [])
 * @method \Aws\Result describeBackupVault(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeBackupVaultAsync(array $args = [])
 * @method \Aws\Result describeCopyJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeCopyJobAsync(array $args = [])
 * @method \Aws\Result describeFramework(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeFrameworkAsync(array $args = [])
 * @method \Aws\Result describeGlobalSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeGlobalSettingsAsync(array $args = [])
 * @method \Aws\Result describeProtectedResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeProtectedResourceAsync(array $args = [])
 * @method \Aws\Result describeRecoveryPoint(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeRecoveryPointAsync(array $args = [])
 * @method \Aws\Result describeRegionSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeRegionSettingsAsync(array $args = [])
 * @method \Aws\Result describeReportJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeReportJobAsync(array $args = [])
 * @method \Aws\Result describeReportPlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeReportPlanAsync(array $args = [])
 * @method \Aws\Result describeRestoreJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeRestoreJobAsync(array $args = [])
 * @method \Aws\Result disassociateRecoveryPoint(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise disassociateRecoveryPointAsync(array $args = [])
 * @method \Aws\Result exportBackupPlanTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise exportBackupPlanTemplateAsync(array $args = [])
 * @method \Aws\Result getBackupPlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getBackupPlanAsync(array $args = [])
 * @method \Aws\Result getBackupPlanFromJSON(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getBackupPlanFromJSONAsync(array $args = [])
 * @method \Aws\Result getBackupPlanFromTemplate(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getBackupPlanFromTemplateAsync(array $args = [])
 * @method \Aws\Result getBackupSelection(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getBackupSelectionAsync(array $args = [])
 * @method \Aws\Result getBackupVaultAccessPolicy(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getBackupVaultAccessPolicyAsync(array $args = [])
 * @method \Aws\Result getBackupVaultNotifications(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getBackupVaultNotificationsAsync(array $args = [])
 * @method \Aws\Result getRecoveryPointRestoreMetadata(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getRecoveryPointRestoreMetadataAsync(array $args = [])
 * @method \Aws\Result getSupportedResourceTypes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSupportedResourceTypesAsync(array $args = [])
 * @method \Aws\Result listBackupJobs(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listBackupJobsAsync(array $args = [])
 * @method \Aws\Result listBackupPlanTemplates(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listBackupPlanTemplatesAsync(array $args = [])
 * @method \Aws\Result listBackupPlanVersions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listBackupPlanVersionsAsync(array $args = [])
 * @method \Aws\Result listBackupPlans(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listBackupPlansAsync(array $args = [])
 * @method \Aws\Result listBackupSelections(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listBackupSelectionsAsync(array $args = [])
 * @method \Aws\Result listBackupVaults(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listBackupVaultsAsync(array $args = [])
 * @method \Aws\Result listCopyJobs(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listCopyJobsAsync(array $args = [])
 * @method \Aws\Result listFrameworks(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listFrameworksAsync(array $args = [])
 * @method \Aws\Result listProtectedResources(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listProtectedResourcesAsync(array $args = [])
 * @method \Aws\Result listRecoveryPointsByBackupVault(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listRecoveryPointsByBackupVaultAsync(array $args = [])
 * @method \Aws\Result listRecoveryPointsByResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listRecoveryPointsByResourceAsync(array $args = [])
 * @method \Aws\Result listReportJobs(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listReportJobsAsync(array $args = [])
 * @method \Aws\Result listReportPlans(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listReportPlansAsync(array $args = [])
 * @method \Aws\Result listRestoreJobs(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listRestoreJobsAsync(array $args = [])
 * @method \Aws\Result listTags(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTagsAsync(array $args = [])
 * @method \Aws\Result putBackupVaultAccessPolicy(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putBackupVaultAccessPolicyAsync(array $args = [])
 * @method \Aws\Result putBackupVaultLockConfiguration(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putBackupVaultLockConfigurationAsync(array $args = [])
 * @method \Aws\Result putBackupVaultNotifications(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise putBackupVaultNotificationsAsync(array $args = [])
 * @method \Aws\Result startBackupJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise startBackupJobAsync(array $args = [])
 * @method \Aws\Result startCopyJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise startCopyJobAsync(array $args = [])
 * @method \Aws\Result startReportJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise startReportJobAsync(array $args = [])
 * @method \Aws\Result startRestoreJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise startRestoreJobAsync(array $args = [])
 * @method \Aws\Result stopBackupJob(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise stopBackupJobAsync(array $args = [])
 * @method \Aws\Result tagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise tagResourceAsync(array $args = [])
 * @method \Aws\Result untagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise untagResourceAsync(array $args = [])
 * @method \Aws\Result updateBackupPlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateBackupPlanAsync(array $args = [])
 * @method \Aws\Result updateFramework(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateFrameworkAsync(array $args = [])
 * @method \Aws\Result updateGlobalSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateGlobalSettingsAsync(array $args = [])
 * @method \Aws\Result updateRecoveryPointLifecycle(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateRecoveryPointLifecycleAsync(array $args = [])
 * @method \Aws\Result updateRegionSettings(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateRegionSettingsAsync(array $args = [])
 * @method \Aws\Result updateReportPlan(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateReportPlanAsync(array $args = [])
 */
class BackupClient extends AwsClient {}
