<?php
namespace Aws\CognitoIdentity;

use Aws\AwsClient;

/**
 * This client is used to interact with the **Amazon Cognito Identity** service.
 *
 * @method \Aws\Result createIdentityPool(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createIdentityPoolAsync(array $args = [])
 * @method \Aws\Result deleteIdentities(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteIdentitiesAsync(array $args = [])
 * @method \Aws\Result deleteIdentityPool(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteIdentityPoolAsync(array $args = [])
 * @method \Aws\Result describeIdentity(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeIdentityAsync(array $args = [])
 * @method \Aws\Result describeIdentityPool(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise describeIdentityPoolAsync(array $args = [])
 * @method \Aws\Result getCredentialsForIdentity(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getCredentialsForIdentityAsync(array $args = [])
 * @method \Aws\Result getId(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getIdAsync(array $args = [])
 * @method \Aws\Result getIdentityPoolRoles(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getIdentityPoolRolesAsync(array $args = [])
 * @method \Aws\Result getOpenIdToken(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getOpenIdTokenAsync(array $args = [])
 * @method \Aws\Result getOpenIdTokenForDeveloperIdentity(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getOpenIdTokenForDeveloperIdentityAsync(array $args = [])
 * @method \Aws\Result getPrincipalTagAttributeMap(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getPrincipalTagAttributeMapAsync(array $args = [])
 * @method \Aws\Result listIdentities(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listIdentitiesAsync(array $args = [])
 * @method \Aws\Result listIdentityPools(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listIdentityPoolsAsync(array $args = [])
 * @method \Aws\Result listTagsForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTagsForResourceAsync(array $args = [])
 * @method \Aws\Result lookupDeveloperIdentity(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise lookupDeveloperIdentityAsync(array $args = [])
 * @method \Aws\Result mergeDeveloperIdentities(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise mergeDeveloperIdentitiesAsync(array $args = [])
 * @method \Aws\Result setIdentityPoolRoles(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise setIdentityPoolRolesAsync(array $args = [])
 * @method \Aws\Result setPrincipalTagAttributeMap(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise setPrincipalTagAttributeMapAsync(array $args = [])
 * @method \Aws\Result tagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise tagResourceAsync(array $args = [])
 * @method \Aws\Result unlinkDeveloperIdentity(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise unlinkDeveloperIdentityAsync(array $args = [])
 * @method \Aws\Result unlinkIdentity(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise unlinkIdentityAsync(array $args = [])
 * @method \Aws\Result untagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise untagResourceAsync(array $args = [])
 * @method \Aws\Result updateIdentityPool(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise updateIdentityPoolAsync(array $args = [])
 */
class CognitoIdentityClient extends AwsClient {}
