<?php
namespace Aws\Sns;

use Aws\AwsClient;

/**
 * This client is used to interact with the **Amazon Simple Notification Service (Amazon SNS)**.
 *
 * @method \Aws\Result addPermission(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise addPermissionAsync(array $args = [])
 * @method \Aws\Result checkIfPhoneNumberIsOptedOut(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise checkIfPhoneNumberIsOptedOutAsync(array $args = [])
 * @method \Aws\Result confirmSubscription(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise confirmSubscriptionAsync(array $args = [])
 * @method \Aws\Result createPlatformApplication(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createPlatformApplicationAsync(array $args = [])
 * @method \Aws\Result createPlatformEndpoint(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createPlatformEndpointAsync(array $args = [])
 * @method \Aws\Result createSMSSandboxPhoneNumber(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createSMSSandboxPhoneNumberAsync(array $args = [])
 * @method \Aws\Result createTopic(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise createTopicAsync(array $args = [])
 * @method \Aws\Result deleteEndpoint(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteEndpointAsync(array $args = [])
 * @method \Aws\Result deletePlatformApplication(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deletePlatformApplicationAsync(array $args = [])
 * @method \Aws\Result deleteSMSSandboxPhoneNumber(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteSMSSandboxPhoneNumberAsync(array $args = [])
 * @method \Aws\Result deleteTopic(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise deleteTopicAsync(array $args = [])
 * @method \Aws\Result getEndpointAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getEndpointAttributesAsync(array $args = [])
 * @method \Aws\Result getPlatformApplicationAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getPlatformApplicationAttributesAsync(array $args = [])
 * @method \Aws\Result getSMSAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSMSAttributesAsync(array $args = [])
 * @method \Aws\Result getSMSSandboxAccountStatus(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSMSSandboxAccountStatusAsync(array $args = [])
 * @method \Aws\Result getSubscriptionAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getSubscriptionAttributesAsync(array $args = [])
 * @method \Aws\Result getTopicAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise getTopicAttributesAsync(array $args = [])
 * @method \Aws\Result listEndpointsByPlatformApplication(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listEndpointsByPlatformApplicationAsync(array $args = [])
 * @method \Aws\Result listOriginationNumbers(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listOriginationNumbersAsync(array $args = [])
 * @method \Aws\Result listPhoneNumbersOptedOut(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listPhoneNumbersOptedOutAsync(array $args = [])
 * @method \Aws\Result listPlatformApplications(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listPlatformApplicationsAsync(array $args = [])
 * @method \Aws\Result listSMSSandboxPhoneNumbers(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listSMSSandboxPhoneNumbersAsync(array $args = [])
 * @method \Aws\Result listSubscriptions(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listSubscriptionsAsync(array $args = [])
 * @method \Aws\Result listSubscriptionsByTopic(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listSubscriptionsByTopicAsync(array $args = [])
 * @method \Aws\Result listTagsForResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTagsForResourceAsync(array $args = [])
 * @method \Aws\Result listTopics(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise listTopicsAsync(array $args = [])
 * @method \Aws\Result optInPhoneNumber(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise optInPhoneNumberAsync(array $args = [])
 * @method \Aws\Result publish(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise publishAsync(array $args = [])
 * @method \Aws\Result publishBatch(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise publishBatchAsync(array $args = [])
 * @method \Aws\Result removePermission(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise removePermissionAsync(array $args = [])
 * @method \Aws\Result setEndpointAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise setEndpointAttributesAsync(array $args = [])
 * @method \Aws\Result setPlatformApplicationAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise setPlatformApplicationAttributesAsync(array $args = [])
 * @method \Aws\Result setSMSAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise setSMSAttributesAsync(array $args = [])
 * @method \Aws\Result setSubscriptionAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise setSubscriptionAttributesAsync(array $args = [])
 * @method \Aws\Result setTopicAttributes(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise setTopicAttributesAsync(array $args = [])
 * @method \Aws\Result subscribe(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise subscribeAsync(array $args = [])
 * @method \Aws\Result tagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise tagResourceAsync(array $args = [])
 * @method \Aws\Result unsubscribe(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise unsubscribeAsync(array $args = [])
 * @method \Aws\Result untagResource(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise untagResourceAsync(array $args = [])
 * @method \Aws\Result verifySMSSandboxPhoneNumber(array $args = [])
 * @method \WPLab\GuzzeHttp\Promise\Promise verifySMSSandboxPhoneNumberAsync(array $args = [])
 */
class SnsClient extends AwsClient {}
