<?php
/**
 * Background Pattern Style - Zig Zag 2.
 *
 * @package Divi
 * @sub-package Builder
 * @since 4.15.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

/**
 * Class ET_Builder_Pattern_Zig_Zag_2
 *
 * @since 4.15.0
 */
class ET_Builder_Pattern_Zig_Zag_2 extends ET_Builder_Background_Pattern_Style_Base {
	/**
	 * Configuration.
	 *
	 * @return array
	 */
	public function settings() {
		return array(
			'label'      => esc_html__( 'Zig Zag 2', 'et-builder' ),
			'svgContent' => array(
				'default'          => '<path d="M0,35,56,0l56,35v5L56,5,0,40Z"/>',
				'default-inverted' => '<path d="M0,0H56L0,35ZM112,0H56l56,35Zm0,40L56,5,0,40Z"/>',
				'rotated'          => '<path d="M35,112,0,56,35,0h5L5,56l35,56Z"/>',
				'rotated-inverted' => '<path d="M0,112V56l35,56ZM0,0V56L35,0ZM40,0,5,56l35,56Z"/>',
				'thumbnail'        => '<path d="M80,6.56V7.5L70,.94,60,7.5,50,.94,40,7.5,30,.94,20,7.5,10,.94,0,7.5V6.56L10,0,20,6.56,30,0,40,6.56,50,0,60,6.56,70,0ZM70,7.5,60,14.06,50,7.5,40,14.06,30,7.5,20,14.06,10,7.5,0,14.06V15L10,8.44,20,15,30,8.44,40,15,50,8.44,60,15,70,8.44,80,15v-.94ZM70,15,60,21.56,50,15,40,21.56,30,15,20,21.56,10,15,0,21.56v.94l10-6.56L20,22.5l10-6.56L40,22.5l10-6.56L60,22.5l10-6.56L80,22.5v-.94Zm0,7.5L60,29.06,50,22.5,40,29.06,30,22.5,20,29.06,10,22.5,0,29.06V30l10-6.56L20,30l10-6.56L40,30l10-6.56L60,30l10-6.56L80,30v-.94ZM70,30,60,36.56,50,30,40,36.56,30,30,20,36.56,10,30,0,36.56v.94l10-6.56L20,37.5l10-6.56L40,37.5l10-6.56L60,37.5l10-6.56L80,37.5v-.94Zm0,7.5L60,44.06,50,37.5,40,44.06,30,37.5,20,44.06,10,37.5,0,44.06V45l10-6.56L20,45l10-6.56L40,45l10-6.56L60,45l10-6.56L80,45v-.94ZM70,45,60,51.56,50,45,40,51.56,30,45,20,51.56,10,45,0,51.56v.94l10-6.56L20,52.5l10-6.56L40,52.5l10-6.56L60,52.5l10-6.56L80,52.5v-.94Zm0,7.5L60,59.06,50,52.5,40,59.06,30,52.5,20,59.06,10,52.5,0,59.06V60l10-6.56L20,60l10-6.56L40,60l10-6.56L60,60l10-6.56L80,60v-.94Z"/>',
			),
			'width'      => '112px',
			'height'     => '40px',
		);
	}
}

return new ET_Builder_Pattern_Zig_Zag_2();
